/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobQueueSnapshotResponse extends BatchResponse implements
        ToCopyableBuilder<GetJobQueueSnapshotResponse.Builder, GetJobQueueSnapshotResponse> {
    private static final SdkField<FrontOfQueueDetail> FRONT_OF_QUEUE_FIELD = SdkField
            .<FrontOfQueueDetail> builder(MarshallingType.SDK_POJO).memberName("frontOfQueue")
            .getter(getter(GetJobQueueSnapshotResponse::frontOfQueue)).setter(setter(Builder::frontOfQueue))
            .constructor(FrontOfQueueDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frontOfQueue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRONT_OF_QUEUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("frontOfQueue", FRONT_OF_QUEUE_FIELD);
                }
            });

    private final FrontOfQueueDetail frontOfQueue;

    private GetJobQueueSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.frontOfQueue = builder.frontOfQueue;
    }

    /**
     * <p>
     * The list of the first 100 <code>RUNNABLE</code> jobs in each job queue. For first-in-first-out (FIFO) job queues,
     * jobs are ordered based on their submission time. For fair share scheduling (FSS) job queues, jobs are ordered
     * based on their job priority and share usage.
     * </p>
     * 
     * @return The list of the first 100 <code>RUNNABLE</code> jobs in each job queue. For first-in-first-out (FIFO) job
     *         queues, jobs are ordered based on their submission time. For fair share scheduling (FSS) job queues, jobs
     *         are ordered based on their job priority and share usage.
     */
    public final FrontOfQueueDetail frontOfQueue() {
        return frontOfQueue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frontOfQueue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobQueueSnapshotResponse)) {
            return false;
        }
        GetJobQueueSnapshotResponse other = (GetJobQueueSnapshotResponse) obj;
        return Objects.equals(frontOfQueue(), other.frontOfQueue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobQueueSnapshotResponse").add("FrontOfQueue", frontOfQueue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frontOfQueue":
            return Optional.ofNullable(clazz.cast(frontOfQueue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetJobQueueSnapshotResponse, T> g) {
        return obj -> g.apply((GetJobQueueSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobQueueSnapshotResponse> {
        /**
         * <p>
         * The list of the first 100 <code>RUNNABLE</code> jobs in each job queue. For first-in-first-out (FIFO) job
         * queues, jobs are ordered based on their submission time. For fair share scheduling (FSS) job queues, jobs are
         * ordered based on their job priority and share usage.
         * </p>
         * 
         * @param frontOfQueue
         *        The list of the first 100 <code>RUNNABLE</code> jobs in each job queue. For first-in-first-out (FIFO)
         *        job queues, jobs are ordered based on their submission time. For fair share scheduling (FSS) job
         *        queues, jobs are ordered based on their job priority and share usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frontOfQueue(FrontOfQueueDetail frontOfQueue);

        /**
         * <p>
         * The list of the first 100 <code>RUNNABLE</code> jobs in each job queue. For first-in-first-out (FIFO) job
         * queues, jobs are ordered based on their submission time. For fair share scheduling (FSS) job queues, jobs are
         * ordered based on their job priority and share usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link FrontOfQueueDetail.Builder} avoiding the
         * need to create one manually via {@link FrontOfQueueDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrontOfQueueDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #frontOfQueue(FrontOfQueueDetail)}.
         * 
         * @param frontOfQueue
         *        a consumer that will call methods on {@link FrontOfQueueDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frontOfQueue(FrontOfQueueDetail)
         */
        default Builder frontOfQueue(Consumer<FrontOfQueueDetail.Builder> frontOfQueue) {
            return frontOfQueue(FrontOfQueueDetail.builder().applyMutation(frontOfQueue).build());
        }
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private FrontOfQueueDetail frontOfQueue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobQueueSnapshotResponse model) {
            super(model);
            frontOfQueue(model.frontOfQueue);
        }

        public final FrontOfQueueDetail.Builder getFrontOfQueue() {
            return frontOfQueue != null ? frontOfQueue.toBuilder() : null;
        }

        public final void setFrontOfQueue(FrontOfQueueDetail.BuilderImpl frontOfQueue) {
            this.frontOfQueue = frontOfQueue != null ? frontOfQueue.build() : null;
        }

        @Override
        public final Builder frontOfQueue(FrontOfQueueDetail frontOfQueue) {
            this.frontOfQueue = frontOfQueue;
            return this;
        }

        @Override
        public GetJobQueueSnapshotResponse build() {
            return new GetJobQueueSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
