/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsResponse extends BatchResponse implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private static final SdkField<List<JobSummary>> JOB_SUMMARY_LIST_FIELD = SdkField
            .<List<JobSummary>> builder(MarshallingType.LIST)
            .memberName("jobSummaryList")
            .getter(getter(ListJobsResponse::jobSummaryList))
            .setter(setter(Builder::jobSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("jobSummaryList", JOB_SUMMARY_LIST_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<JobSummary> jobSummaryList;

    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaryList = builder.jobSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobSummaryList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobSummaryList() {
        return jobSummaryList != null && !(jobSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job summaries that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobSummaryList} method.
     * </p>
     * 
     * @return A list of job summaries that match the request.
     */
    public final List<JobSummary> jobSummaryList() {
        return jobSummaryList;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a
     * <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of
     * results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results
     *         of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the
     *         next page of results. This value is <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobSummaryList() ? jobSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        return hasJobSummaryList() == other.hasJobSummaryList() && Objects.equals(jobSummaryList(), other.jobSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsResponse").add("JobSummaryList", hasJobSummaryList() ? jobSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobSummaryList":
            return Optional.ofNullable(clazz.cast(jobSummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * 
         * @param jobSummaryList
         *        A list of job summaries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaryList(Collection<JobSummary> jobSummaryList);

        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * 
         * @param jobSummaryList
         *        A list of job summaries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaryList(JobSummary... jobSummaryList);

        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.JobSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.JobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.JobSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #jobSummaryList(List<JobSummary>)}.
         * 
         * @param jobSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.JobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSummaryList(java.util.Collection<JobSummary>)
         */
        Builder jobSummaryList(Consumer<JobSummary.Builder>... jobSummaryList);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a
         * <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
         * page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the
         *        results of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to
         *        retrieve the next page of results. This value is <code>null</code> when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobSummary> jobSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            jobSummaryList(model.jobSummaryList);
            nextToken(model.nextToken);
        }

        public final List<JobSummary.Builder> getJobSummaryList() {
            List<JobSummary.Builder> result = JobSummaryListCopier.copyToBuilder(this.jobSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobSummaryList(Collection<JobSummary.BuilderImpl> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copyFromBuilder(jobSummaryList);
        }

        @Override
        public final Builder jobSummaryList(Collection<JobSummary> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copy(jobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(JobSummary... jobSummaryList) {
            jobSummaryList(Arrays.asList(jobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(Consumer<JobSummary.Builder>... jobSummaryList) {
            jobSummaryList(Stream.of(jobSummaryList).map(c -> JobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
