/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobQueueResponse extends BatchResponse implements
        ToCopyableBuilder<CreateJobQueueResponse.Builder, CreateJobQueueResponse> {
    private static final SdkField<String> JOB_QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobQueueResponse::jobQueueName)).setter(setter(Builder::jobQueueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueName").build()).build();

    private static final SdkField<String> JOB_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobQueueResponse::jobQueueArn)).setter(setter(Builder::jobQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_NAME_FIELD,
            JOB_QUEUE_ARN_FIELD));

    private final String jobQueueName;

    private final String jobQueueArn;

    private CreateJobQueueResponse(BuilderImpl builder) {
        super(builder);
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
    }

    /**
     * <p>
     * The name of the job queue.
     * </p>
     * 
     * @return The name of the job queue.
     */
    public String jobQueueName() {
        return jobQueueName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueueArn() {
        return jobQueueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobQueueResponse)) {
            return false;
        }
        CreateJobQueueResponse other = (CreateJobQueueResponse) obj;
        return Objects.equals(jobQueueName(), other.jobQueueName()) && Objects.equals(jobQueueArn(), other.jobQueueArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateJobQueueResponse").add("JobQueueName", jobQueueName()).add("JobQueueArn", jobQueueArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueueName":
            return Optional.ofNullable(clazz.cast(jobQueueName()));
        case "jobQueueArn":
            return Optional.ofNullable(clazz.cast(jobQueueArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobQueueResponse, T> g) {
        return obj -> g.apply((CreateJobQueueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobQueueResponse> {
        /**
         * <p>
         * The name of the job queue.
         * </p>
         * 
         * @param jobQueueName
         *        The name of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueName(String jobQueueName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private String jobQueueName;

        private String jobQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobQueueResponse model) {
            super(model);
            jobQueueName(model.jobQueueName);
            jobQueueArn(model.jobQueueArn);
        }

        public final String getJobQueueName() {
            return jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        @Override
        public CreateJobQueueResponse build() {
            return new CreateJobQueueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
