/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobDefinitionsResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeJobDefinitionsResponse.Builder, DescribeJobDefinitionsResponse> {
    private static final SdkField<List<JobDefinition>> JOB_DEFINITIONS_FIELD = SdkField
            .<List<JobDefinition>> builder(MarshallingType.LIST)
            .getter(getter(DescribeJobDefinitionsResponse::jobDefinitions))
            .setter(setter(Builder::jobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeJobDefinitionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JobDefinition> jobDefinitions;

    private final String nextToken;

    private DescribeJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitions = builder.jobDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of job definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of job definitions.
     */
    public List<JobDefinition> jobDefinitions() {
        return jobDefinitions;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the
     * results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be used
     * to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When
     *         the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value
     *         can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsResponse)) {
            return false;
        }
        DescribeJobDefinitionsResponse other = (DescribeJobDefinitionsResponse) obj;
        return Objects.equals(jobDefinitions(), other.jobDefinitions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeJobDefinitionsResponse").add("JobDefinitions", jobDefinitions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitions":
            return Optional.ofNullable(clazz.cast(jobDefinitions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeJobDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
        /**
         * <p>
         * The list of job definitions.
         * </p>
         * 
         * @param jobDefinitions
         *        The list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(Collection<JobDefinition> jobDefinitions);

        /**
         * <p>
         * The list of job definitions.
         * </p>
         * 
         * @param jobDefinitions
         *        The list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(JobDefinition... jobDefinitions);

        /**
         * <p>
         * The list of job definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDefinition>.Builder} avoiding the need
         * to create one manually via {@link List<JobDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobDefinitions(List<JobDefinition>)}.
         * 
         * @param jobDefinitions
         *        a consumer that will call methods on {@link List<JobDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDefinitions(List<JobDefinition>)
         */
        Builder jobDefinitions(Consumer<JobDefinition.Builder>... jobDefinitions);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the
         * results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be
         * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request.
         *        When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this
         *        value can be used to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobDefinition> jobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsResponse model) {
            super(model);
            jobDefinitions(model.jobDefinitions);
            nextToken(model.nextToken);
        }

        public final Collection<JobDefinition.Builder> getJobDefinitions() {
            return jobDefinitions != null ? jobDefinitions.stream().map(JobDefinition::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder jobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(JobDefinition... jobDefinitions) {
            jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(Consumer<JobDefinition.Builder>... jobDefinitions) {
            jobDefinitions(Stream.of(jobDefinitions).map(c -> JobDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setJobDefinitions(Collection<JobDefinition.BuilderImpl> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copyFromBuilder(jobDefinitions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobDefinitionsResponse build() {
            return new DescribeJobDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
