/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the array properties of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArrayPropertiesDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ArrayPropertiesDetail.Builder, ArrayPropertiesDetail> {
    private static final SdkField<Map<String, Integer>> STATUS_SUMMARY_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .getter(getter(ArrayPropertiesDetail::statusSummary))
            .setter(setter(Builder::statusSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ArrayPropertiesDetail::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ArrayPropertiesDetail::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_SUMMARY_FIELD,
            SIZE_FIELD, INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Integer> statusSummary;

    private final Integer size;

    private final Integer index;

    private ArrayPropertiesDetail(BuilderImpl builder) {
        this.statusSummary = builder.statusSummary;
        this.size = builder.size;
        this.index = builder.index;
    }

    /**
     * <p>
     * A summary of the number of array job children in each available job status. This parameter is returned for parent
     * array jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A summary of the number of array job children in each available job status. This parameter is returned
     *         for parent array jobs.
     */
    public Map<String, Integer> statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The size of the array job. This parameter is returned for parent array jobs.
     * </p>
     * 
     * @return The size of the array job. This parameter is returned for parent array jobs.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The job index within the array that is associated with this job. This parameter is returned for array job
     * children.
     * </p>
     * 
     * @return The job index within the array that is associated with this job. This parameter is returned for array job
     *         children.
     */
    public Integer index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayPropertiesDetail)) {
            return false;
        }
        ArrayPropertiesDetail other = (ArrayPropertiesDetail) obj;
        return Objects.equals(statusSummary(), other.statusSummary()) && Objects.equals(size(), other.size())
                && Objects.equals(index(), other.index());
    }

    @Override
    public String toString() {
        return ToString.builder("ArrayPropertiesDetail").add("StatusSummary", statusSummary()).add("Size", size())
                .add("Index", index()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArrayPropertiesDetail, T> g) {
        return obj -> g.apply((ArrayPropertiesDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArrayPropertiesDetail> {
        /**
         * <p>
         * A summary of the number of array job children in each available job status. This parameter is returned for
         * parent array jobs.
         * </p>
         * 
         * @param statusSummary
         *        A summary of the number of array job children in each available job status. This parameter is returned
         *        for parent array jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(Map<String, Integer> statusSummary);

        /**
         * <p>
         * The size of the array job. This parameter is returned for parent array jobs.
         * </p>
         * 
         * @param size
         *        The size of the array job. This parameter is returned for parent array jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The job index within the array that is associated with this job. This parameter is returned for array job
         * children.
         * </p>
         * 
         * @param index
         *        The job index within the array that is associated with this job. This parameter is returned for array
         *        job children.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Integer> statusSummary = DefaultSdkAutoConstructMap.getInstance();

        private Integer size;

        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayPropertiesDetail model) {
            statusSummary(model.statusSummary);
            size(model.size);
            index(model.index);
        }

        public final Map<String, Integer> getStatusSummary() {
            return statusSummary;
        }

        @Override
        public final Builder statusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
            return this;
        }

        public final void setStatusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final Integer getIndex() {
            return index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public ArrayPropertiesDetail build() {
            return new ArrayPropertiesDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
