/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsResponse extends BatchResponse implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private static final SdkField<List<JobSummary>> JOB_SUMMARY_LIST_FIELD = SdkField
            .<List<JobSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListJobsResponse::jobSummaryList))
            .setter(setter(Builder::jobSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JobSummary> jobSummaryList;

    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaryList = builder.jobSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of job summaries that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job summaries that match the request.
     */
    public List<JobSummary> jobSummaryList() {
        return jobSummaryList;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a
     * <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of
     * results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results
     *         of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the
     *         next page of results. This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        return Objects.equals(jobSummaryList(), other.jobSummaryList()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListJobsResponse").add("JobSummaryList", jobSummaryList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobSummaryList":
            return Optional.ofNullable(clazz.cast(jobSummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * 
         * @param jobSummaryList
         *        A list of job summaries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaryList(Collection<JobSummary> jobSummaryList);

        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * 
         * @param jobSummaryList
         *        A list of job summaries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaryList(JobSummary... jobSummaryList);

        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobSummary>.Builder} avoiding the need to
         * create one manually via {@link List<JobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobSummaryList(List<JobSummary>)}.
         * 
         * @param jobSummaryList
         *        a consumer that will call methods on {@link List<JobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSummaryList(List<JobSummary>)
         */
        Builder jobSummaryList(Consumer<JobSummary.Builder>... jobSummaryList);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a
         * <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
         * page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the
         *        results of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to
         *        retrieve the next page of results. This value is <code>null</code> when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobSummary> jobSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            jobSummaryList(model.jobSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<JobSummary.Builder> getJobSummaryList() {
            return jobSummaryList != null ? jobSummaryList.stream().map(JobSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder jobSummaryList(Collection<JobSummary> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copy(jobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(JobSummary... jobSummaryList) {
            jobSummaryList(Arrays.asList(jobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(Consumer<JobSummary.Builder>... jobSummaryList) {
            jobSummaryList(Stream.of(jobSummaryList).map(c -> JobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setJobSummaryList(Collection<JobSummary.BuilderImpl> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copyFromBuilder(jobSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
