/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobsResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeJobsResponse.Builder, DescribeJobsResponse> {
    private static final SdkField<List<JobDetail>> JOBS_FIELD = SdkField
            .<List<JobDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD));

    private final List<JobDetail> jobs;

    private DescribeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    /**
     * <p>
     * The list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of jobs.
     */
    public List<JobDetail> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsResponse)) {
            return false;
        }
        DescribeJobsResponse other = (DescribeJobsResponse) obj;
        return Objects.equals(jobs(), other.jobs());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeJobsResponse").add("Jobs", jobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobsResponse, T> g) {
        return obj -> g.apply((DescribeJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobsResponse> {
        /**
         * <p>
         * The list of jobs.
         * </p>
         * 
         * @param jobs
         *        The list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<JobDetail> jobs);

        /**
         * <p>
         * The list of jobs.
         * </p>
         * 
         * @param jobs
         *        The list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(JobDetail... jobs);

        /**
         * <p>
         * The list of jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDetail>.Builder} avoiding the need to
         * create one manually via {@link List<JobDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobs(List<JobDetail>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<JobDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<JobDetail>)
         */
        Builder jobs(Consumer<JobDetail.Builder>... jobs);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobDetail> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsResponse model) {
            super(model);
            jobs(model.jobs);
        }

        public final Collection<JobDetail.Builder> getJobs() {
            return jobs != null ? jobs.stream().map(JobDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobDetail... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<JobDetail.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> JobDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<JobDetail.BuilderImpl> jobs) {
            this.jobs = JobDetailListCopier.copyFromBuilder(jobs);
        }

        @Override
        public DescribeJobsResponse build() {
            return new DescribeJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
