/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the Amazon EKS cluster that supports the Batch compute environment. The cluster must exist before
 * the compute environment can be created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EksConfiguration.Builder, EksConfiguration> {
    private static final SdkField<String> EKS_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eksClusterArn").getter(getter(EksConfiguration::eksClusterArn)).setter(setter(Builder::eksClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterArn").build()).build();

    private static final SdkField<String> KUBERNETES_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kubernetesNamespace").getter(getter(EksConfiguration::kubernetesNamespace))
            .setter(setter(Builder::kubernetesNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNamespace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_ARN_FIELD,
            KUBERNETES_NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eksClusterArn;

    private final String kubernetesNamespace;

    private EksConfiguration(BuilderImpl builder) {
        this.eksClusterArn = builder.eksClusterArn;
        this.kubernetesNamespace = builder.kubernetesNamespace;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is
     * <code>arn:<i>aws</i>:eks:<i>us-east-1</i>:<i>123456789012</i>:cluster/<i>ClusterForBatch</i> </code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is
     *         <code>arn:<i>aws</i>:eks:<i>us-east-1</i>:<i>123456789012</i>:cluster/<i>ClusterForBatch</i> </code>.
     */
    public final String eksClusterArn() {
        return eksClusterArn;
    }

    /**
     * <p>
     * The namespace of the Amazon EKS cluster. Batch manages pods in this namespace. The value can't left empty or
     * null. It must be fewer than 64 characters long, can't be set to <code>default</code>, can't start with "
     * <code>kube-</code>," and must match this regular expression: <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>. For
     * more information, see <a
     * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in the
     * Kubernetes documentation.
     * </p>
     * 
     * @return The namespace of the Amazon EKS cluster. Batch manages pods in this namespace. The value can't left empty
     *         or null. It must be fewer than 64 characters long, can't be set to <code>default</code>, can't start with
     *         "<code>kube-</code>," and must match this regular expression:
     *         <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in
     *         the Kubernetes documentation.
     */
    public final String kubernetesNamespace() {
        return kubernetesNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesNamespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksConfiguration)) {
            return false;
        }
        EksConfiguration other = (EksConfiguration) obj;
        return Objects.equals(eksClusterArn(), other.eksClusterArn())
                && Objects.equals(kubernetesNamespace(), other.kubernetesNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksConfiguration").add("EksClusterArn", eksClusterArn())
                .add("KubernetesNamespace", kubernetesNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksClusterArn":
            return Optional.ofNullable(clazz.cast(eksClusterArn()));
        case "kubernetesNamespace":
            return Optional.ofNullable(clazz.cast(kubernetesNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eksClusterArn", EKS_CLUSTER_ARN_FIELD);
        map.put("kubernetesNamespace", KUBERNETES_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksConfiguration, T> g) {
        return obj -> g.apply((EksConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is
         * <code>arn:<i>aws</i>:eks:<i>us-east-1</i>:<i>123456789012</i>:cluster/<i>ClusterForBatch</i> </code>.
         * </p>
         * 
         * @param eksClusterArn
         *        The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is
         *        <code>arn:<i>aws</i>:eks:<i>us-east-1</i>:<i>123456789012</i>:cluster/<i>ClusterForBatch</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusterArn(String eksClusterArn);

        /**
         * <p>
         * The namespace of the Amazon EKS cluster. Batch manages pods in this namespace. The value can't left empty or
         * null. It must be fewer than 64 characters long, can't be set to <code>default</code>, can't start with "
         * <code>kube-</code>," and must match this regular expression: <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>.
         * For more information, see <a
         * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in the
         * Kubernetes documentation.
         * </p>
         * 
         * @param kubernetesNamespace
         *        The namespace of the Amazon EKS cluster. Batch manages pods in this namespace. The value can't left
         *        empty or null. It must be fewer than 64 characters long, can't be set to <code>default</code>, can't
         *        start with "<code>kube-</code>," and must match this regular expression:
         *        <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>. For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in
         *        the Kubernetes documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesNamespace(String kubernetesNamespace);
    }

    static final class BuilderImpl implements Builder {
        private String eksClusterArn;

        private String kubernetesNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(EksConfiguration model) {
            eksClusterArn(model.eksClusterArn);
            kubernetesNamespace(model.kubernetesNamespace);
        }

        public final String getEksClusterArn() {
            return eksClusterArn;
        }

        public final void setEksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
        }

        @Override
        public final Builder eksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
            return this;
        }

        public final String getKubernetesNamespace() {
            return kubernetesNamespace;
        }

        public final void setKubernetesNamespace(String kubernetesNamespace) {
            this.kubernetesNamespace = kubernetesNamespace;
        }

        @Override
        public final Builder kubernetesNamespace(String kubernetesNamespace) {
            this.kubernetesNamespace = kubernetesNamespace;
            return this;
        }

        @Override
        public EksConfiguration build() {
            return new EksConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
