/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the node properties of a multi-node parallel job.
 * </p>
 * <note>
 * <p>
 * Node properties can't be specified for Amazon EKS based job definitions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeProperties implements SdkPojo, Serializable, ToCopyableBuilder<NodeProperties.Builder, NodeProperties> {
    private static final SdkField<Integer> NUM_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numNodes").getter(getter(NodeProperties::numNodes)).setter(setter(Builder::numNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodes").build()).build();

    private static final SdkField<Integer> MAIN_NODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("mainNode").getter(getter(NodeProperties::mainNode)).setter(setter(Builder::mainNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mainNode").build()).build();

    private static final SdkField<List<NodeRangeProperty>> NODE_RANGE_PROPERTIES_FIELD = SdkField
            .<List<NodeRangeProperty>> builder(MarshallingType.LIST)
            .memberName("nodeRangeProperties")
            .getter(getter(NodeProperties::nodeRangeProperties))
            .setter(setter(Builder::nodeRangeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRangeProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeRangeProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeRangeProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_NODES_FIELD,
            MAIN_NODE_FIELD, NODE_RANGE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numNodes;

    private final Integer mainNode;

    private final List<NodeRangeProperty> nodeRangeProperties;

    private NodeProperties(BuilderImpl builder) {
        this.numNodes = builder.numNodes;
        this.mainNode = builder.mainNode;
        this.nodeRangeProperties = builder.nodeRangeProperties;
    }

    /**
     * <p>
     * The number of nodes that are associated with a multi-node parallel job.
     * </p>
     * 
     * @return The number of nodes that are associated with a multi-node parallel job.
     */
    public final Integer numNodes() {
        return numNodes;
    }

    /**
     * <p>
     * Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than
     * the number of nodes.
     * </p>
     * 
     * @return Specifies the node index for the main node of a multi-node parallel job. This node index value must be
     *         fewer than the number of nodes.
     */
    public final Integer mainNode() {
        return mainNode;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeRangeProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeRangeProperties() {
        return nodeRangeProperties != null && !(nodeRangeProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node ranges and their properties that are associated with a multi-node parallel job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeRangeProperties} method.
     * </p>
     * 
     * @return A list of node ranges and their properties that are associated with a multi-node parallel job.
     */
    public final List<NodeRangeProperty> nodeRangeProperties() {
        return nodeRangeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numNodes());
        hashCode = 31 * hashCode + Objects.hashCode(mainNode());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeRangeProperties() ? nodeRangeProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeProperties)) {
            return false;
        }
        NodeProperties other = (NodeProperties) obj;
        return Objects.equals(numNodes(), other.numNodes()) && Objects.equals(mainNode(), other.mainNode())
                && hasNodeRangeProperties() == other.hasNodeRangeProperties()
                && Objects.equals(nodeRangeProperties(), other.nodeRangeProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeProperties").add("NumNodes", numNodes()).add("MainNode", mainNode())
                .add("NodeRangeProperties", hasNodeRangeProperties() ? nodeRangeProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numNodes":
            return Optional.ofNullable(clazz.cast(numNodes()));
        case "mainNode":
            return Optional.ofNullable(clazz.cast(mainNode()));
        case "nodeRangeProperties":
            return Optional.ofNullable(clazz.cast(nodeRangeProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("numNodes", NUM_NODES_FIELD);
        map.put("mainNode", MAIN_NODE_FIELD);
        map.put("nodeRangeProperties", NODE_RANGE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeProperties, T> g) {
        return obj -> g.apply((NodeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeProperties> {
        /**
         * <p>
         * The number of nodes that are associated with a multi-node parallel job.
         * </p>
         * 
         * @param numNodes
         *        The number of nodes that are associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numNodes(Integer numNodes);

        /**
         * <p>
         * Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer
         * than the number of nodes.
         * </p>
         * 
         * @param mainNode
         *        Specifies the node index for the main node of a multi-node parallel job. This node index value must be
         *        fewer than the number of nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mainNode(Integer mainNode);

        /**
         * <p>
         * A list of node ranges and their properties that are associated with a multi-node parallel job.
         * </p>
         * 
         * @param nodeRangeProperties
         *        A list of node ranges and their properties that are associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties);

        /**
         * <p>
         * A list of node ranges and their properties that are associated with a multi-node parallel job.
         * </p>
         * 
         * @param nodeRangeProperties
         *        A list of node ranges and their properties that are associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRangeProperties(NodeRangeProperty... nodeRangeProperties);

        /**
         * <p>
         * A list of node ranges and their properties that are associated with a multi-node parallel job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.NodeRangeProperty.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.NodeRangeProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.NodeRangeProperty.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeRangeProperties(List<NodeRangeProperty>)}.
         * 
         * @param nodeRangeProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.NodeRangeProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeRangeProperties(java.util.Collection<NodeRangeProperty>)
         */
        Builder nodeRangeProperties(Consumer<NodeRangeProperty.Builder>... nodeRangeProperties);
    }

    static final class BuilderImpl implements Builder {
        private Integer numNodes;

        private Integer mainNode;

        private List<NodeRangeProperty> nodeRangeProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeProperties model) {
            numNodes(model.numNodes);
            mainNode(model.mainNode);
            nodeRangeProperties(model.nodeRangeProperties);
        }

        public final Integer getNumNodes() {
            return numNodes;
        }

        public final void setNumNodes(Integer numNodes) {
            this.numNodes = numNodes;
        }

        @Override
        public final Builder numNodes(Integer numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        public final Integer getMainNode() {
            return mainNode;
        }

        public final void setMainNode(Integer mainNode) {
            this.mainNode = mainNode;
        }

        @Override
        public final Builder mainNode(Integer mainNode) {
            this.mainNode = mainNode;
            return this;
        }

        public final List<NodeRangeProperty.Builder> getNodeRangeProperties() {
            List<NodeRangeProperty.Builder> result = NodeRangePropertiesCopier.copyToBuilder(this.nodeRangeProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeRangeProperties(Collection<NodeRangeProperty.BuilderImpl> nodeRangeProperties) {
            this.nodeRangeProperties = NodeRangePropertiesCopier.copyFromBuilder(nodeRangeProperties);
        }

        @Override
        public final Builder nodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties) {
            this.nodeRangeProperties = NodeRangePropertiesCopier.copy(nodeRangeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRangeProperties(NodeRangeProperty... nodeRangeProperties) {
            nodeRangeProperties(Arrays.asList(nodeRangeProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRangeProperties(Consumer<NodeRangeProperty.Builder>... nodeRangeProperties) {
            nodeRangeProperties(Stream.of(nodeRangeProperties).map(c -> NodeRangeProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public NodeProperties build() {
            return new NodeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
