/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the infrastructure update policy for the compute environment. For more information about infrastructure
 * updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
 * compute environments</a> in the <i>Batch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePolicy implements SdkPojo, Serializable, ToCopyableBuilder<UpdatePolicy.Builder, UpdatePolicy> {
    private static final SdkField<Boolean> TERMINATE_JOBS_ON_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("terminateJobsOnUpdate").getter(getter(UpdatePolicy::terminateJobsOnUpdate))
            .setter(setter(Builder::terminateJobsOnUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateJobsOnUpdate").build())
            .build();

    private static final SdkField<Long> JOB_EXECUTION_TIMEOUT_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("jobExecutionTimeoutMinutes")
            .getter(getter(UpdatePolicy::jobExecutionTimeoutMinutes))
            .setter(setter(Builder::jobExecutionTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionTimeoutMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TERMINATE_JOBS_ON_UPDATE_FIELD, JOB_EXECUTION_TIMEOUT_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean terminateJobsOnUpdate;

    private final Long jobExecutionTimeoutMinutes;

    private UpdatePolicy(BuilderImpl builder) {
        this.terminateJobsOnUpdate = builder.terminateJobsOnUpdate;
        this.jobExecutionTimeoutMinutes = builder.jobExecutionTimeoutMinutes;
    }

    /**
     * <p>
     * Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated. The
     * default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether jobs are automatically terminated when the computer environment infrastructure is
     *         updated. The default value is <code>false</code>.
     */
    public final Boolean terminateJobsOnUpdate() {
        return terminateJobsOnUpdate;
    }

    /**
     * <p>
     * Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default value
     * is 30.
     * </p>
     * 
     * @return Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The
     *         default value is 30.
     */
    public final Long jobExecutionTimeoutMinutes() {
        return jobExecutionTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminateJobsOnUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionTimeoutMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicy)) {
            return false;
        }
        UpdatePolicy other = (UpdatePolicy) obj;
        return Objects.equals(terminateJobsOnUpdate(), other.terminateJobsOnUpdate())
                && Objects.equals(jobExecutionTimeoutMinutes(), other.jobExecutionTimeoutMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePolicy").add("TerminateJobsOnUpdate", terminateJobsOnUpdate())
                .add("JobExecutionTimeoutMinutes", jobExecutionTimeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "terminateJobsOnUpdate":
            return Optional.ofNullable(clazz.cast(terminateJobsOnUpdate()));
        case "jobExecutionTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(jobExecutionTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("terminateJobsOnUpdate", TERMINATE_JOBS_ON_UPDATE_FIELD);
        map.put("jobExecutionTimeoutMinutes", JOB_EXECUTION_TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePolicy, T> g) {
        return obj -> g.apply((UpdatePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePolicy> {
        /**
         * <p>
         * Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param terminateJobsOnUpdate
         *        Specifies whether jobs are automatically terminated when the computer environment infrastructure is
         *        updated. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateJobsOnUpdate(Boolean terminateJobsOnUpdate);

        /**
         * <p>
         * Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The default
         * value is 30.
         * </p>
         * 
         * @param jobExecutionTimeoutMinutes
         *        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated. The
         *        default value is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionTimeoutMinutes(Long jobExecutionTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean terminateJobsOnUpdate;

        private Long jobExecutionTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicy model) {
            terminateJobsOnUpdate(model.terminateJobsOnUpdate);
            jobExecutionTimeoutMinutes(model.jobExecutionTimeoutMinutes);
        }

        public final Boolean getTerminateJobsOnUpdate() {
            return terminateJobsOnUpdate;
        }

        public final void setTerminateJobsOnUpdate(Boolean terminateJobsOnUpdate) {
            this.terminateJobsOnUpdate = terminateJobsOnUpdate;
        }

        @Override
        public final Builder terminateJobsOnUpdate(Boolean terminateJobsOnUpdate) {
            this.terminateJobsOnUpdate = terminateJobsOnUpdate;
            return this;
        }

        public final Long getJobExecutionTimeoutMinutes() {
            return jobExecutionTimeoutMinutes;
        }

        public final void setJobExecutionTimeoutMinutes(Long jobExecutionTimeoutMinutes) {
            this.jobExecutionTimeoutMinutes = jobExecutionTimeoutMinutes;
        }

        @Override
        public final Builder jobExecutionTimeoutMinutes(Long jobExecutionTimeoutMinutes) {
            this.jobExecutionTimeoutMinutes = jobExecutionTimeoutMinutes;
            return this;
        }

        @Override
        public UpdatePolicy build() {
            return new UpdatePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
