/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.FrontOfQueueJobSummary;
import software.amazon.awssdk.services.batch.model.FrontOfQueueJobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrontOfQueueDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrontOfQueueDetail> {
    private static final SdkField<List<FrontOfQueueJobSummary>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobs").getter(FrontOfQueueDetail.getter(FrontOfQueueDetail::jobs)).setter(FrontOfQueueDetail.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FrontOfQueueJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedAt").getter(FrontOfQueueDetail.getter(FrontOfQueueDetail::lastUpdatedAt)).setter(FrontOfQueueDetail.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FrontOfQueueDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FrontOfQueueJobSummary> jobs;
    private final Long lastUpdatedAt;

    private FrontOfQueueDetail(BuilderImpl builder) {
        this.jobs = builder.jobs;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public final List<FrontOfQueueJobSummary> jobs() {
        return this.jobs;
    }

    public final Long lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrontOfQueueDetail)) {
            return false;
        }
        FrontOfQueueDetail other = (FrontOfQueueDetail)obj;
        return this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"FrontOfQueueDetail").add("Jobs", this.hasJobs() ? this.jobs() : null).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobs", JOBS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrontOfQueueDetail, T> g) {
        return obj -> g.apply((FrontOfQueueDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FrontOfQueueJobSummary> jobs = DefaultSdkAutoConstructList.getInstance();
        private Long lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FrontOfQueueDetail model) {
            this.jobs(model.jobs);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final List<FrontOfQueueJobSummary.Builder> getJobs() {
            List<FrontOfQueueJobSummary.Builder> result = FrontOfQueueJobSummaryListCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<FrontOfQueueJobSummary.BuilderImpl> jobs) {
            this.jobs = FrontOfQueueJobSummaryListCopier.copyFromBuilder(jobs);
        }

        @Override
        public final Builder jobs(Collection<FrontOfQueueJobSummary> jobs) {
            this.jobs = FrontOfQueueJobSummaryListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(FrontOfQueueJobSummary ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<FrontOfQueueJobSummary.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (FrontOfQueueJobSummary)((FrontOfQueueJobSummary.Builder)FrontOfQueueJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public FrontOfQueueDetail build() {
            return new FrontOfQueueDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrontOfQueueDetail> {
        public Builder jobs(Collection<FrontOfQueueJobSummary> var1);

        public Builder jobs(FrontOfQueueJobSummary ... var1);

        public Builder jobs(Consumer<FrontOfQueueJobSummary.Builder> ... var1);

        public Builder lastUpdatedAt(Long var1);
    }
}

