/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceJobResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeServiceJobResponse.Builder, DescribeServiceJobResponse> {
    private static final SdkField<List<ServiceJobAttemptDetail>> ATTEMPTS_FIELD = SdkField
            .<List<ServiceJobAttemptDetail>> builder(MarshallingType.LIST)
            .memberName("attempts")
            .getter(getter(DescribeServiceJobResponse::attempts))
            .setter(setter(Builder::attempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceJobAttemptDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceJobAttemptDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("createdAt")
            .getter(getter(DescribeServiceJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Boolean> IS_TERMINATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isTerminated").getter(getter(DescribeServiceJobResponse::isTerminated))
            .setter(setter(Builder::isTerminated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTerminated").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(DescribeServiceJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DescribeServiceJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DescribeServiceJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueue").getter(getter(DescribeServiceJobResponse::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<LatestServiceJobAttempt> LATEST_ATTEMPT_FIELD = SdkField
            .<LatestServiceJobAttempt> builder(MarshallingType.SDK_POJO).memberName("latestAttempt")
            .getter(getter(DescribeServiceJobResponse::latestAttempt)).setter(setter(Builder::latestAttempt))
            .constructor(LatestServiceJobAttempt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAttempt").build()).build();

    private static final SdkField<ServiceJobRetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<ServiceJobRetryStrategy> builder(MarshallingType.SDK_POJO).memberName("retryStrategy")
            .getter(getter(DescribeServiceJobResponse::retryStrategy)).setter(setter(Builder::retryStrategy))
            .constructor(ServiceJobRetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()).build();

    private static final SdkField<Integer> SCHEDULING_PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("schedulingPriority").getter(getter(DescribeServiceJobResponse::schedulingPriority))
            .setter(setter(Builder::schedulingPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriority").build())
            .build();

    private static final SdkField<String> SERVICE_REQUEST_PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRequestPayload").getter(getter(DescribeServiceJobResponse::serviceRequestPayload))
            .setter(setter(Builder::serviceRequestPayload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRequestPayload").build())
            .build();

    private static final SdkField<String> SERVICE_JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceJobType").getter(getter(DescribeServiceJobResponse::serviceJobTypeAsString))
            .setter(setter(Builder::serviceJobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceJobType").build()).build();

    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareIdentifier").getter(getter(DescribeServiceJobResponse::shareIdentifier))
            .setter(setter(Builder::shareIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(DescribeServiceJobResponse::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeServiceJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(DescribeServiceJobResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("stoppedAt")
            .getter(getter(DescribeServiceJobResponse::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeServiceJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ServiceJobTimeout> TIMEOUT_CONFIG_FIELD = SdkField
            .<ServiceJobTimeout> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(DescribeServiceJobResponse::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(ServiceJobTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD,
            CREATED_AT_FIELD, IS_TERMINATED_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_QUEUE_FIELD,
            LATEST_ATTEMPT_FIELD, RETRY_STRATEGY_FIELD, SCHEDULING_PRIORITY_FIELD, SERVICE_REQUEST_PAYLOAD_FIELD,
            SERVICE_JOB_TYPE_FIELD, SHARE_IDENTIFIER_FIELD, STARTED_AT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            STOPPED_AT_FIELD, TAGS_FIELD, TIMEOUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ServiceJobAttemptDetail> attempts;

    private final Long createdAt;

    private final Boolean isTerminated;

    private final String jobArn;

    private final String jobId;

    private final String jobName;

    private final String jobQueue;

    private final LatestServiceJobAttempt latestAttempt;

    private final ServiceJobRetryStrategy retryStrategy;

    private final Integer schedulingPriority;

    private final String serviceRequestPayload;

    private final String serviceJobType;

    private final String shareIdentifier;

    private final Long startedAt;

    private final String status;

    private final String statusReason;

    private final Long stoppedAt;

    private final Map<String, String> tags;

    private final ServiceJobTimeout timeoutConfig;

    private DescribeServiceJobResponse(BuilderImpl builder) {
        super(builder);
        this.attempts = builder.attempts;
        this.createdAt = builder.createdAt;
        this.isTerminated = builder.isTerminated;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.latestAttempt = builder.latestAttempt;
        this.retryStrategy = builder.retryStrategy;
        this.schedulingPriority = builder.schedulingPriority;
        this.serviceRequestPayload = builder.serviceRequestPayload;
        this.serviceJobType = builder.serviceJobType;
        this.shareIdentifier = builder.shareIdentifier;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.stoppedAt = builder.stoppedAt;
        this.tags = builder.tags;
        this.timeoutConfig = builder.timeoutConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attempts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttempts() {
        return attempts != null && !(attempts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job attempts associated with the service job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttempts} method.
     * </p>
     * 
     * @return A list of job attempts associated with the service job.
     */
    public final List<ServiceJobAttemptDetail> attempts() {
        return attempts;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job was created.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job was created.
     */
    public final Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates whether the service job has been terminated.
     * </p>
     * 
     * @return Indicates whether the service job has been terminated.
     */
    public final Boolean isTerminated() {
        return isTerminated;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The job ID for the service job.
     * </p>
     * 
     * @return The job ID for the service job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the service job.
     * </p>
     * 
     * @return The name of the service job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The ARN of the job queue that the service job is associated with.
     * </p>
     * 
     * @return The ARN of the job queue that the service job is associated with.
     */
    public final String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The latest attempt associated with the service job.
     * </p>
     * 
     * @return The latest attempt associated with the service job.
     */
    public final LatestServiceJobAttempt latestAttempt() {
        return latestAttempt;
    }

    /**
     * <p>
     * The retry strategy to use for failed service jobs that are submitted with this service job.
     * </p>
     * 
     * @return The retry strategy to use for failed service jobs that are submitted with this service job.
     */
    public final ServiceJobRetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The scheduling priority of the service job.
     * </p>
     * 
     * @return The scheduling priority of the service job.
     */
    public final Integer schedulingPriority() {
        return schedulingPriority;
    }

    /**
     * <p>
     * The request, in JSON, for the service that the <code>SubmitServiceJob</code> operation is queueing.
     * </p>
     * 
     * @return The request, in JSON, for the service that the <code>SubmitServiceJob</code> operation is queueing.
     */
    public final String serviceRequestPayload() {
        return serviceRequestPayload;
    }

    /**
     * <p>
     * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceJobType}
     * will return {@link ServiceJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceJobTypeAsString}.
     * </p>
     * 
     * @return The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceJobType
     */
    public final ServiceJobType serviceJobType() {
        return ServiceJobType.fromValue(serviceJobType);
    }

    /**
     * <p>
     * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceJobType}
     * will return {@link ServiceJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceJobTypeAsString}.
     * </p>
     * 
     * @return The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceJobType
     */
    public final String serviceJobTypeAsString() {
        return serviceJobType;
    }

    /**
     * <p>
     * The share identifier for the service job. This is used for fair-share scheduling.
     * </p>
     * 
     * @return The share identifier for the service job. This is used for fair-share scheduling.
     */
    public final String shareIdentifier() {
        return shareIdentifier;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job was started.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job was started.
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The current status of the service job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the service job.
     * @see ServiceJobStatus
     */
    public final ServiceJobStatus status() {
        return ServiceJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the service job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the service job.
     * @see ServiceJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide more details for the current status of the service job.
     * </p>
     * 
     * @return A short, human-readable string to provide more details for the current status of the service job.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job stopped running.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job stopped running.
     */
    public final Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are associated with the service job. Each tag consists of a key and an optional value. For more
     * information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     * resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are associated with the service job. Each tag consists of a key and an optional value. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timeout configuration for the service job.
     * </p>
     * 
     * @return The timeout configuration for the service job.
     */
    public final ServiceJobTimeout timeoutConfig() {
        return timeoutConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttempts() ? attempts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(isTerminated());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(latestAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRequestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(serviceJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceJobResponse)) {
            return false;
        }
        DescribeServiceJobResponse other = (DescribeServiceJobResponse) obj;
        return hasAttempts() == other.hasAttempts() && Objects.equals(attempts(), other.attempts())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(isTerminated(), other.isTerminated())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobQueue(), other.jobQueue())
                && Objects.equals(latestAttempt(), other.latestAttempt())
                && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(schedulingPriority(), other.schedulingPriority())
                && Objects.equals(serviceRequestPayload(), other.serviceRequestPayload())
                && Objects.equals(serviceJobTypeAsString(), other.serviceJobTypeAsString())
                && Objects.equals(shareIdentifier(), other.shareIdentifier()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(stoppedAt(), other.stoppedAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(timeoutConfig(), other.timeoutConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServiceJobResponse").add("Attempts", hasAttempts() ? attempts() : null)
                .add("CreatedAt", createdAt()).add("IsTerminated", isTerminated()).add("JobArn", jobArn()).add("JobId", jobId())
                .add("JobName", jobName()).add("JobQueue", jobQueue()).add("LatestAttempt", latestAttempt())
                .add("RetryStrategy", retryStrategy()).add("SchedulingPriority", schedulingPriority())
                .add("ServiceRequestPayload", serviceRequestPayload()).add("ServiceJobType", serviceJobTypeAsString())
                .add("ShareIdentifier", shareIdentifier()).add("StartedAt", startedAt()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("StoppedAt", stoppedAt()).add("Tags", hasTags() ? tags() : null)
                .add("TimeoutConfig", timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "isTerminated":
            return Optional.ofNullable(clazz.cast(isTerminated()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "latestAttempt":
            return Optional.ofNullable(clazz.cast(latestAttempt()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "schedulingPriority":
            return Optional.ofNullable(clazz.cast(schedulingPriority()));
        case "serviceRequestPayload":
            return Optional.ofNullable(clazz.cast(serviceRequestPayload()));
        case "serviceJobType":
            return Optional.ofNullable(clazz.cast(serviceJobTypeAsString()));
        case "shareIdentifier":
            return Optional.ofNullable(clazz.cast(shareIdentifier()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attempts", ATTEMPTS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("isTerminated", IS_TERMINATED_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobQueue", JOB_QUEUE_FIELD);
        map.put("latestAttempt", LATEST_ATTEMPT_FIELD);
        map.put("retryStrategy", RETRY_STRATEGY_FIELD);
        map.put("schedulingPriority", SCHEDULING_PRIORITY_FIELD);
        map.put("serviceRequestPayload", SERVICE_REQUEST_PAYLOAD_FIELD);
        map.put("serviceJobType", SERVICE_JOB_TYPE_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceJobResponse, T> g) {
        return obj -> g.apply((DescribeServiceJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServiceJobResponse> {
        /**
         * <p>
         * A list of job attempts associated with the service job.
         * </p>
         * 
         * @param attempts
         *        A list of job attempts associated with the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Collection<ServiceJobAttemptDetail> attempts);

        /**
         * <p>
         * A list of job attempts associated with the service job.
         * </p>
         * 
         * @param attempts
         *        A list of job attempts associated with the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(ServiceJobAttemptDetail... attempts);

        /**
         * <p>
         * A list of job attempts associated with the service job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.ServiceJobAttemptDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.batch.model.ServiceJobAttemptDetail#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.ServiceJobAttemptDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #attempts(List<ServiceJobAttemptDetail>)}.
         * 
         * @param attempts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.ServiceJobAttemptDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attempts(java.util.Collection<ServiceJobAttemptDetail>)
         */
        Builder attempts(Consumer<ServiceJobAttemptDetail.Builder>... attempts);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp (in milliseconds) for when the service job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * Indicates whether the service job has been terminated.
         * </p>
         * 
         * @param isTerminated
         *        Indicates whether the service job has been terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTerminated(Boolean isTerminated);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The job ID for the service job.
         * </p>
         * 
         * @param jobId
         *        The job ID for the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the service job.
         * </p>
         * 
         * @param jobName
         *        The name of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The ARN of the job queue that the service job is associated with.
         * </p>
         * 
         * @param jobQueue
         *        The ARN of the job queue that the service job is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The latest attempt associated with the service job.
         * </p>
         * 
         * @param latestAttempt
         *        The latest attempt associated with the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAttempt(LatestServiceJobAttempt latestAttempt);

        /**
         * <p>
         * The latest attempt associated with the service job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LatestServiceJobAttempt.Builder} avoiding
         * the need to create one manually via {@link LatestServiceJobAttempt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LatestServiceJobAttempt.Builder#build()} is called immediately
         * and its result is passed to {@link #latestAttempt(LatestServiceJobAttempt)}.
         * 
         * @param latestAttempt
         *        a consumer that will call methods on {@link LatestServiceJobAttempt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestAttempt(LatestServiceJobAttempt)
         */
        default Builder latestAttempt(Consumer<LatestServiceJobAttempt.Builder> latestAttempt) {
            return latestAttempt(LatestServiceJobAttempt.builder().applyMutation(latestAttempt).build());
        }

        /**
         * <p>
         * The retry strategy to use for failed service jobs that are submitted with this service job.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed service jobs that are submitted with this service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(ServiceJobRetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed service jobs that are submitted with this service job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceJobRetryStrategy.Builder} avoiding
         * the need to create one manually via {@link ServiceJobRetryStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceJobRetryStrategy.Builder#build()} is called immediately
         * and its result is passed to {@link #retryStrategy(ServiceJobRetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link ServiceJobRetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(ServiceJobRetryStrategy)
         */
        default Builder retryStrategy(Consumer<ServiceJobRetryStrategy.Builder> retryStrategy) {
            return retryStrategy(ServiceJobRetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The scheduling priority of the service job.
         * </p>
         * 
         * @param schedulingPriority
         *        The scheduling priority of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulingPriority(Integer schedulingPriority);

        /**
         * <p>
         * The request, in JSON, for the service that the <code>SubmitServiceJob</code> operation is queueing.
         * </p>
         * 
         * @param serviceRequestPayload
         *        The request, in JSON, for the service that the <code>SubmitServiceJob</code> operation is queueing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRequestPayload(String serviceRequestPayload);

        /**
         * <p>
         * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceJobType
         *        The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobType
         */
        Builder serviceJobType(String serviceJobType);

        /**
         * <p>
         * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceJobType
         *        The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobType
         */
        Builder serviceJobType(ServiceJobType serviceJobType);

        /**
         * <p>
         * The share identifier for the service job. This is used for fair-share scheduling.
         * </p>
         * 
         * @param shareIdentifier
         *        The share identifier for the service job. This is used for fair-share scheduling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareIdentifier(String shareIdentifier);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job was started.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in milliseconds) for when the service job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The current status of the service job.
         * </p>
         * 
         * @param status
         *        The current status of the service job.
         * @see ServiceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the service job.
         * </p>
         * 
         * @param status
         *        The current status of the service job.
         * @see ServiceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobStatus
         */
        Builder status(ServiceJobStatus status);

        /**
         * <p>
         * A short, human-readable string to provide more details for the current status of the service job.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide more details for the current status of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job stopped running.
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in milliseconds) for when the service job stopped running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * The tags that are associated with the service job. Each tag consists of a key and an optional value. For more
         * information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your
         * Batch resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags that are associated with the service job. Each tag consists of a key and an optional value.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timeout configuration for the service job.
         * </p>
         * 
         * @param timeoutConfig
         *        The timeout configuration for the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(ServiceJobTimeout timeoutConfig);

        /**
         * <p>
         * The timeout configuration for the service job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceJobTimeout.Builder} avoiding the
         * need to create one manually via {@link ServiceJobTimeout#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceJobTimeout.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(ServiceJobTimeout)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link ServiceJobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(ServiceJobTimeout)
         */
        default Builder timeoutConfig(Consumer<ServiceJobTimeout.Builder> timeoutConfig) {
            return timeoutConfig(ServiceJobTimeout.builder().applyMutation(timeoutConfig).build());
        }
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<ServiceJobAttemptDetail> attempts = DefaultSdkAutoConstructList.getInstance();

        private Long createdAt;

        private Boolean isTerminated;

        private String jobArn;

        private String jobId;

        private String jobName;

        private String jobQueue;

        private LatestServiceJobAttempt latestAttempt;

        private ServiceJobRetryStrategy retryStrategy;

        private Integer schedulingPriority;

        private String serviceRequestPayload;

        private String serviceJobType;

        private String shareIdentifier;

        private Long startedAt;

        private String status;

        private String statusReason;

        private Long stoppedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ServiceJobTimeout timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceJobResponse model) {
            super(model);
            attempts(model.attempts);
            createdAt(model.createdAt);
            isTerminated(model.isTerminated);
            jobArn(model.jobArn);
            jobId(model.jobId);
            jobName(model.jobName);
            jobQueue(model.jobQueue);
            latestAttempt(model.latestAttempt);
            retryStrategy(model.retryStrategy);
            schedulingPriority(model.schedulingPriority);
            serviceRequestPayload(model.serviceRequestPayload);
            serviceJobType(model.serviceJobType);
            shareIdentifier(model.shareIdentifier);
            startedAt(model.startedAt);
            status(model.status);
            statusReason(model.statusReason);
            stoppedAt(model.stoppedAt);
            tags(model.tags);
            timeoutConfig(model.timeoutConfig);
        }

        public final List<ServiceJobAttemptDetail.Builder> getAttempts() {
            List<ServiceJobAttemptDetail.Builder> result = ServiceJobAttemptDetailsCopier.copyToBuilder(this.attempts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttempts(Collection<ServiceJobAttemptDetail.BuilderImpl> attempts) {
            this.attempts = ServiceJobAttemptDetailsCopier.copyFromBuilder(attempts);
        }

        @Override
        public final Builder attempts(Collection<ServiceJobAttemptDetail> attempts) {
            this.attempts = ServiceJobAttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(ServiceJobAttemptDetail... attempts) {
            attempts(Arrays.asList(attempts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(Consumer<ServiceJobAttemptDetail.Builder>... attempts) {
            attempts(Stream.of(attempts).map(c -> ServiceJobAttemptDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getIsTerminated() {
            return isTerminated;
        }

        public final void setIsTerminated(Boolean isTerminated) {
            this.isTerminated = isTerminated;
        }

        @Override
        public final Builder isTerminated(Boolean isTerminated) {
            this.isTerminated = isTerminated;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final LatestServiceJobAttempt.Builder getLatestAttempt() {
            return latestAttempt != null ? latestAttempt.toBuilder() : null;
        }

        public final void setLatestAttempt(LatestServiceJobAttempt.BuilderImpl latestAttempt) {
            this.latestAttempt = latestAttempt != null ? latestAttempt.build() : null;
        }

        @Override
        public final Builder latestAttempt(LatestServiceJobAttempt latestAttempt) {
            this.latestAttempt = latestAttempt;
            return this;
        }

        public final ServiceJobRetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(ServiceJobRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(ServiceJobRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Integer getSchedulingPriority() {
            return schedulingPriority;
        }

        public final void setSchedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
        }

        @Override
        public final Builder schedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        public final String getServiceRequestPayload() {
            return serviceRequestPayload;
        }

        public final void setServiceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
        }

        @Override
        public final Builder serviceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
            return this;
        }

        public final String getServiceJobType() {
            return serviceJobType;
        }

        public final void setServiceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
        }

        @Override
        public final Builder serviceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
            return this;
        }

        @Override
        public final Builder serviceJobType(ServiceJobType serviceJobType) {
            this.serviceJobType(serviceJobType == null ? null : serviceJobType.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final ServiceJobTimeout.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(ServiceJobTimeout.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(ServiceJobTimeout timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        @Override
        public DescribeServiceJobResponse build() {
            return new DescribeServiceJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
