/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a job timeout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTimeout implements SdkPojo, Serializable, ToCopyableBuilder<JobTimeout.Builder, JobTimeout> {
    private static final SdkField<Integer> ATTEMPT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JobTimeout::attemptDurationSeconds)).setter(setter(Builder::attemptDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attemptDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTEMPT_DURATION_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer attemptDurationSeconds;

    private JobTimeout(BuilderImpl builder) {
        this.attemptDurationSeconds = builder.attemptDurationSeconds;
    }

    /**
     * <p>
     * The time duration in seconds (measured from the job attempt's <code>startedAt</code> timestamp) after which AWS
     * Batch terminates your jobs if they have not finished.
     * </p>
     * 
     * @return The time duration in seconds (measured from the job attempt's <code>startedAt</code> timestamp) after
     *         which AWS Batch terminates your jobs if they have not finished.
     */
    public Integer attemptDurationSeconds() {
        return attemptDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attemptDurationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTimeout)) {
            return false;
        }
        JobTimeout other = (JobTimeout) obj;
        return Objects.equals(attemptDurationSeconds(), other.attemptDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobTimeout").add("AttemptDurationSeconds", attemptDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attemptDurationSeconds":
            return Optional.ofNullable(clazz.cast(attemptDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTimeout, T> g) {
        return obj -> g.apply((JobTimeout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTimeout> {
        /**
         * <p>
         * The time duration in seconds (measured from the job attempt's <code>startedAt</code> timestamp) after which
         * AWS Batch terminates your jobs if they have not finished.
         * </p>
         * 
         * @param attemptDurationSeconds
         *        The time duration in seconds (measured from the job attempt's <code>startedAt</code> timestamp) after
         *        which AWS Batch terminates your jobs if they have not finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attemptDurationSeconds(Integer attemptDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer attemptDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTimeout model) {
            attemptDurationSeconds(model.attemptDurationSeconds);
        }

        public final Integer getAttemptDurationSeconds() {
            return attemptDurationSeconds;
        }

        @Override
        public final Builder attemptDurationSeconds(Integer attemptDurationSeconds) {
            this.attemptDurationSeconds = attemptDurationSeconds;
            return this;
        }

        public final void setAttemptDurationSeconds(Integer attemptDurationSeconds) {
            this.attemptDurationSeconds = attemptDurationSeconds;
        }

        @Override
        public JobTimeout build() {
            return new JobTimeout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
