/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a Docker volume mount point that is used in a job's container properties. This parameter maps to
 * <code>Volumes</code> in the <a
 * href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.19/#create-a-container">Create a
 * container</a> section of the Docker Remote API and the <code>--volume</code> option to docker run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MountPoint implements SdkPojo, Serializable, ToCopyableBuilder<MountPoint.Builder, MountPoint> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountPoint::containerPath)).setter(setter(Builder::containerPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPath").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MountPoint::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()).build();

    private static final SdkField<String> SOURCE_VOLUME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountPoint::sourceVolume)).setter(setter(Builder::sourceVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVolume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD,
            READ_ONLY_FIELD, SOURCE_VOLUME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerPath;

    private final Boolean readOnly;

    private final String sourceVolume;

    private MountPoint(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
        this.sourceVolume = builder.sourceVolume;
    }

    /**
     * <p>
     * The path on the container at which to mount the host volume.
     * </p>
     * 
     * @return The path on the container at which to mount the host volume.
     */
    public String containerPath() {
        return containerPath;
    }

    /**
     * <p>
     * If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the container
     * can write to the volume. The default value is <code>false</code>.
     * </p>
     * 
     * @return If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the
     *         container can write to the volume. The default value is <code>false</code>.
     */
    public Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * The name of the volume to mount.
     * </p>
     * 
     * @return The name of the volume to mount.
     */
    public String sourceVolume() {
        return sourceVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVolume());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint) obj;
        return Objects.equals(containerPath(), other.containerPath()) && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(sourceVolume(), other.sourceVolume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MountPoint").add("ContainerPath", containerPath()).add("ReadOnly", readOnly())
                .add("SourceVolume", sourceVolume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerPath":
            return Optional.ofNullable(clazz.cast(containerPath()));
        case "readOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "sourceVolume":
            return Optional.ofNullable(clazz.cast(sourceVolume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MountPoint, T> g) {
        return obj -> g.apply((MountPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MountPoint> {
        /**
         * <p>
         * The path on the container at which to mount the host volume.
         * </p>
         * 
         * @param containerPath
         *        The path on the container at which to mount the host volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);

        /**
         * <p>
         * If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the
         * container can write to the volume. The default value is <code>false</code>.
         * </p>
         * 
         * @param readOnly
         *        If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the
         *        container can write to the volume. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * The name of the volume to mount.
         * </p>
         * 
         * @param sourceVolume
         *        The name of the volume to mount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolume(String sourceVolume);
    }

    static final class BuilderImpl implements Builder {
        private String containerPath;

        private Boolean readOnly;

        private String sourceVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            containerPath(model.containerPath);
            readOnly(model.readOnly);
            sourceVolume(model.sourceVolume);
        }

        public final String getContainerPath() {
            return containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final String getSourceVolume() {
            return sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        @Override
        public MountPoint build() {
            return new MountPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
