/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobDefinitionsRequest extends BatchRequest implements
        ToCopyableBuilder<DescribeJobDefinitionsRequest.Builder, DescribeJobDefinitionsRequest> {
    private static final SdkField<List<String>> JOB_DEFINITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeJobDefinitionsRequest::jobDefinitions))
            .setter(setter(Builder::jobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeJobDefinitionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeJobDefinitionsRequest::jobDefinitionName)).setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeJobDefinitionsRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeJobDefinitionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITIONS_FIELD,
            MAX_RESULTS_FIELD, JOB_DEFINITION_NAME_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> jobDefinitions;

    private final Integer maxResults;

    private final String jobDefinitionName;

    private final String status;

    private final String nextToken;

    private DescribeJobDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitions = builder.jobDefinitions;
        this.maxResults = builder.maxResults;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
     */
    public List<String> jobDefinitions() {
        return jobDefinitions;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this
     * parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a single
     * page along with a <code>nextToken</code> response element. The remaining results of the initial request can be
     * seen by sending another <code>DescribeJobDefinitions</code> request with the returned <code>nextToken</code>
     * value. This value can be between 1 and 100. If this parameter is not used, then
     * <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When
     *         this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results
     *         in a single page along with a <code>nextToken</code> response element. The remaining results of the
     *         initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with the
     *         returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not
     *         used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code>
     *         value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the job definition to describe.
     * </p>
     * 
     * @return The name of the job definition to describe.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The status with which to filter job definitions.
     * </p>
     * 
     * @return The status with which to filter job definitions.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsRequest)) {
            return false;
        }
        DescribeJobDefinitionsRequest other = (DescribeJobDefinitionsRequest) obj;
        return Objects.equals(jobDefinitions(), other.jobDefinitions()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(status(), other.status())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeJobDefinitionsRequest").add("JobDefinitions", jobDefinitions())
                .add("MaxResults", maxResults()).add("JobDefinitionName", jobDefinitionName()).add("Status", status())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitions":
            return Optional.ofNullable(clazz.cast(jobDefinitions()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "jobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobDefinitionsRequest, T> g) {
        return obj -> g.apply((DescribeJobDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobDefinitionsRequest> {
        /**
         * <p>
         * A list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobDefinitions
         *        A list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(Collection<String> jobDefinitions);

        /**
         * <p>
         * A list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobDefinitions
         *        A list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(String... jobDefinitions);

        /**
         * <p>
         * The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this
         * parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a
         * single page along with a <code>nextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>DescribeJobDefinitions</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
         * <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if
         * applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output.
         *        When this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code>
         *        results in a single page along with a <code>nextToken</code> response element. The remaining results
         *        of the initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with
         *        the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is
         *        not used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a
         *        <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the job definition to describe.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The status with which to filter job definitions.
         * </p>
         * 
         * @param status
         *        The status with which to filter job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * This value is <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeJobDefinitions</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more
         *        results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private List<String> jobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String jobDefinitionName;

        private String status;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsRequest model) {
            super(model);
            jobDefinitions(model.jobDefinitions);
            maxResults(model.maxResults);
            jobDefinitionName(model.jobDefinitionName);
            status(model.status);
            nextToken(model.nextToken);
        }

        public final Collection<String> getJobDefinitions() {
            return jobDefinitions;
        }

        @Override
        public final Builder jobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(String... jobDefinitions) {
            jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        public final void setJobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobDefinitionsRequest build() {
            return new DescribeJobDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
