/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of an AWS Batch job queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobQueueDetail implements SdkPojo, Serializable, ToCopyableBuilder<JobQueueDetail.Builder, JobQueueDetail> {
    private static final SdkField<String> JOB_QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobQueueDetail::jobQueueName)).setter(setter(Builder::jobQueueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueName").build()).build();

    private static final SdkField<String> JOB_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobQueueDetail::jobQueueArn)).setter(setter(Builder::jobQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobQueueDetail::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobQueueDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobQueueDetail::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JobQueueDetail::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<List<ComputeEnvironmentOrder>> COMPUTE_ENVIRONMENT_ORDER_FIELD = SdkField
            .<List<ComputeEnvironmentOrder>> builder(MarshallingType.LIST)
            .getter(getter(JobQueueDetail::computeEnvironmentOrder))
            .setter(setter(Builder::computeEnvironmentOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeEnvironmentOrder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeEnvironmentOrder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(JOB_QUEUE_NAME_FIELD, JOB_QUEUE_ARN_FIELD, STATE_FIELD, STATUS_FIELD,
                    STATUS_REASON_FIELD, PRIORITY_FIELD, COMPUTE_ENVIRONMENT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobQueueName;

    private final String jobQueueArn;

    private final String state;

    private final String status;

    private final String statusReason;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name of the job queue.
     * </p>
     * 
     * @return The name of the job queue.
     */
    public String jobQueueName() {
        return jobQueueName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueueArn() {
        return jobQueueArn;
    }

    /**
     * <p>
     * Describes the ability of the queue to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Describes the ability of the queue to accept new jobs.
     * @see JQState
     */
    public JQState state() {
        return JQState.fromValue(state);
    }

    /**
     * <p>
     * Describes the ability of the queue to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Describes the ability of the queue to accept new jobs.
     * @see JQState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JQStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see JQStatus
     */
    public JQStatus status() {
        return JQStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JQStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see JQStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job queue.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job queue.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The priority of the job queue.
     * </p>
     * 
     * @return The priority of the job queue.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The compute environments that are attached to the job queue and the order in which job placement is preferred.
     * Compute environments are selected for job placement in ascending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The compute environments that are attached to the job queue and the order in which job placement is
     *         preferred. Compute environments are selected for job placement in ascending order.
     */
    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail) obj;
        return Objects.equals(jobQueueName(), other.jobQueueName()) && Objects.equals(jobQueueArn(), other.jobQueueArn())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(priority(), other.priority())
                && Objects.equals(computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobQueueDetail").add("JobQueueName", jobQueueName()).add("JobQueueArn", jobQueueArn())
                .add("State", stateAsString()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("Priority", priority()).add("ComputeEnvironmentOrder", computeEnvironmentOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueueName":
            return Optional.ofNullable(clazz.cast(jobQueueName()));
        case "jobQueueArn":
            return Optional.ofNullable(clazz.cast(jobQueueArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "computeEnvironmentOrder":
            return Optional.ofNullable(clazz.cast(computeEnvironmentOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobQueueDetail, T> g) {
        return obj -> g.apply((JobQueueDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobQueueDetail> {
        /**
         * <p>
         * The name of the job queue.
         * </p>
         * 
         * @param jobQueueName
         *        The name of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueName(String jobQueueName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);

        /**
         * <p>
         * Describes the ability of the queue to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the ability of the queue to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the ability of the queue to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the ability of the queue to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * @see JQStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * @see JQStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQStatus
         */
        Builder status(JQStatus status);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job queue.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job
         *        queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The priority of the job queue.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        The compute environments that are attached to the job queue and the order in which job placement is
         *        preferred. Compute environments are selected for job placement in ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        The compute environments that are attached to the job queue and the order in which job placement is
         *        preferred. Compute environments are selected for job placement in ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComputeEnvironmentOrder>.Builder} avoiding
         * the need to create one manually via {@link List<ComputeEnvironmentOrder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComputeEnvironmentOrder>.Builder#build()} is called
         * immediately and its result is passed to {@link #computeEnvironmentOrder(List<ComputeEnvironmentOrder>)}.
         * 
         * @param computeEnvironmentOrder
         *        a consumer that will call methods on {@link List<ComputeEnvironmentOrder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeEnvironmentOrder(List<ComputeEnvironmentOrder>)
         */
        Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder>... computeEnvironmentOrder);
    }

    static final class BuilderImpl implements Builder {
        private String jobQueueName;

        private String jobQueueArn;

        private String state;

        private String status;

        private String statusReason;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            jobQueueName(model.jobQueueName);
            jobQueueArn(model.jobQueueArn);
            state(model.state);
            status(model.status);
            statusReason(model.statusReason);
            priority(model.priority);
            computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return computeEnvironmentOrder != null ? computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder>... computeEnvironmentOrder) {
            computeEnvironmentOrder(Stream.of(computeEnvironmentOrder)
                    .map(c -> ComputeEnvironmentOrder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
