/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDetail implements SdkPojo, Serializable, ToCopyableBuilder<JobDetail.Builder, JobDetail> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobDetail::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobDetail::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobDetail::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<AttemptDetail>> ATTEMPTS_FIELD = SdkField
            .<List<AttemptDetail>> builder(MarshallingType.LIST)
            .getter(getter(JobDetail::attempts))
            .setter(setter(Builder::attempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttemptDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttemptDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobDetail::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobDetail::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<RetryStrategy> builder(MarshallingType.SDK_POJO).getter(getter(JobDetail::retryStrategy))
            .setter(setter(Builder::retryStrategy)).constructor(RetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobDetail::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobDetail::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<List<JobDependency>> DEPENDS_ON_FIELD = SdkField
            .<List<JobDependency>> builder(MarshallingType.LIST)
            .getter(getter(JobDetail::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobDetail::jobDefinition)).setter(setter(Builder::jobDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(JobDetail::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ContainerDetail> CONTAINER_FIELD = SdkField.<ContainerDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobDetail::container)).setter(setter(Builder::container)).constructor(ContainerDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<NodeDetails> NODE_DETAILS_FIELD = SdkField.<NodeDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobDetail::nodeDetails)).setter(setter(Builder::nodeDetails)).constructor(NodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeDetails").build()).build();

    private static final SdkField<NodeProperties> NODE_PROPERTIES_FIELD = SdkField
            .<NodeProperties> builder(MarshallingType.SDK_POJO).getter(getter(JobDetail::nodeProperties))
            .setter(setter(Builder::nodeProperties)).constructor(NodeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()).build();

    private static final SdkField<ArrayPropertiesDetail> ARRAY_PROPERTIES_FIELD = SdkField
            .<ArrayPropertiesDetail> builder(MarshallingType.SDK_POJO).getter(getter(JobDetail::arrayProperties))
            .setter(setter(Builder::arrayProperties)).constructor(ArrayPropertiesDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()).build();

    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.<JobTimeout> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobDetail::timeout)).setter(setter(Builder::timeout)).constructor(JobTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_ID_FIELD,
            JOB_QUEUE_FIELD, STATUS_FIELD, ATTEMPTS_FIELD, STATUS_REASON_FIELD, CREATED_AT_FIELD, RETRY_STRATEGY_FIELD,
            STARTED_AT_FIELD, STOPPED_AT_FIELD, DEPENDS_ON_FIELD, JOB_DEFINITION_FIELD, PARAMETERS_FIELD, CONTAINER_FIELD,
            NODE_DETAILS_FIELD, NODE_PROPERTIES_FIELD, ARRAY_PROPERTIES_FIELD, TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String jobId;

    private final String jobQueue;

    private final String status;

    private final List<AttemptDetail> attempts;

    private final String statusReason;

    private final Long createdAt;

    private final RetryStrategy retryStrategy;

    private final Long startedAt;

    private final Long stoppedAt;

    private final List<JobDependency> dependsOn;

    private final String jobDefinition;

    private final Map<String, String> parameters;

    private final ContainerDetail container;

    private final NodeDetails nodeDetails;

    private final NodeProperties nodeProperties;

    private final ArrayPropertiesDetail arrayProperties;

    private final JobTimeout timeout;

    private JobDetail(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.jobQueue = builder.jobQueue;
        this.status = builder.status;
        this.attempts = builder.attempts;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.retryStrategy = builder.retryStrategy;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.container = builder.container;
        this.nodeDetails = builder.nodeDetails;
        this.nodeProperties = builder.nodeProperties;
        this.arrayProperties = builder.arrayProperties;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The ID for the job.
     * </p>
     * 
     * @return The ID for the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue with which the job is associated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue with which the job is associated.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs do not progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs Stuck
     * in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch User Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the job. </p> <note>
     *         <p>
     *         If your jobs do not progress to <code>STARTING</code>, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *         Stuck in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch User
     *         Guide</i>.
     *         </p>
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs do not progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs Stuck
     * in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch User Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the job. </p> <note>
     *         <p>
     *         If your jobs do not progress to <code>STARTING</code>, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *         Stuck in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch User
     *         Guide</i>.
     *         </p>
     * @see JobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A list of job attempts associated with this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job attempts associated with this job.
     */
    public List<AttemptDetail> attempts() {
        return attempts;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Unix timestamp (in seconds and milliseconds) for when the job was created. For non-array jobs and parent
     * array jobs, this is when the job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was
     * called). For array child jobs, this is when the child job was spawned by its parent and entered the
     * <code>PENDING</code> state.
     * </p>
     * 
     * @return The Unix timestamp (in seconds and milliseconds) for when the job was created. For non-array jobs and
     *         parent array jobs, this is when the job entered the <code>SUBMITTED</code> state (at the time
     *         <a>SubmitJob</a> was called). For array child jobs, this is when the child job was spawned by its parent
     *         and entered the <code>PENDING</code> state.
     */
    public Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The retry strategy to use for this job if an attempt fails.
     * </p>
     * 
     * @return The retry strategy to use for this job if an attempt fails.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The Unix timestamp (in seconds and milliseconds) for when the job was started (when the job transitioned from the
     * <code>STARTING</code> state to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp (in seconds and milliseconds) for when the job was started (when the job transitioned
     *         from the <code>STARTING</code> state to the <code>RUNNING</code> state).
     */
    public Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in seconds and milliseconds) for when the job was stopped (when the job transitioned from the
     * <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
     * </p>
     * 
     * @return The Unix timestamp (in seconds and milliseconds) for when the job was stopped (when the job transitioned
     *         from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     *         <code>FAILED</code>).
     */
    public Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A list of job names or IDs on which this job depends.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job names or IDs on which this job depends.
     */
    public List<JobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * The job definition that is used by this job.
     * </p>
     * 
     * @return The job definition that is used by this job.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders or override any
     * corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders or override any
     *         corresponding parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * An object representing the details of the container that is associated with the job.
     * </p>
     * 
     * @return An object representing the details of the container that is associated with the job.
     */
    public ContainerDetail container() {
        return container;
    }

    /**
     * <p>
     * An object representing the details of a node that is associated with a multi-node parallel job.
     * </p>
     * 
     * @return An object representing the details of a node that is associated with a multi-node parallel job.
     */
    public NodeDetails nodeDetails() {
        return nodeDetails;
    }

    /**
     * <p>
     * An object representing the node properties of a multi-node parallel job.
     * </p>
     * 
     * @return An object representing the node properties of a multi-node parallel job.
     */
    public NodeProperties nodeProperties() {
        return nodeProperties;
    }

    /**
     * <p>
     * The array properties of the job, if it is an array job.
     * </p>
     * 
     * @return The array properties of the job, if it is an array job.
     */
    public ArrayPropertiesDetail arrayProperties() {
        return arrayProperties;
    }

    /**
     * <p>
     * The timeout configuration for the job.
     * </p>
     * 
     * @return The timeout configuration for the job.
     */
    public JobTimeout timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(attempts(), other.attempts()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(stoppedAt(), other.stoppedAt())
                && Objects.equals(dependsOn(), other.dependsOn()) && Objects.equals(jobDefinition(), other.jobDefinition())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(container(), other.container())
                && Objects.equals(nodeDetails(), other.nodeDetails()) && Objects.equals(nodeProperties(), other.nodeProperties())
                && Objects.equals(arrayProperties(), other.arrayProperties()) && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobDetail").add("JobName", jobName()).add("JobId", jobId()).add("JobQueue", jobQueue())
                .add("Status", statusAsString()).add("Attempts", attempts()).add("StatusReason", statusReason())
                .add("CreatedAt", createdAt()).add("RetryStrategy", retryStrategy()).add("StartedAt", startedAt())
                .add("StoppedAt", stoppedAt()).add("DependsOn", dependsOn()).add("JobDefinition", jobDefinition())
                .add("Parameters", parameters()).add("Container", container()).add("NodeDetails", nodeDetails())
                .add("NodeProperties", nodeProperties()).add("ArrayProperties", arrayProperties()).add("Timeout", timeout())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "dependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "jobDefinition":
            return Optional.ofNullable(clazz.cast(jobDefinition()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        case "nodeDetails":
            return Optional.ofNullable(clazz.cast(nodeDetails()));
        case "nodeProperties":
            return Optional.ofNullable(clazz.cast(nodeProperties()));
        case "arrayProperties":
            return Optional.ofNullable(clazz.cast(arrayProperties()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetail, T> g) {
        return obj -> g.apply((JobDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDetail> {
        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param jobName
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The ID for the job.
         * </p>
         * 
         * @param jobId
         *        The ID for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue with which the job is associated.
         * </p>
         * 
         * @param jobQueue
         *        The Amazon Resource Name (ARN) of the job queue with which the job is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * <note>
         * <p>
         * If your jobs do not progress to <code>STARTING</code>, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
         * Stuck in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch User Guide</i>.
         * </p>
         * </note>
         * 
         * @param status
         *        The current status for the job. </p> <note>
         *        <p>
         *        If your jobs do not progress to <code>STARTING</code>, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable"
         *        >Jobs Stuck in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch
         *        User Guide</i>.
         *        </p>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * <note>
         * <p>
         * If your jobs do not progress to <code>STARTING</code>, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
         * Stuck in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch User Guide</i>.
         * </p>
         * </note>
         * 
         * @param status
         *        The current status for the job. </p> <note>
         *        <p>
         *        If your jobs do not progress to <code>STARTING</code>, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable"
         *        >Jobs Stuck in <code>RUNNABLE</code> Status</a> in the troubleshooting section of the <i>AWS Batch
         *        User Guide</i>.
         *        </p>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * A list of job attempts associated with this job.
         * </p>
         * 
         * @param attempts
         *        A list of job attempts associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Collection<AttemptDetail> attempts);

        /**
         * <p>
         * A list of job attempts associated with this job.
         * </p>
         * 
         * @param attempts
         *        A list of job attempts associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(AttemptDetail... attempts);

        /**
         * <p>
         * A list of job attempts associated with this job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttemptDetail>.Builder} avoiding the need
         * to create one manually via {@link List<AttemptDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttemptDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #attempts(List<AttemptDetail>)}.
         * 
         * @param attempts
         *        a consumer that will call methods on {@link List<AttemptDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attempts(List<AttemptDetail>)
         */
        Builder attempts(Consumer<AttemptDetail.Builder>... attempts);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Unix timestamp (in seconds and milliseconds) for when the job was created. For non-array jobs and parent
         * array jobs, this is when the job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was
         * called). For array child jobs, this is when the child job was spawned by its parent and entered the
         * <code>PENDING</code> state.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp (in seconds and milliseconds) for when the job was created. For non-array jobs and
         *        parent array jobs, this is when the job entered the <code>SUBMITTED</code> state (at the time
         *        <a>SubmitJob</a> was called). For array child jobs, this is when the child job was spawned by its
         *        parent and entered the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * The retry strategy to use for this job if an attempt fails.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for this job if an attempt fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for this job if an attempt fails.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The Unix timestamp (in seconds and milliseconds) for when the job was started (when the job transitioned from
         * the <code>STARTING</code> state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in seconds and milliseconds) for when the job was started (when the job
         *        transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in seconds and milliseconds) for when the job was stopped (when the job transitioned from
         * the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in seconds and milliseconds) for when the job was stopped (when the job
         *        transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code>
         *        or <code>FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A list of job names or IDs on which this job depends.
         * </p>
         * 
         * @param dependsOn
         *        A list of job names or IDs on which this job depends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<JobDependency> dependsOn);

        /**
         * <p>
         * A list of job names or IDs on which this job depends.
         * </p>
         * 
         * @param dependsOn
         *        A list of job names or IDs on which this job depends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(JobDependency... dependsOn);

        /**
         * <p>
         * A list of job names or IDs on which this job depends.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDependency>.Builder} avoiding the need
         * to create one manually via {@link List<JobDependency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDependency>.Builder#build()} is called immediately and
         * its result is passed to {@link #dependsOn(List<JobDependency>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on {@link List<JobDependency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(List<JobDependency>)
         */
        Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn);

        /**
         * <p>
         * The job definition that is used by this job.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition that is used by this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders or override any
         * corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders or override
         *        any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * An object representing the details of the container that is associated with the job.
         * </p>
         * 
         * @param container
         *        An object representing the details of the container that is associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerDetail container);

        /**
         * <p>
         * An object representing the details of the container that is associated with the job.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerDetail.Builder} avoiding the need to
         * create one manually via {@link ContainerDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #container(ContainerDetail)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerDetail)
         */
        default Builder container(Consumer<ContainerDetail.Builder> container) {
            return container(ContainerDetail.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * An object representing the details of a node that is associated with a multi-node parallel job.
         * </p>
         * 
         * @param nodeDetails
         *        An object representing the details of a node that is associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDetails(NodeDetails nodeDetails);

        /**
         * <p>
         * An object representing the details of a node that is associated with a multi-node parallel job.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeDetails.Builder} avoiding the need to create
         * one manually via {@link NodeDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #nodeDetails(NodeDetails)}.
         * 
         * @param nodeDetails
         *        a consumer that will call methods on {@link NodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeDetails(NodeDetails)
         */
        default Builder nodeDetails(Consumer<NodeDetails.Builder> nodeDetails) {
            return nodeDetails(NodeDetails.builder().applyMutation(nodeDetails).build());
        }

        /**
         * <p>
         * An object representing the node properties of a multi-node parallel job.
         * </p>
         * 
         * @param nodeProperties
         *        An object representing the node properties of a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeProperties(NodeProperties nodeProperties);

        /**
         * <p>
         * An object representing the node properties of a multi-node parallel job.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeProperties.Builder} avoiding the need to
         * create one manually via {@link NodeProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeProperties(NodeProperties)}.
         * 
         * @param nodeProperties
         *        a consumer that will call methods on {@link NodeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeProperties(NodeProperties)
         */
        default Builder nodeProperties(Consumer<NodeProperties.Builder> nodeProperties) {
            return nodeProperties(NodeProperties.builder().applyMutation(nodeProperties).build());
        }

        /**
         * <p>
         * The array properties of the job, if it is an array job.
         * </p>
         * 
         * @param arrayProperties
         *        The array properties of the job, if it is an array job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayProperties(ArrayPropertiesDetail arrayProperties);

        /**
         * <p>
         * The array properties of the job, if it is an array job.
         * </p>
         * This is a convenience that creates an instance of the {@link ArrayPropertiesDetail.Builder} avoiding the need
         * to create one manually via {@link ArrayPropertiesDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArrayPropertiesDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #arrayProperties(ArrayPropertiesDetail)}.
         * 
         * @param arrayProperties
         *        a consumer that will call methods on {@link ArrayPropertiesDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayProperties(ArrayPropertiesDetail)
         */
        default Builder arrayProperties(Consumer<ArrayPropertiesDetail.Builder> arrayProperties) {
            return arrayProperties(ArrayPropertiesDetail.builder().applyMutation(arrayProperties).build());
        }

        /**
         * <p>
         * The timeout configuration for the job.
         * </p>
         * 
         * @param timeout
         *        The timeout configuration for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(JobTimeout timeout);

        /**
         * <p>
         * The timeout configuration for the job.
         * </p>
         * This is a convenience that creates an instance of the {@link JobTimeout.Builder} avoiding the need to create
         * one manually via {@link JobTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(JobTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link JobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(JobTimeout)
         */
        default Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return timeout(JobTimeout.builder().applyMutation(timeout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobId;

        private String jobQueue;

        private String status;

        private List<AttemptDetail> attempts = DefaultSdkAutoConstructList.getInstance();

        private String statusReason;

        private Long createdAt;

        private RetryStrategy retryStrategy;

        private Long startedAt;

        private Long stoppedAt;

        private List<JobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private String jobDefinition;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private ContainerDetail container;

        private NodeDetails nodeDetails;

        private NodeProperties nodeProperties;

        private ArrayPropertiesDetail arrayProperties;

        private JobTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetail model) {
            jobName(model.jobName);
            jobId(model.jobId);
            jobQueue(model.jobQueue);
            status(model.status);
            attempts(model.attempts);
            statusReason(model.statusReason);
            createdAt(model.createdAt);
            retryStrategy(model.retryStrategy);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            dependsOn(model.dependsOn);
            jobDefinition(model.jobDefinition);
            parameters(model.parameters);
            container(model.container);
            nodeDetails(model.nodeDetails);
            nodeProperties(model.nodeProperties);
            arrayProperties(model.arrayProperties);
            timeout(model.timeout);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<AttemptDetail.Builder> getAttempts() {
            return attempts != null ? attempts.stream().map(AttemptDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attempts(Collection<AttemptDetail> attempts) {
            this.attempts = AttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(AttemptDetail... attempts) {
            attempts(Arrays.asList(attempts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(Consumer<AttemptDetail.Builder>... attempts) {
            attempts(Stream.of(attempts).map(c -> AttemptDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttempts(Collection<AttemptDetail.BuilderImpl> attempts) {
            this.attempts = AttemptDetailsCopier.copyFromBuilder(attempts);
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final Collection<JobDependency.Builder> getDependsOn() {
            return dependsOn != null ? dependsOn.stream().map(JobDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn).map(c -> JobDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerDetail.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final NodeDetails.Builder getNodeDetails() {
            return nodeDetails != null ? nodeDetails.toBuilder() : null;
        }

        @Override
        public final Builder nodeDetails(NodeDetails nodeDetails) {
            this.nodeDetails = nodeDetails;
            return this;
        }

        public final void setNodeDetails(NodeDetails.BuilderImpl nodeDetails) {
            this.nodeDetails = nodeDetails != null ? nodeDetails.build() : null;
        }

        public final NodeProperties.Builder getNodeProperties() {
            return nodeProperties != null ? nodeProperties.toBuilder() : null;
        }

        @Override
        public final Builder nodeProperties(NodeProperties nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final void setNodeProperties(NodeProperties.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        public final ArrayPropertiesDetail.Builder getArrayProperties() {
            return arrayProperties != null ? arrayProperties.toBuilder() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayPropertiesDetail arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final void setArrayProperties(ArrayPropertiesDetail.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        public final JobTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public JobDetail build() {
            return new JobDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
