/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the node properties of a multi-node parallel job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeProperties implements SdkPojo, Serializable, ToCopyableBuilder<NodeProperties.Builder, NodeProperties> {
    private static final SdkField<Integer> NUM_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NodeProperties::numNodes)).setter(setter(Builder::numNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodes").build()).build();

    private static final SdkField<Integer> MAIN_NODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NodeProperties::mainNode)).setter(setter(Builder::mainNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mainNode").build()).build();

    private static final SdkField<List<NodeRangeProperty>> NODE_RANGE_PROPERTIES_FIELD = SdkField
            .<List<NodeRangeProperty>> builder(MarshallingType.LIST)
            .getter(getter(NodeProperties::nodeRangeProperties))
            .setter(setter(Builder::nodeRangeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRangeProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeRangeProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeRangeProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_NODES_FIELD,
            MAIN_NODE_FIELD, NODE_RANGE_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numNodes;

    private final Integer mainNode;

    private final List<NodeRangeProperty> nodeRangeProperties;

    private NodeProperties(BuilderImpl builder) {
        this.numNodes = builder.numNodes;
        this.mainNode = builder.mainNode;
        this.nodeRangeProperties = builder.nodeRangeProperties;
    }

    /**
     * <p>
     * The number of nodes associated with a multi-node parallel job.
     * </p>
     * 
     * @return The number of nodes associated with a multi-node parallel job.
     */
    public Integer numNodes() {
        return numNodes;
    }

    /**
     * <p>
     * Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than
     * the number of nodes.
     * </p>
     * 
     * @return Specifies the node index for the main node of a multi-node parallel job. This node index value must be
     *         fewer than the number of nodes.
     */
    public Integer mainNode() {
        return mainNode;
    }

    /**
     * <p>
     * A list of node ranges and their properties associated with a multi-node parallel job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of node ranges and their properties associated with a multi-node parallel job.
     */
    public List<NodeRangeProperty> nodeRangeProperties() {
        return nodeRangeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numNodes());
        hashCode = 31 * hashCode + Objects.hashCode(mainNode());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRangeProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeProperties)) {
            return false;
        }
        NodeProperties other = (NodeProperties) obj;
        return Objects.equals(numNodes(), other.numNodes()) && Objects.equals(mainNode(), other.mainNode())
                && Objects.equals(nodeRangeProperties(), other.nodeRangeProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NodeProperties").add("NumNodes", numNodes()).add("MainNode", mainNode())
                .add("NodeRangeProperties", nodeRangeProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numNodes":
            return Optional.ofNullable(clazz.cast(numNodes()));
        case "mainNode":
            return Optional.ofNullable(clazz.cast(mainNode()));
        case "nodeRangeProperties":
            return Optional.ofNullable(clazz.cast(nodeRangeProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeProperties, T> g) {
        return obj -> g.apply((NodeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeProperties> {
        /**
         * <p>
         * The number of nodes associated with a multi-node parallel job.
         * </p>
         * 
         * @param numNodes
         *        The number of nodes associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numNodes(Integer numNodes);

        /**
         * <p>
         * Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer
         * than the number of nodes.
         * </p>
         * 
         * @param mainNode
         *        Specifies the node index for the main node of a multi-node parallel job. This node index value must be
         *        fewer than the number of nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mainNode(Integer mainNode);

        /**
         * <p>
         * A list of node ranges and their properties associated with a multi-node parallel job.
         * </p>
         * 
         * @param nodeRangeProperties
         *        A list of node ranges and their properties associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties);

        /**
         * <p>
         * A list of node ranges and their properties associated with a multi-node parallel job.
         * </p>
         * 
         * @param nodeRangeProperties
         *        A list of node ranges and their properties associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRangeProperties(NodeRangeProperty... nodeRangeProperties);

        /**
         * <p>
         * A list of node ranges and their properties associated with a multi-node parallel job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeRangeProperty>.Builder} avoiding the
         * need to create one manually via {@link List<NodeRangeProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeRangeProperty>.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeRangeProperties(List<NodeRangeProperty>)}.
         * 
         * @param nodeRangeProperties
         *        a consumer that will call methods on {@link List<NodeRangeProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeRangeProperties(List<NodeRangeProperty>)
         */
        Builder nodeRangeProperties(Consumer<NodeRangeProperty.Builder>... nodeRangeProperties);
    }

    static final class BuilderImpl implements Builder {
        private Integer numNodes;

        private Integer mainNode;

        private List<NodeRangeProperty> nodeRangeProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeProperties model) {
            numNodes(model.numNodes);
            mainNode(model.mainNode);
            nodeRangeProperties(model.nodeRangeProperties);
        }

        public final Integer getNumNodes() {
            return numNodes;
        }

        @Override
        public final Builder numNodes(Integer numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        public final void setNumNodes(Integer numNodes) {
            this.numNodes = numNodes;
        }

        public final Integer getMainNode() {
            return mainNode;
        }

        @Override
        public final Builder mainNode(Integer mainNode) {
            this.mainNode = mainNode;
            return this;
        }

        public final void setMainNode(Integer mainNode) {
            this.mainNode = mainNode;
        }

        public final Collection<NodeRangeProperty.Builder> getNodeRangeProperties() {
            return nodeRangeProperties != null ? nodeRangeProperties.stream().map(NodeRangeProperty::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties) {
            this.nodeRangeProperties = NodeRangePropertiesCopier.copy(nodeRangeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRangeProperties(NodeRangeProperty... nodeRangeProperties) {
            nodeRangeProperties(Arrays.asList(nodeRangeProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRangeProperties(Consumer<NodeRangeProperty.Builder>... nodeRangeProperties) {
            nodeRangeProperties(Stream.of(nodeRangeProperties).map(c -> NodeRangeProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNodeRangeProperties(Collection<NodeRangeProperty.BuilderImpl> nodeRangeProperties) {
            this.nodeRangeProperties = NodeRangePropertiesCopier.copyFromBuilder(nodeRangeProperties);
        }

        @Override
        public NodeProperties build() {
            return new NodeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
