/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdashboards.model.VisualType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphDisplayConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GraphDisplayConfig> {
    private static final SdkField<String> VISUAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visualType").getter(GraphDisplayConfig.getter(GraphDisplayConfig::visualTypeAsString)).setter(GraphDisplayConfig.setter(Builder::visualType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visualType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GraphDisplayConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visualType;

    private GraphDisplayConfig(BuilderImpl builder) {
        this.visualType = builder.visualType;
    }

    public final VisualType visualType() {
        return VisualType.fromValue(this.visualType);
    }

    public final String visualTypeAsString() {
        return this.visualType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphDisplayConfig)) {
            return false;
        }
        GraphDisplayConfig other = (GraphDisplayConfig)obj;
        return Objects.equals(this.visualTypeAsString(), other.visualTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GraphDisplayConfig").add("VisualType", (Object)this.visualTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "visualType": {
                return Optional.ofNullable(clazz.cast(this.visualTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("visualType", VISUAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphDisplayConfig, T> g) {
        return obj -> g.apply((GraphDisplayConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualType;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphDisplayConfig model) {
            this.visualType(model.visualType);
        }

        public final String getVisualType() {
            return this.visualType;
        }

        public final void setVisualType(String visualType) {
            this.visualType = visualType;
        }

        @Override
        public final Builder visualType(String visualType) {
            this.visualType = visualType;
            return this;
        }

        @Override
        public final Builder visualType(VisualType visualType) {
            this.visualType(visualType == null ? null : visualType.toString());
            return this;
        }

        public GraphDisplayConfig build() {
            return new GraphDisplayConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GraphDisplayConfig> {
        public Builder visualType(String var1);

        public Builder visualType(VisualType var1);
    }
}

