/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configurable visualization component within a dashboard that displays specific cost and usage metrics. Each widget
 * can show data as charts or tables and includes settings for data querying, filtering, and visual presentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Widget implements SdkPojo, Serializable, ToCopyableBuilder<Widget.Builder, Widget> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Widget::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Widget::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("width")
            .getter(getter(Widget::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("height").getter(getter(Widget::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Integer> HORIZONTAL_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("horizontalOffset").getter(getter(Widget::horizontalOffset)).setter(setter(Builder::horizontalOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("horizontalOffset").build()).build();

    private static final SdkField<List<WidgetConfig>> CONFIGS_FIELD = SdkField
            .<List<WidgetConfig>> builder(MarshallingType.LIST)
            .memberName("configs")
            .getter(getter(Widget::configs))
            .setter(setter(Builder::configs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WidgetConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(WidgetConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            DESCRIPTION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, HORIZONTAL_OFFSET_FIELD, CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String description;

    private final Integer width;

    private final Integer height;

    private final Integer horizontalOffset;

    private final List<WidgetConfig> configs;

    private Widget(BuilderImpl builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.width = builder.width;
        this.height = builder.height;
        this.horizontalOffset = builder.horizontalOffset;
        this.configs = builder.configs;
    }

    /**
     * <p>
     * The title of the widget.
     * </p>
     * 
     * @return The title of the widget.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A description of the widget's purpose or the data it displays.
     * </p>
     * 
     * @return A description of the widget's purpose or the data it displays.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The width of the widget in column spans. The dashboard layout consists of a grid system.
     * </p>
     * 
     * @return The width of the widget in column spans. The dashboard layout consists of a grid system.
     */
    public final Integer width() {
        return width;
    }

    /**
     * <p>
     * The height of the widget in row spans. The dashboard layout consists of a grid system.
     * </p>
     * 
     * @return The height of the widget in row spans. The dashboard layout consists of a grid system.
     */
    public final Integer height() {
        return height;
    }

    /**
     * <p>
     * Specifies the starting column position of the widget in the dashboard's grid layout. Used to control widget
     * placement.
     * </p>
     * 
     * @return Specifies the starting column position of the widget in the dashboard's grid layout. Used to control
     *         widget placement.
     */
    public final Integer horizontalOffset() {
        return horizontalOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfigs() {
        return configs != null && !(configs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of configurations that define the data queries and display settings for the widget.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigs} method.
     * </p>
     * 
     * @return An array of configurations that define the data queries and display settings for the widget.
     */
    public final List<WidgetConfig> configs() {
        return configs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(horizontalOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigs() ? configs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Widget)) {
            return false;
        }
        Widget other = (Widget) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(width(), other.width()) && Objects.equals(height(), other.height())
                && Objects.equals(horizontalOffset(), other.horizontalOffset()) && hasConfigs() == other.hasConfigs()
                && Objects.equals(configs(), other.configs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Widget").add("Title", title()).add("Description", description()).add("Width", width())
                .add("Height", height()).add("HorizontalOffset", horizontalOffset())
                .add("Configs", hasConfigs() ? configs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "width":
            return Optional.ofNullable(clazz.cast(width()));
        case "height":
            return Optional.ofNullable(clazz.cast(height()));
        case "horizontalOffset":
            return Optional.ofNullable(clazz.cast(horizontalOffset()));
        case "configs":
            return Optional.ofNullable(clazz.cast(configs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("horizontalOffset", HORIZONTAL_OFFSET_FIELD);
        map.put("configs", CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Widget, T> g) {
        return obj -> g.apply((Widget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Widget> {
        /**
         * <p>
         * The title of the widget.
         * </p>
         * 
         * @param title
         *        The title of the widget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A description of the widget's purpose or the data it displays.
         * </p>
         * 
         * @param description
         *        A description of the widget's purpose or the data it displays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The width of the widget in column spans. The dashboard layout consists of a grid system.
         * </p>
         * 
         * @param width
         *        The width of the widget in column spans. The dashboard layout consists of a grid system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * The height of the widget in row spans. The dashboard layout consists of a grid system.
         * </p>
         * 
         * @param height
         *        The height of the widget in row spans. The dashboard layout consists of a grid system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * <p>
         * Specifies the starting column position of the widget in the dashboard's grid layout. Used to control widget
         * placement.
         * </p>
         * 
         * @param horizontalOffset
         *        Specifies the starting column position of the widget in the dashboard's grid layout. Used to control
         *        widget placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horizontalOffset(Integer horizontalOffset);

        /**
         * <p>
         * An array of configurations that define the data queries and display settings for the widget.
         * </p>
         * 
         * @param configs
         *        An array of configurations that define the data queries and display settings for the widget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configs(Collection<WidgetConfig> configs);

        /**
         * <p>
         * An array of configurations that define the data queries and display settings for the widget.
         * </p>
         * 
         * @param configs
         *        An array of configurations that define the data queries and display settings for the widget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configs(WidgetConfig... configs);

        /**
         * <p>
         * An array of configurations that define the data queries and display settings for the widget.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmdashboards.model.WidgetConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bcmdashboards.model.WidgetConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmdashboards.model.WidgetConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #configs(List<WidgetConfig>)}.
         * 
         * @param configs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmdashboards.model.WidgetConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configs(java.util.Collection<WidgetConfig>)
         */
        Builder configs(Consumer<WidgetConfig.Builder>... configs);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String description;

        private Integer width;

        private Integer height;

        private Integer horizontalOffset;

        private List<WidgetConfig> configs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Widget model) {
            title(model.title);
            description(model.description);
            width(model.width);
            height(model.height);
            horizontalOffset(model.horizontalOffset);
            configs(model.configs);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getHorizontalOffset() {
            return horizontalOffset;
        }

        public final void setHorizontalOffset(Integer horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
        }

        @Override
        public final Builder horizontalOffset(Integer horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public final List<WidgetConfig.Builder> getConfigs() {
            List<WidgetConfig.Builder> result = WidgetConfigListCopier.copyToBuilder(this.configs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigs(Collection<WidgetConfig.BuilderImpl> configs) {
            this.configs = WidgetConfigListCopier.copyFromBuilder(configs);
        }

        @Override
        public final Builder configs(Collection<WidgetConfig> configs) {
            this.configs = WidgetConfigListCopier.copy(configs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configs(WidgetConfig... configs) {
            configs(Arrays.asList(configs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configs(Consumer<WidgetConfig.Builder>... configs) {
            configs(Stream.of(configs).map(c -> WidgetConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Widget build() {
            return new Widget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
