/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the complete configuration for a widget, including data retrieval settings and visualization preferences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WidgetConfig implements SdkPojo, Serializable, ToCopyableBuilder<WidgetConfig.Builder, WidgetConfig> {
    private static final SdkField<QueryParameters> QUERY_PARAMETERS_FIELD = SdkField
            .<QueryParameters> builder(MarshallingType.SDK_POJO).memberName("queryParameters")
            .getter(getter(WidgetConfig::queryParameters)).setter(setter(Builder::queryParameters))
            .constructor(QueryParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParameters").build()).build();

    private static final SdkField<DisplayConfig> DISPLAY_CONFIG_FIELD = SdkField
            .<DisplayConfig> builder(MarshallingType.SDK_POJO).memberName("displayConfig")
            .getter(getter(WidgetConfig::displayConfig)).setter(setter(Builder::displayConfig))
            .constructor(DisplayConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_PARAMETERS_FIELD,
            DISPLAY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QueryParameters queryParameters;

    private final DisplayConfig displayConfig;

    private WidgetConfig(BuilderImpl builder) {
        this.queryParameters = builder.queryParameters;
        this.displayConfig = builder.displayConfig;
    }

    /**
     * <p>
     * The parameters that define what data the widget should retrieve and how it should be filtered or grouped.
     * </p>
     * 
     * @return The parameters that define what data the widget should retrieve and how it should be filtered or grouped.
     */
    public final QueryParameters queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The configuration that determines how the retrieved data should be visualized in the widget.
     * </p>
     * 
     * @return The configuration that determines how the retrieved data should be visualized in the widget.
     */
    public final DisplayConfig displayConfig() {
        return displayConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryParameters());
        hashCode = 31 * hashCode + Objects.hashCode(displayConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WidgetConfig)) {
            return false;
        }
        WidgetConfig other = (WidgetConfig) obj;
        return Objects.equals(queryParameters(), other.queryParameters())
                && Objects.equals(displayConfig(), other.displayConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WidgetConfig").add("QueryParameters", queryParameters()).add("DisplayConfig", displayConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "displayConfig":
            return Optional.ofNullable(clazz.cast(displayConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryParameters", QUERY_PARAMETERS_FIELD);
        map.put("displayConfig", DISPLAY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WidgetConfig, T> g) {
        return obj -> g.apply((WidgetConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WidgetConfig> {
        /**
         * <p>
         * The parameters that define what data the widget should retrieve and how it should be filtered or grouped.
         * </p>
         * 
         * @param queryParameters
         *        The parameters that define what data the widget should retrieve and how it should be filtered or
         *        grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(QueryParameters queryParameters);

        /**
         * <p>
         * The parameters that define what data the widget should retrieve and how it should be filtered or grouped.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryParameters.Builder} avoiding the
         * need to create one manually via {@link QueryParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #queryParameters(QueryParameters)}.
         * 
         * @param queryParameters
         *        a consumer that will call methods on {@link QueryParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryParameters(QueryParameters)
         */
        default Builder queryParameters(Consumer<QueryParameters.Builder> queryParameters) {
            return queryParameters(QueryParameters.builder().applyMutation(queryParameters).build());
        }

        /**
         * <p>
         * The configuration that determines how the retrieved data should be visualized in the widget.
         * </p>
         * 
         * @param displayConfig
         *        The configuration that determines how the retrieved data should be visualized in the widget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayConfig(DisplayConfig displayConfig);

        /**
         * <p>
         * The configuration that determines how the retrieved data should be visualized in the widget.
         * </p>
         * This is a convenience method that creates an instance of the {@link DisplayConfig.Builder} avoiding the need
         * to create one manually via {@link DisplayConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisplayConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #displayConfig(DisplayConfig)}.
         * 
         * @param displayConfig
         *        a consumer that will call methods on {@link DisplayConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayConfig(DisplayConfig)
         */
        default Builder displayConfig(Consumer<DisplayConfig.Builder> displayConfig) {
            return displayConfig(DisplayConfig.builder().applyMutation(displayConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueryParameters queryParameters;

        private DisplayConfig displayConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(WidgetConfig model) {
            queryParameters(model.queryParameters);
            displayConfig(model.displayConfig);
        }

        public final QueryParameters.Builder getQueryParameters() {
            return queryParameters != null ? queryParameters.toBuilder() : null;
        }

        public final void setQueryParameters(QueryParameters.BuilderImpl queryParameters) {
            this.queryParameters = queryParameters != null ? queryParameters.build() : null;
        }

        @Override
        public final Builder queryParameters(QueryParameters queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public final DisplayConfig.Builder getDisplayConfig() {
            return displayConfig != null ? displayConfig.toBuilder() : null;
        }

        public final void setDisplayConfig(DisplayConfig.BuilderImpl displayConfig) {
            this.displayConfig = displayConfig != null ? displayConfig.build() : null;
        }

        @Override
        public final Builder displayConfig(DisplayConfig displayConfig) {
            this.displayConfig = displayConfig;
            return this;
        }

        @Override
        public WidgetConfig build() {
            return new WidgetConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
