/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference details for a given export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportReference implements SdkPojo, Serializable, ToCopyableBuilder<ExportReference.Builder, ExportReference> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportArn").getter(getter(ExportReference::exportArn)).setter(setter(Builder::exportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()).build();

    private static final SdkField<String> EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportName").getter(getter(ExportReference::exportName)).setter(setter(Builder::exportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportName").build()).build();

    private static final SdkField<ExportStatus> EXPORT_STATUS_FIELD = SdkField.<ExportStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ExportStatus").getter(getter(ExportReference::exportStatus)).setter(setter(Builder::exportStatus))
            .constructor(ExportStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD,
            EXPORT_NAME_FIELD, EXPORT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exportArn;

    private final String exportName;

    private final ExportStatus exportStatus;

    private ExportReference(BuilderImpl builder) {
        this.exportArn = builder.exportArn;
        this.exportName = builder.exportName;
        this.exportStatus = builder.exportStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this export.
     */
    public final String exportArn() {
        return exportArn;
    }

    /**
     * <p>
     * The name of this specific data export.
     * </p>
     * 
     * @return The name of this specific data export.
     */
    public final String exportName() {
        return exportName;
    }

    /**
     * <p>
     * The status of this specific data export.
     * </p>
     * 
     * @return The status of this specific data export.
     */
    public final ExportStatus exportStatus() {
        return exportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportName());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportReference)) {
            return false;
        }
        ExportReference other = (ExportReference) obj;
        return Objects.equals(exportArn(), other.exportArn()) && Objects.equals(exportName(), other.exportName())
                && Objects.equals(exportStatus(), other.exportStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportReference").add("ExportArn", exportArn()).add("ExportName", exportName())
                .add("ExportStatus", exportStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportArn":
            return Optional.ofNullable(clazz.cast(exportArn()));
        case "ExportName":
            return Optional.ofNullable(clazz.cast(exportName()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportReference, T> g) {
        return obj -> g.apply((ExportReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportReference> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for this export.
         * </p>
         * 
         * @param exportArn
         *        The Amazon Resource Name (ARN) for this export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportArn(String exportArn);

        /**
         * <p>
         * The name of this specific data export.
         * </p>
         * 
         * @param exportName
         *        The name of this specific data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportName(String exportName);

        /**
         * <p>
         * The status of this specific data export.
         * </p>
         * 
         * @param exportStatus
         *        The status of this specific data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * The status of this specific data export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportStatus.Builder} avoiding the need
         * to create one manually via {@link ExportStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #exportStatus(ExportStatus)}.
         * 
         * @param exportStatus
         *        a consumer that will call methods on {@link ExportStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportStatus(ExportStatus)
         */
        default Builder exportStatus(Consumer<ExportStatus.Builder> exportStatus) {
            return exportStatus(ExportStatus.builder().applyMutation(exportStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String exportArn;

        private String exportName;

        private ExportStatus exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportReference model) {
            exportArn(model.exportArn);
            exportName(model.exportName);
            exportStatus(model.exportStatus);
        }

        public final String getExportArn() {
            return exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final String getExportName() {
            return exportName;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final ExportStatus.Builder getExportStatus() {
            return exportStatus != null ? exportStatus.toBuilder() : null;
        }

        public final void setExportStatus(ExportStatus.BuilderImpl exportStatus) {
            this.exportStatus = exportStatus != null ? exportStatus.build() : null;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public ExportReference build() {
            return new ExportReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
