/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference for the data export update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionReference implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionReference.Builder, ExecutionReference> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(ExecutionReference::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField
            .<ExecutionStatus> builder(MarshallingType.SDK_POJO).memberName("ExecutionStatus")
            .getter(getter(ExecutionReference::executionStatus)).setter(setter(Builder::executionStatus))
            .constructor(ExecutionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            EXECUTION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionId;

    private final ExecutionStatus executionStatus;

    private ExecutionReference(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.executionStatus = builder.executionStatus;
    }

    /**
     * <p>
     * The ID for this specific execution.
     * </p>
     * 
     * @return The ID for this specific execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The status of this specific execution.
     * </p>
     * 
     * @return The status of this specific execution.
     */
    public final ExecutionStatus executionStatus() {
        return executionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionReference)) {
            return false;
        }
        ExecutionReference other = (ExecutionReference) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(executionStatus(), other.executionStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionReference").add("ExecutionId", executionId()).add("ExecutionStatus", executionStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "ExecutionStatus":
            return Optional.ofNullable(clazz.cast(executionStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionReference, T> g) {
        return obj -> g.apply((ExecutionReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionReference> {
        /**
         * <p>
         * The ID for this specific execution.
         * </p>
         * 
         * @param executionId
         *        The ID for this specific execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The status of this specific execution.
         * </p>
         * 
         * @param executionStatus
         *        The status of this specific execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The status of this specific execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStatus.Builder} avoiding the
         * need to create one manually via {@link ExecutionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #executionStatus(ExecutionStatus)}.
         * 
         * @param executionStatus
         *        a consumer that will call methods on {@link ExecutionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStatus(ExecutionStatus)
         */
        default Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return executionStatus(ExecutionStatus.builder().applyMutation(executionStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionId;

        private ExecutionStatus executionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionReference model) {
            executionId(model.executionId);
            executionStatus(model.executionStatus);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return executionStatus != null ? executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public ExecutionReference build() {
            return new ExecutionReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
