/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.Column;
import software.amazon.awssdk.services.bcmdataexports.model.ColumnListCopier;
import software.amazon.awssdk.services.bcmdataexports.model.TablePropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableResponse
extends BcmDataExportsResponse
implements ToCopyableBuilder<Builder, GetTableResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetTableResponse.getter(GetTableResponse::description)).setter(GetTableResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Column>> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Schema").getter(GetTableResponse.getter(GetTableResponse::schema)).setter(GetTableResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetTableResponse.getter(GetTableResponse::tableName)).setter(GetTableResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Map<String, String>> TABLE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TableProperties").getter(GetTableResponse.getter(GetTableResponse::tableProperties)).setter(GetTableResponse.setter(Builder::tableProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, SCHEMA_FIELD, TABLE_NAME_FIELD, TABLE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Schema", SCHEMA_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("TableProperties", TABLE_PROPERTIES_FIELD);
        }
    });
    private final String description;
    private final List<Column> schema;
    private final String tableName;
    private final Map<String, String> tableProperties;

    private GetTableResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.schema = builder.schema;
        this.tableName = builder.tableName;
        this.tableProperties = builder.tableProperties;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSchema() {
        return this.schema != null && !(this.schema instanceof SdkAutoConstructList);
    }

    public final List<Column> schema() {
        return this.schema;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasTableProperties() {
        return this.tableProperties != null && !(this.tableProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tableProperties() {
        return this.tableProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchema() ? this.schema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableProperties() ? this.tableProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableResponse)) {
            return false;
        }
        GetTableResponse other = (GetTableResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasSchema() == other.hasSchema() && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.tableName(), other.tableName()) && this.hasTableProperties() == other.hasTableProperties() && Objects.equals(this.tableProperties(), other.tableProperties());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableResponse").add("Description", (Object)this.description()).add("Schema", this.hasSchema() ? this.schema() : null).add("TableName", (Object)this.tableName()).add("TableProperties", this.hasTableProperties() ? this.tableProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableProperties": {
                return Optional.ofNullable(clazz.cast(this.tableProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableResponse, T> g) {
        return obj -> g.apply((GetTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsResponse.BuilderImpl
    implements Builder {
        private String description;
        private List<Column> schema = DefaultSdkAutoConstructList.getInstance();
        private String tableName;
        private Map<String, String> tableProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableResponse model) {
            super(model);
            this.description(model.description);
            this.schema(model.schema);
            this.tableName(model.tableName);
            this.tableProperties(model.tableProperties);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Column.Builder> getSchema() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.schema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchema(Collection<Column.BuilderImpl> schema) {
            this.schema = ColumnListCopier.copyFromBuilder(schema);
        }

        @Override
        public final Builder schema(Collection<Column> schema) {
            this.schema = ColumnListCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Column ... schema) {
            this.schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<Column.Builder> ... schema) {
            this.schema(Stream.of(schema).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, String> getTableProperties() {
            if (this.tableProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tableProperties;
        }

        public final void setTableProperties(Map<String, String> tableProperties) {
            this.tableProperties = TablePropertiesCopier.copy(tableProperties);
        }

        @Override
        public final Builder tableProperties(Map<String, String> tableProperties) {
            this.tableProperties = TablePropertiesCopier.copy(tableProperties);
            return this;
        }

        @Override
        public GetTableResponse build() {
            return new GetTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmDataExportsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableResponse> {
        public Builder description(String var1);

        public Builder schema(Collection<Column> var1);

        public Builder schema(Column ... var1);

        public Builder schema(Consumer<Column.Builder> ... var1);

        public Builder tableName(String var1);

        public Builder tableProperties(Map<String, String> var1);
    }
}

