/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportRequest extends BcmDataExportsRequest implements
        ToCopyableBuilder<GetExportRequest.Builder, GetExportRequest> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportArn").getter(getter(GetExportRequest::exportArn)).setter(setter(Builder::exportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ExportArn", EXPORT_ARN_FIELD);
                }
            });

    private final String exportArn;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.exportArn = builder.exportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this export.
     */
    public final String exportArn() {
        return exportArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest) obj;
        return Objects.equals(exportArn(), other.exportArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportRequest").add("ExportArn", exportArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportArn":
            return Optional.ofNullable(clazz.cast(exportArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExportRequest, T> g) {
        return obj -> g.apply((GetExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmDataExportsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetExportRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for this export.
         * </p>
         * 
         * @param exportArn
         *        The Amazon Resource Name (ARN) for this export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportArn(String exportArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmDataExportsRequest.BuilderImpl implements Builder {
        private String exportArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            super(model);
            exportArn(model.exportArn);
        }

        public final String getExportArn() {
            return exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
