/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportResponse extends BcmDataExportsResponse implements
        ToCopyableBuilder<GetExportResponse.Builder, GetExportResponse> {
    private static final SdkField<Export> EXPORT_FIELD = SdkField.<Export> builder(MarshallingType.SDK_POJO).memberName("Export")
            .getter(getter(GetExportResponse::export)).setter(setter(Builder::export)).constructor(Export::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Export").build()).build();

    private static final SdkField<ExportStatus> EXPORT_STATUS_FIELD = SdkField.<ExportStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ExportStatus").getter(getter(GetExportResponse::exportStatus)).setter(setter(Builder::exportStatus))
            .constructor(ExportStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD,
            EXPORT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Export", EXPORT_FIELD);
                    put("ExportStatus", EXPORT_STATUS_FIELD);
                }
            });

    private final Export export;

    private final ExportStatus exportStatus;

    private GetExportResponse(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.exportStatus = builder.exportStatus;
    }

    /**
     * <p>
     * The data for this specific export.
     * </p>
     * 
     * @return The data for this specific export.
     */
    public final Export export() {
        return export;
    }

    /**
     * <p>
     * The status of this specific export.
     * </p>
     * 
     * @return The status of this specific export.
     */
    public final ExportStatus exportStatus() {
        return exportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(export());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportResponse)) {
            return false;
        }
        GetExportResponse other = (GetExportResponse) obj;
        return Objects.equals(export(), other.export()) && Objects.equals(exportStatus(), other.exportStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportResponse").add("Export", export()).add("ExportStatus", exportStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Export":
            return Optional.ofNullable(clazz.cast(export()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExportResponse, T> g) {
        return obj -> g.apply((GetExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmDataExportsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExportResponse> {
        /**
         * <p>
         * The data for this specific export.
         * </p>
         * 
         * @param export
         *        The data for this specific export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder export(Export export);

        /**
         * <p>
         * The data for this specific export.
         * </p>
         * This is a convenience method that creates an instance of the {@link Export.Builder} avoiding the need to
         * create one manually via {@link Export#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Export.Builder#build()} is called immediately and its result is
         * passed to {@link #export(Export)}.
         * 
         * @param export
         *        a consumer that will call methods on {@link Export.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #export(Export)
         */
        default Builder export(Consumer<Export.Builder> export) {
            return export(Export.builder().applyMutation(export).build());
        }

        /**
         * <p>
         * The status of this specific export.
         * </p>
         * 
         * @param exportStatus
         *        The status of this specific export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * The status of this specific export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportStatus.Builder} avoiding the need
         * to create one manually via {@link ExportStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #exportStatus(ExportStatus)}.
         * 
         * @param exportStatus
         *        a consumer that will call methods on {@link ExportStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportStatus(ExportStatus)
         */
        default Builder exportStatus(Consumer<ExportStatus.Builder> exportStatus) {
            return exportStatus(ExportStatus.builder().applyMutation(exportStatus).build());
        }
    }

    static final class BuilderImpl extends BcmDataExportsResponse.BuilderImpl implements Builder {
        private Export export;

        private ExportStatus exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportResponse model) {
            super(model);
            export(model.export);
            exportStatus(model.exportStatus);
        }

        public final Export.Builder getExport() {
            return export != null ? export.toBuilder() : null;
        }

        public final void setExport(Export.BuilderImpl export) {
            this.export = export != null ? export.build() : null;
        }

        @Override
        public final Builder export(Export export) {
            this.export = export;
            return this;
        }

        public final ExportStatus.Builder getExportStatus() {
            return exportStatus != null ? exportStatus.toBuilder() : null;
        }

        public final void setExportStatus(ExportStatus.BuilderImpl exportStatus) {
            this.exportStatus = exportStatus != null ? exportStatus.build() : null;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public GetExportResponse build() {
            return new GetExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
