/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The compression type, file format, and overwrite preference for the data export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OutputConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<S3OutputConfigurations.Builder, S3OutputConfigurations> {
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compression").getter(getter(S3OutputConfigurations::compressionAsString))
            .setter(setter(Builder::compression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(S3OutputConfigurations::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(S3OutputConfigurations::outputTypeAsString))
            .setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()).build();

    private static final SdkField<String> OVERWRITE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Overwrite").getter(getter(S3OutputConfigurations::overwriteAsString)).setter(setter(Builder::overwrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overwrite").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPRESSION_FIELD,
            FORMAT_FIELD, OUTPUT_TYPE_FIELD, OVERWRITE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Compression", COMPRESSION_FIELD);
                    put("Format", FORMAT_FIELD);
                    put("OutputType", OUTPUT_TYPE_FIELD);
                    put("Overwrite", OVERWRITE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String compression;

    private final String format;

    private final String outputType;

    private final String overwrite;

    private S3OutputConfigurations(BuilderImpl builder) {
        this.compression = builder.compression;
        this.format = builder.format;
        this.outputType = builder.outputType;
        this.overwrite = builder.overwrite;
    }

    /**
     * <p>
     * The compression type for the data export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link CompressionOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return The compression type for the data export.
     * @see CompressionOption
     */
    public final CompressionOption compression() {
        return CompressionOption.fromValue(compression);
    }

    /**
     * <p>
     * The compression type for the data export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compression} will
     * return {@link CompressionOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compressionAsString}.
     * </p>
     * 
     * @return The compression type for the data export.
     * @see CompressionOption
     */
    public final String compressionAsString() {
        return compression;
    }

    /**
     * <p>
     * The file format for the data export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link FormatOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The file format for the data export.
     * @see FormatOption
     */
    public final FormatOption format() {
        return FormatOption.fromValue(format);
    }

    /**
     * <p>
     * The file format for the data export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link FormatOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The file format for the data export.
     * @see FormatOption
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The output type for the data export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link S3OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The output type for the data export.
     * @see S3OutputType
     */
    public final S3OutputType outputType() {
        return S3OutputType.fromValue(outputType);
    }

    /**
     * <p>
     * The output type for the data export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link S3OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The output type for the data export.
     * @see S3OutputType
     */
    public final String outputTypeAsString() {
        return outputType;
    }

    /**
     * <p>
     * The rule to follow when generating a version of the data export file. You have the choice to overwrite the
     * previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon
     * S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overwrite} will
     * return {@link OverwriteOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #overwriteAsString}.
     * </p>
     * 
     * @return The rule to follow when generating a version of the data export file. You have the choice to overwrite
     *         the previous version or to be delivered in addition to the previous versions. Overwriting exports can
     *         save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and
     *         usage data over time.
     * @see OverwriteOption
     */
    public final OverwriteOption overwrite() {
        return OverwriteOption.fromValue(overwrite);
    }

    /**
     * <p>
     * The rule to follow when generating a version of the data export file. You have the choice to overwrite the
     * previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon
     * S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overwrite} will
     * return {@link OverwriteOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #overwriteAsString}.
     * </p>
     * 
     * @return The rule to follow when generating a version of the data export file. You have the choice to overwrite
     *         the previous version or to be delivered in addition to the previous versions. Overwriting exports can
     *         save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and
     *         usage data over time.
     * @see OverwriteOption
     */
    public final String overwriteAsString() {
        return overwrite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputConfigurations)) {
            return false;
        }
        S3OutputConfigurations other = (S3OutputConfigurations) obj;
        return Objects.equals(compressionAsString(), other.compressionAsString())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(outputTypeAsString(), other.outputTypeAsString())
                && Objects.equals(overwriteAsString(), other.overwriteAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3OutputConfigurations").add("Compression", compressionAsString())
                .add("Format", formatAsString()).add("OutputType", outputTypeAsString()).add("Overwrite", overwriteAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Compression":
            return Optional.ofNullable(clazz.cast(compressionAsString()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputTypeAsString()));
        case "Overwrite":
            return Optional.ofNullable(clazz.cast(overwriteAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3OutputConfigurations, T> g) {
        return obj -> g.apply((S3OutputConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3OutputConfigurations> {
        /**
         * <p>
         * The compression type for the data export.
         * </p>
         * 
         * @param compression
         *        The compression type for the data export.
         * @see CompressionOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionOption
         */
        Builder compression(String compression);

        /**
         * <p>
         * The compression type for the data export.
         * </p>
         * 
         * @param compression
         *        The compression type for the data export.
         * @see CompressionOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionOption
         */
        Builder compression(CompressionOption compression);

        /**
         * <p>
         * The file format for the data export.
         * </p>
         * 
         * @param format
         *        The file format for the data export.
         * @see FormatOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormatOption
         */
        Builder format(String format);

        /**
         * <p>
         * The file format for the data export.
         * </p>
         * 
         * @param format
         *        The file format for the data export.
         * @see FormatOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormatOption
         */
        Builder format(FormatOption format);

        /**
         * <p>
         * The output type for the data export.
         * </p>
         * 
         * @param outputType
         *        The output type for the data export.
         * @see S3OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3OutputType
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * The output type for the data export.
         * </p>
         * 
         * @param outputType
         *        The output type for the data export.
         * @see S3OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3OutputType
         */
        Builder outputType(S3OutputType outputType);

        /**
         * <p>
         * The rule to follow when generating a version of the data export file. You have the choice to overwrite the
         * previous version or to be delivered in addition to the previous versions. Overwriting exports can save on
         * Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data
         * over time.
         * </p>
         * 
         * @param overwrite
         *        The rule to follow when generating a version of the data export file. You have the choice to overwrite
         *        the previous version or to be delivered in addition to the previous versions. Overwriting exports can
         *        save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost
         *        and usage data over time.
         * @see OverwriteOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverwriteOption
         */
        Builder overwrite(String overwrite);

        /**
         * <p>
         * The rule to follow when generating a version of the data export file. You have the choice to overwrite the
         * previous version or to be delivered in addition to the previous versions. Overwriting exports can save on
         * Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data
         * over time.
         * </p>
         * 
         * @param overwrite
         *        The rule to follow when generating a version of the data export file. You have the choice to overwrite
         *        the previous version or to be delivered in addition to the previous versions. Overwriting exports can
         *        save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost
         *        and usage data over time.
         * @see OverwriteOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverwriteOption
         */
        Builder overwrite(OverwriteOption overwrite);
    }

    static final class BuilderImpl implements Builder {
        private String compression;

        private String format;

        private String outputType;

        private String overwrite;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputConfigurations model) {
            compression(model.compression);
            format(model.format);
            outputType(model.outputType);
            overwrite(model.overwrite);
        }

        public final String getCompression() {
            return compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionOption compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(FormatOption format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(S3OutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final String getOverwrite() {
            return overwrite;
        }

        public final void setOverwrite(String overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public final Builder overwrite(String overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        @Override
        public final Builder overwrite(OverwriteOption overwrite) {
            this.overwrite(overwrite == null ? null : overwrite.toString());
            return this;
        }

        @Override
        public S3OutputConfigurations build() {
            return new S3OutputConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
