/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the data export table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Table implements SdkPojo, Serializable, ToCopyableBuilder<Table.Builder, Table> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Table::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(Table::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<TablePropertyDescription>> TABLE_PROPERTIES_FIELD = SdkField
            .<List<TablePropertyDescription>> builder(MarshallingType.LIST)
            .memberName("TableProperties")
            .getter(getter(Table::tableProperties))
            .setter(setter(Builder::tableProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TablePropertyDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(TablePropertyDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            TABLE_NAME_FIELD, TABLE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Description", DESCRIPTION_FIELD);
                    put("TableName", TABLE_NAME_FIELD);
                    put("TableProperties", TABLE_PROPERTIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String tableName;

    private final List<TablePropertyDescription> tableProperties;

    private Table(BuilderImpl builder) {
        this.description = builder.description;
        this.tableName = builder.tableName;
        this.tableProperties = builder.tableProperties;
    }

    /**
     * <p>
     * The description for the table.
     * </p>
     * 
     * @return The description for the table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableProperties() {
        return tableProperties != null && !(tableProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties for the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableProperties} method.
     * </p>
     * 
     * @return The properties for the table.
     */
    public final List<TablePropertyDescription> tableProperties() {
        return tableProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTableProperties() ? tableProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(tableName(), other.tableName())
                && hasTableProperties() == other.hasTableProperties()
                && Objects.equals(tableProperties(), other.tableProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Table").add("Description", description()).add("TableName", tableName())
                .add("TableProperties", hasTableProperties() ? tableProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableProperties":
            return Optional.ofNullable(clazz.cast(tableProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Table, T> g) {
        return obj -> g.apply((Table) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Table> {
        /**
         * <p>
         * The description for the table.
         * </p>
         * 
         * @param description
         *        The description for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The properties for the table.
         * </p>
         * 
         * @param tableProperties
         *        The properties for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableProperties(Collection<TablePropertyDescription> tableProperties);

        /**
         * <p>
         * The properties for the table.
         * </p>
         * 
         * @param tableProperties
         *        The properties for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableProperties(TablePropertyDescription... tableProperties);

        /**
         * <p>
         * The properties for the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmdataexports.model.TablePropertyDescription.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bcmdataexports.model.TablePropertyDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmdataexports.model.TablePropertyDescription.Builder#build()} is
         * called immediately and its result is passed to {@link #tableProperties(List<TablePropertyDescription>)}.
         * 
         * @param tableProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmdataexports.model.TablePropertyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableProperties(java.util.Collection<TablePropertyDescription>)
         */
        Builder tableProperties(Consumer<TablePropertyDescription.Builder>... tableProperties);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String tableName;

        private List<TablePropertyDescription> tableProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            description(model.description);
            tableName(model.tableName);
            tableProperties(model.tableProperties);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<TablePropertyDescription.Builder> getTableProperties() {
            List<TablePropertyDescription.Builder> result = TablePropertyDescriptionListCopier
                    .copyToBuilder(this.tableProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableProperties(Collection<TablePropertyDescription.BuilderImpl> tableProperties) {
            this.tableProperties = TablePropertyDescriptionListCopier.copyFromBuilder(tableProperties);
        }

        @Override
        public final Builder tableProperties(Collection<TablePropertyDescription> tableProperties) {
            this.tableProperties = TablePropertyDescriptionListCopier.copy(tableProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableProperties(TablePropertyDescription... tableProperties) {
            tableProperties(Arrays.asList(tableProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableProperties(Consumer<TablePropertyDescription.Builder>... tableProperties) {
            tableProperties(Stream.of(tableProperties).map(c -> TablePropertyDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Table build() {
            return new Table(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
