/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and object keys of a data exports
 * file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Destination implements SdkPojo, Serializable, ToCopyableBuilder<S3Destination.Builder, S3Destination> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(S3Destination::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<S3OutputConfigurations> S3_OUTPUT_CONFIGURATIONS_FIELD = SdkField
            .<S3OutputConfigurations> builder(MarshallingType.SDK_POJO).memberName("S3OutputConfigurations")
            .getter(getter(S3Destination::s3OutputConfigurations)).setter(setter(Builder::s3OutputConfigurations))
            .constructor(S3OutputConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputConfigurations").build())
            .build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(S3Destination::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Region").getter(getter(S3Destination::s3Region)).setter(setter(Builder::s3Region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD,
            S3_OUTPUT_CONFIGURATIONS_FIELD, S3_PREFIX_FIELD, S3_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Bucket;

    private final S3OutputConfigurations s3OutputConfigurations;

    private final String s3Prefix;

    private final String s3Region;

    private S3Destination(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3OutputConfigurations = builder.s3OutputConfigurations;
        this.s3Prefix = builder.s3Prefix;
        this.s3Region = builder.s3Region;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket used as the destination of a data export file.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket used as the destination of a data export file.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The output configuration for the data export.
     * </p>
     * 
     * @return The output configuration for the data export.
     */
    public final S3OutputConfigurations s3OutputConfigurations() {
        return s3OutputConfigurations;
    }

    /**
     * <p>
     * The S3 path prefix you want prepended to the name of your data export.
     * </p>
     * 
     * @return The S3 path prefix you want prepended to the name of your data export.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * The S3 bucket Region.
     * </p>
     * 
     * @return The S3 bucket Region.
     */
    public final String s3Region() {
        return s3Region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3Region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3OutputConfigurations(), other.s3OutputConfigurations())
                && Objects.equals(s3Prefix(), other.s3Prefix()) && Objects.equals(s3Region(), other.s3Region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Destination").add("S3Bucket", s3Bucket())
                .add("S3OutputConfigurations", s3OutputConfigurations()).add("S3Prefix", s3Prefix()).add("S3Region", s3Region())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3OutputConfigurations":
            return Optional.ofNullable(clazz.cast(s3OutputConfigurations()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3Region":
            return Optional.ofNullable(clazz.cast(s3Region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3OutputConfigurations", S3_OUTPUT_CONFIGURATIONS_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3Region", S3_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Destination> {
        /**
         * <p>
         * The name of the Amazon S3 bucket used as the destination of a data export file.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the Amazon S3 bucket used as the destination of a data export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The output configuration for the data export.
         * </p>
         * 
         * @param s3OutputConfigurations
         *        The output configuration for the data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputConfigurations(S3OutputConfigurations s3OutputConfigurations);

        /**
         * <p>
         * The output configuration for the data export.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3OutputConfigurations.Builder} avoiding
         * the need to create one manually via {@link S3OutputConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3OutputConfigurations.Builder#build()} is called immediately and
         * its result is passed to {@link #s3OutputConfigurations(S3OutputConfigurations)}.
         * 
         * @param s3OutputConfigurations
         *        a consumer that will call methods on {@link S3OutputConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OutputConfigurations(S3OutputConfigurations)
         */
        default Builder s3OutputConfigurations(Consumer<S3OutputConfigurations.Builder> s3OutputConfigurations) {
            return s3OutputConfigurations(S3OutputConfigurations.builder().applyMutation(s3OutputConfigurations).build());
        }

        /**
         * <p>
         * The S3 path prefix you want prepended to the name of your data export.
         * </p>
         * 
         * @param s3Prefix
         *        The S3 path prefix you want prepended to the name of your data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The S3 bucket Region.
         * </p>
         * 
         * @param s3Region
         *        The S3 bucket Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Region(String s3Region);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private S3OutputConfigurations s3OutputConfigurations;

        private String s3Prefix;

        private String s3Region;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            s3Bucket(model.s3Bucket);
            s3OutputConfigurations(model.s3OutputConfigurations);
            s3Prefix(model.s3Prefix);
            s3Region(model.s3Region);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final S3OutputConfigurations.Builder getS3OutputConfigurations() {
            return s3OutputConfigurations != null ? s3OutputConfigurations.toBuilder() : null;
        }

        public final void setS3OutputConfigurations(S3OutputConfigurations.BuilderImpl s3OutputConfigurations) {
            this.s3OutputConfigurations = s3OutputConfigurations != null ? s3OutputConfigurations.build() : null;
        }

        @Override
        public final Builder s3OutputConfigurations(S3OutputConfigurations s3OutputConfigurations) {
            this.s3OutputConfigurations = s3OutputConfigurations;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3Region() {
            return s3Region;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        @Override
        public S3Destination build() {
            return new S3Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
