/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExecutionResponse extends BcmDataExportsResponse implements
        ToCopyableBuilder<GetExecutionResponse.Builder, GetExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(GetExecutionResponse::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField
            .<ExecutionStatus> builder(MarshallingType.SDK_POJO).memberName("ExecutionStatus")
            .getter(getter(GetExecutionResponse::executionStatus)).setter(setter(Builder::executionStatus))
            .constructor(ExecutionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()).build();

    private static final SdkField<Export> EXPORT_FIELD = SdkField.<Export> builder(MarshallingType.SDK_POJO).memberName("Export")
            .getter(getter(GetExecutionResponse::export)).setter(setter(Builder::export)).constructor(Export::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Export").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            EXECUTION_STATUS_FIELD, EXPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionId;

    private final ExecutionStatus executionStatus;

    private final Export export;

    private GetExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.executionStatus = builder.executionStatus;
        this.export = builder.export;
    }

    /**
     * <p>
     * The ID for this specific execution.
     * </p>
     * 
     * @return The ID for this specific execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The status of this specific execution.
     * </p>
     * 
     * @return The status of this specific execution.
     */
    public final ExecutionStatus executionStatus() {
        return executionStatus;
    }

    /**
     * <p>
     * The export data for this specific execution. This export data is a snapshot from when the execution was
     * generated. The data could be different from the current export data if the export was updated since the execution
     * was generated.
     * </p>
     * 
     * @return The export data for this specific execution. This export data is a snapshot from when the execution was
     *         generated. The data could be different from the current export data if the export was updated since the
     *         execution was generated.
     */
    public final Export export() {
        return export;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(export());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionResponse)) {
            return false;
        }
        GetExecutionResponse other = (GetExecutionResponse) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(executionStatus(), other.executionStatus())
                && Objects.equals(export(), other.export());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExecutionResponse").add("ExecutionId", executionId())
                .add("ExecutionStatus", executionStatus()).add("Export", export()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "ExecutionStatus":
            return Optional.ofNullable(clazz.cast(executionStatus()));
        case "Export":
            return Optional.ofNullable(clazz.cast(export()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionId", EXECUTION_ID_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("Export", EXPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionResponse, T> g) {
        return obj -> g.apply((GetExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmDataExportsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExecutionResponse> {
        /**
         * <p>
         * The ID for this specific execution.
         * </p>
         * 
         * @param executionId
         *        The ID for this specific execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The status of this specific execution.
         * </p>
         * 
         * @param executionStatus
         *        The status of this specific execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The status of this specific execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStatus.Builder} avoiding the
         * need to create one manually via {@link ExecutionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #executionStatus(ExecutionStatus)}.
         * 
         * @param executionStatus
         *        a consumer that will call methods on {@link ExecutionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStatus(ExecutionStatus)
         */
        default Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return executionStatus(ExecutionStatus.builder().applyMutation(executionStatus).build());
        }

        /**
         * <p>
         * The export data for this specific execution. This export data is a snapshot from when the execution was
         * generated. The data could be different from the current export data if the export was updated since the
         * execution was generated.
         * </p>
         * 
         * @param export
         *        The export data for this specific execution. This export data is a snapshot from when the execution
         *        was generated. The data could be different from the current export data if the export was updated
         *        since the execution was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder export(Export export);

        /**
         * <p>
         * The export data for this specific execution. This export data is a snapshot from when the execution was
         * generated. The data could be different from the current export data if the export was updated since the
         * execution was generated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Export.Builder} avoiding the need to
         * create one manually via {@link Export#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Export.Builder#build()} is called immediately and its result is
         * passed to {@link #export(Export)}.
         * 
         * @param export
         *        a consumer that will call methods on {@link Export.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #export(Export)
         */
        default Builder export(Consumer<Export.Builder> export) {
            return export(Export.builder().applyMutation(export).build());
        }
    }

    static final class BuilderImpl extends BcmDataExportsResponse.BuilderImpl implements Builder {
        private String executionId;

        private ExecutionStatus executionStatus;

        private Export export;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionResponse model) {
            super(model);
            executionId(model.executionId);
            executionStatus(model.executionStatus);
            export(model.export);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return executionStatus != null ? executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public final Export.Builder getExport() {
            return export != null ? export.toBuilder() : null;
        }

        public final void setExport(Export.BuilderImpl export) {
            this.export = export != null ? export.build() : null;
        }

        @Override
        public final Builder export(Export export) {
            this.export = export;
            return this;
        }

        @Override
        public GetExecutionResponse build() {
            return new GetExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
