/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ExecutionStatus;
import software.amazon.awssdk.services.bcmdataexports.model.Export;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExecutionResponse
extends BcmDataExportsResponse
implements ToCopyableBuilder<Builder, GetExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(GetExecutionResponse.getter(GetExecutionResponse::executionId)).setter(GetExecutionResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionStatus").getter(GetExecutionResponse.getter(GetExecutionResponse::executionStatus)).setter(GetExecutionResponse.setter(Builder::executionStatus)).constructor(ExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()}).build();
    private static final SdkField<Export> EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Export").getter(GetExecutionResponse.getter(GetExecutionResponse::export)).setter(GetExecutionResponse.setter(Builder::export)).constructor(Export::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Export").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, EXECUTION_STATUS_FIELD, EXPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetExecutionResponse.memberNameToFieldInitializer();
    private final String executionId;
    private final ExecutionStatus executionStatus;
    private final Export export;

    private GetExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.executionStatus = builder.executionStatus;
        this.export = builder.export;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final ExecutionStatus executionStatus() {
        return this.executionStatus;
    }

    public final Export export() {
        return this.export;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.export());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionResponse)) {
            return false;
        }
        GetExecutionResponse other = (GetExecutionResponse)((Object)obj);
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.executionStatus(), other.executionStatus()) && Objects.equals(this.export(), other.export());
    }

    public final String toString() {
        return ToString.builder((String)"GetExecutionResponse").add("ExecutionId", (Object)this.executionId()).add("ExecutionStatus", (Object)this.executionStatus()).add("Export", (Object)this.export()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "ExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatus()));
            }
            case "Export": {
                return Optional.ofNullable(clazz.cast(this.export()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionId", EXECUTION_ID_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("Export", EXPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionResponse, T> g) {
        return obj -> g.apply((GetExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsResponse.BuilderImpl
    implements Builder {
        private String executionId;
        private ExecutionStatus executionStatus;
        private Export export;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionResponse model) {
            super(model);
            this.executionId(model.executionId);
            this.executionStatus(model.executionStatus);
            this.export(model.export);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return this.executionStatus != null ? this.executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public final Export.Builder getExport() {
            return this.export != null ? this.export.toBuilder() : null;
        }

        public final void setExport(Export.BuilderImpl export) {
            this.export = export != null ? export.build() : null;
        }

        @Override
        public final Builder export(Export export) {
            this.export = export;
            return this;
        }

        @Override
        public GetExecutionResponse build() {
            return new GetExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmDataExportsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExecutionResponse> {
        public Builder executionId(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        default public Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return this.executionStatus((ExecutionStatus)((ExecutionStatus.Builder)ExecutionStatus.builder().applyMutation(executionStatus)).build());
        }

        public Builder export(Export var1);

        default public Builder export(Consumer<Export.Builder> export) {
            return this.export((Export)((Export.Builder)Export.builder().applyMutation(export)).build());
        }
    }
}

