/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that are available for an export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Export implements SdkPojo, Serializable, ToCopyableBuilder<Export.Builder, Export> {
    private static final SdkField<DataQuery> DATA_QUERY_FIELD = SdkField.<DataQuery> builder(MarshallingType.SDK_POJO)
            .memberName("DataQuery").getter(getter(Export::dataQuery)).setter(setter(Builder::dataQuery))
            .constructor(DataQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQuery").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Export::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DestinationConfigurations> DESTINATION_CONFIGURATIONS_FIELD = SdkField
            .<DestinationConfigurations> builder(MarshallingType.SDK_POJO).memberName("DestinationConfigurations")
            .getter(getter(Export::destinationConfigurations)).setter(setter(Builder::destinationConfigurations))
            .constructor(DestinationConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfigurations").build())
            .build();

    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportArn").getter(getter(Export::exportArn)).setter(setter(Builder::exportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Export::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RefreshCadence> REFRESH_CADENCE_FIELD = SdkField
            .<RefreshCadence> builder(MarshallingType.SDK_POJO).memberName("RefreshCadence")
            .getter(getter(Export::refreshCadence)).setter(setter(Builder::refreshCadence)).constructor(RefreshCadence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshCadence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_QUERY_FIELD,
            DESCRIPTION_FIELD, DESTINATION_CONFIGURATIONS_FIELD, EXPORT_ARN_FIELD, NAME_FIELD, REFRESH_CADENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataQuery dataQuery;

    private final String description;

    private final DestinationConfigurations destinationConfigurations;

    private final String exportArn;

    private final String name;

    private final RefreshCadence refreshCadence;

    private Export(BuilderImpl builder) {
        this.dataQuery = builder.dataQuery;
        this.description = builder.description;
        this.destinationConfigurations = builder.destinationConfigurations;
        this.exportArn = builder.exportArn;
        this.name = builder.name;
        this.refreshCadence = builder.refreshCadence;
    }

    /**
     * <p>
     * The data query for this specific data export.
     * </p>
     * 
     * @return The data query for this specific data export.
     */
    public final DataQuery dataQuery() {
        return dataQuery;
    }

    /**
     * <p>
     * The description for this specific data export.
     * </p>
     * 
     * @return The description for this specific data export.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The destination configuration for this specific data export.
     * </p>
     * 
     * @return The destination configuration for this specific data export.
     */
    public final DestinationConfigurations destinationConfigurations() {
        return destinationConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for this export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for this export.
     */
    public final String exportArn() {
        return exportArn;
    }

    /**
     * <p>
     * The name of this specific data export.
     * </p>
     * 
     * @return The name of this specific data export.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The cadence for Amazon Web Services to update the export in your S3 bucket.
     * </p>
     * 
     * @return The cadence for Amazon Web Services to update the export in your S3 bucket.
     */
    public final RefreshCadence refreshCadence() {
        return refreshCadence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataQuery());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(refreshCadence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export) obj;
        return Objects.equals(dataQuery(), other.dataQuery()) && Objects.equals(description(), other.description())
                && Objects.equals(destinationConfigurations(), other.destinationConfigurations())
                && Objects.equals(exportArn(), other.exportArn()) && Objects.equals(name(), other.name())
                && Objects.equals(refreshCadence(), other.refreshCadence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Export").add("DataQuery", dataQuery()).add("Description", description())
                .add("DestinationConfigurations", destinationConfigurations()).add("ExportArn", exportArn()).add("Name", name())
                .add("RefreshCadence", refreshCadence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataQuery":
            return Optional.ofNullable(clazz.cast(dataQuery()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DestinationConfigurations":
            return Optional.ofNullable(clazz.cast(destinationConfigurations()));
        case "ExportArn":
            return Optional.ofNullable(clazz.cast(exportArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RefreshCadence":
            return Optional.ofNullable(clazz.cast(refreshCadence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataQuery", DATA_QUERY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DestinationConfigurations", DESTINATION_CONFIGURATIONS_FIELD);
        map.put("ExportArn", EXPORT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RefreshCadence", REFRESH_CADENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Export, T> g) {
        return obj -> g.apply((Export) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Export> {
        /**
         * <p>
         * The data query for this specific data export.
         * </p>
         * 
         * @param dataQuery
         *        The data query for this specific data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQuery(DataQuery dataQuery);

        /**
         * <p>
         * The data query for this specific data export.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQuery.Builder} avoiding the need to
         * create one manually via {@link DataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #dataQuery(DataQuery)}.
         * 
         * @param dataQuery
         *        a consumer that will call methods on {@link DataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQuery(DataQuery)
         */
        default Builder dataQuery(Consumer<DataQuery.Builder> dataQuery) {
            return dataQuery(DataQuery.builder().applyMutation(dataQuery).build());
        }

        /**
         * <p>
         * The description for this specific data export.
         * </p>
         * 
         * @param description
         *        The description for this specific data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The destination configuration for this specific data export.
         * </p>
         * 
         * @param destinationConfigurations
         *        The destination configuration for this specific data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(DestinationConfigurations destinationConfigurations);

        /**
         * <p>
         * The destination configuration for this specific data export.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfigurations.Builder}
         * avoiding the need to create one manually via {@link DestinationConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfigurations(DestinationConfigurations)}.
         * 
         * @param destinationConfigurations
         *        a consumer that will call methods on {@link DestinationConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfigurations(DestinationConfigurations)
         */
        default Builder destinationConfigurations(Consumer<DestinationConfigurations.Builder> destinationConfigurations) {
            return destinationConfigurations(DestinationConfigurations.builder().applyMutation(destinationConfigurations).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for this export.
         * </p>
         * 
         * @param exportArn
         *        The Amazon Resource Name (ARN) for this export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportArn(String exportArn);

        /**
         * <p>
         * The name of this specific data export.
         * </p>
         * 
         * @param name
         *        The name of this specific data export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The cadence for Amazon Web Services to update the export in your S3 bucket.
         * </p>
         * 
         * @param refreshCadence
         *        The cadence for Amazon Web Services to update the export in your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshCadence(RefreshCadence refreshCadence);

        /**
         * <p>
         * The cadence for Amazon Web Services to update the export in your S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshCadence.Builder} avoiding the need
         * to create one manually via {@link RefreshCadence#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshCadence.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshCadence(RefreshCadence)}.
         * 
         * @param refreshCadence
         *        a consumer that will call methods on {@link RefreshCadence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshCadence(RefreshCadence)
         */
        default Builder refreshCadence(Consumer<RefreshCadence.Builder> refreshCadence) {
            return refreshCadence(RefreshCadence.builder().applyMutation(refreshCadence).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataQuery dataQuery;

        private String description;

        private DestinationConfigurations destinationConfigurations;

        private String exportArn;

        private String name;

        private RefreshCadence refreshCadence;

        private BuilderImpl() {
        }

        private BuilderImpl(Export model) {
            dataQuery(model.dataQuery);
            description(model.description);
            destinationConfigurations(model.destinationConfigurations);
            exportArn(model.exportArn);
            name(model.name);
            refreshCadence(model.refreshCadence);
        }

        public final DataQuery.Builder getDataQuery() {
            return dataQuery != null ? dataQuery.toBuilder() : null;
        }

        public final void setDataQuery(DataQuery.BuilderImpl dataQuery) {
            this.dataQuery = dataQuery != null ? dataQuery.build() : null;
        }

        @Override
        public final Builder dataQuery(DataQuery dataQuery) {
            this.dataQuery = dataQuery;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DestinationConfigurations.Builder getDestinationConfigurations() {
            return destinationConfigurations != null ? destinationConfigurations.toBuilder() : null;
        }

        public final void setDestinationConfigurations(DestinationConfigurations.BuilderImpl destinationConfigurations) {
            this.destinationConfigurations = destinationConfigurations != null ? destinationConfigurations.build() : null;
        }

        @Override
        public final Builder destinationConfigurations(DestinationConfigurations destinationConfigurations) {
            this.destinationConfigurations = destinationConfigurations;
            return this;
        }

        public final String getExportArn() {
            return exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RefreshCadence.Builder getRefreshCadence() {
            return refreshCadence != null ? refreshCadence.toBuilder() : null;
        }

        public final void setRefreshCadence(RefreshCadence.BuilderImpl refreshCadence) {
            this.refreshCadence = refreshCadence != null ? refreshCadence.build() : null;
        }

        @Override
        public final Builder refreshCadence(RefreshCadence refreshCadence) {
            this.refreshCadence = refreshCadence;
            return this;
        }

        @Override
        public Export build() {
            return new Export(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
