/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the data export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportStatus implements SdkPojo, Serializable, ToCopyableBuilder<ExportStatus.Builder, ExportStatus> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ExportStatus::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_REFRESHED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRefreshedAt")
            .getter(getter(ExportStatus::lastRefreshedAt))
            .setter(setter(Builder::lastRefreshedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(ExportStatus::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(ExportStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ExportStatus::statusReasonAsString)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            LAST_REFRESHED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_CODE_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Instant lastRefreshedAt;

    private final Instant lastUpdatedAt;

    private final String statusCode;

    private final String statusReason;

    private ExportStatus(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.lastRefreshedAt = builder.lastRefreshedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.statusCode = builder.statusCode;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The timestamp of when the export was created.
     * </p>
     * 
     * @return The timestamp of when the export was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the export was last generated.
     * </p>
     * 
     * @return The timestamp of when the export was last generated.
     */
    public final Instant lastRefreshedAt() {
        return lastRefreshedAt;
    }

    /**
     * <p>
     * The timestamp of when the export was updated.
     * </p>
     * 
     * @return The timestamp of when the export was updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The status code for the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ExportStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code for the request.
     * @see ExportStatusCode
     */
    public final ExportStatusCode statusCode() {
        return ExportStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The status code for the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ExportStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code for the request.
     * @see ExportStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * The description for the status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ExecutionStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The description for the status code.
     * @see ExecutionStatusReason
     */
    public final ExecutionStatusReason statusReason() {
        return ExecutionStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * The description for the status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ExecutionStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The description for the status code.
     * @see ExecutionStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStatus)) {
            return false;
        }
        ExportStatus other = (ExportStatus) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastRefreshedAt(), other.lastRefreshedAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportStatus").add("CreatedAt", createdAt()).add("LastRefreshedAt", lastRefreshedAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("StatusCode", statusCodeAsString())
                .add("StatusReason", statusReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastRefreshedAt":
            return Optional.ofNullable(clazz.cast(lastRefreshedAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastRefreshedAt", LAST_REFRESHED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportStatus, T> g) {
        return obj -> g.apply((ExportStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportStatus> {
        /**
         * <p>
         * The timestamp of when the export was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the export was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the export was last generated.
         * </p>
         * 
         * @param lastRefreshedAt
         *        The timestamp of when the export was last generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshedAt(Instant lastRefreshedAt);

        /**
         * <p>
         * The timestamp of when the export was updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the export was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The status code for the request.
         * </p>
         * 
         * @param statusCode
         *        The status code for the request.
         * @see ExportStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The status code for the request.
         * </p>
         * 
         * @param statusCode
         *        The status code for the request.
         * @see ExportStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatusCode
         */
        Builder statusCode(ExportStatusCode statusCode);

        /**
         * <p>
         * The description for the status code.
         * </p>
         * 
         * @param statusReason
         *        The description for the status code.
         * @see ExecutionStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The description for the status code.
         * </p>
         * 
         * @param statusReason
         *        The description for the status code.
         * @see ExecutionStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatusReason
         */
        Builder statusReason(ExecutionStatusReason statusReason);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Instant lastRefreshedAt;

        private Instant lastUpdatedAt;

        private String statusCode;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStatus model) {
            createdAt(model.createdAt);
            lastRefreshedAt(model.lastRefreshedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            statusCode(model.statusCode);
            statusReason(model.statusReason);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastRefreshedAt() {
            return lastRefreshedAt;
        }

        public final void setLastRefreshedAt(Instant lastRefreshedAt) {
            this.lastRefreshedAt = lastRefreshedAt;
        }

        @Override
        public final Builder lastRefreshedAt(Instant lastRefreshedAt) {
            this.lastRefreshedAt = lastRefreshedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ExportStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ExecutionStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        @Override
        public ExportStatus build() {
            return new ExportStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
