/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosPublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsagePublisher;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesPublisher;

/**
 * Service client for accessing AWS Billing and Cost Management Pricing Calculator asynchronously. This can be created
 * using the static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * You can use the Pricing Calculator API to programmatically create estimates for your planned cloud use. You can model
 * usage and commitments such as Savings Plans and Reserved Instances, and generate estimated costs using your discounts
 * and benefit sharing preferences.
 * </p>
 * <p>
 * The Pricing Calculator API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://bcm-pricing-calculator.us-east-1.api.aws</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BcmPricingCalculatorAsyncClient extends AwsClient {
    String SERVICE_NAME = "bcm-pricing-calculator";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bcm-pricing-calculator";

    /**
     * <p>
     * Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved Instances commitments that you want to
     * model in a Bill Scenario.
     * </p>
     *
     * @param batchCreateBillScenarioCommitmentModificationRequest
     * @return A Java Future containing the result of the BatchCreateBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateBillScenarioCommitmentModificationResponse> batchCreateBillScenarioCommitmentModification(
            BatchCreateBillScenarioCommitmentModificationRequest batchCreateBillScenarioCommitmentModificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved Instances commitments that you want to
     * model in a Bill Scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchCreateBillScenarioCommitmentModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchCreateBillScenarioCommitmentModificationRequest#builder()}
     * </p>
     *
     * @param batchCreateBillScenarioCommitmentModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchCreateBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateBillScenarioCommitmentModificationResponse> batchCreateBillScenarioCommitmentModification(
            Consumer<BatchCreateBillScenarioCommitmentModificationRequest.Builder> batchCreateBillScenarioCommitmentModificationRequest) {
        return batchCreateBillScenarioCommitmentModification(BatchCreateBillScenarioCommitmentModificationRequest.builder()
                .applyMutation(batchCreateBillScenarioCommitmentModificationRequest).build());
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Bill Scenario.
     * </p>
     *
     * @param batchCreateBillScenarioUsageModificationRequest
     * @return A Java Future containing the result of the BatchCreateBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateBillScenarioUsageModificationResponse> batchCreateBillScenarioUsageModification(
            BatchCreateBillScenarioUsageModificationRequest batchCreateBillScenarioUsageModificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Bill Scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchCreateBillScenarioUsageModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchCreateBillScenarioUsageModificationRequest#builder()}
     * </p>
     *
     * @param batchCreateBillScenarioUsageModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchCreateBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateBillScenarioUsageModificationResponse> batchCreateBillScenarioUsageModification(
            Consumer<BatchCreateBillScenarioUsageModificationRequest.Builder> batchCreateBillScenarioUsageModificationRequest) {
        return batchCreateBillScenarioUsageModification(BatchCreateBillScenarioUsageModificationRequest.builder()
                .applyMutation(batchCreateBillScenarioUsageModificationRequest).build());
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Workload Estimate.
     * </p>
     *
     * @param batchCreateWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the BatchCreateWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateWorkloadEstimateUsageResponse> batchCreateWorkloadEstimateUsage(
            BatchCreateWorkloadEstimateUsageRequest batchCreateWorkloadEstimateUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Workload Estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateWorkloadEstimateUsageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCreateWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param batchCreateWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchCreateWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchCreateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateWorkloadEstimateUsageResponse> batchCreateWorkloadEstimateUsage(
            Consumer<BatchCreateWorkloadEstimateUsageRequest.Builder> batchCreateWorkloadEstimateUsageRequest) {
        return batchCreateWorkloadEstimateUsage(BatchCreateWorkloadEstimateUsageRequest.builder()
                .applyMutation(batchCreateWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Delete commitment that you have created in a Bill Scenario. You can only delete a commitment that you had added
     * and cannot model deletion (or removal) of a existing commitment. If you want model deletion of an existing
     * commitment, see the negate <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html"
     * > BillScenarioCommitmentModificationAction</a> of <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html"
     * > BatchCreateBillScenarioCommitmentModification</a> operation.
     * </p>
     *
     * @param batchDeleteBillScenarioCommitmentModificationRequest
     * @return A Java Future containing the result of the BatchDeleteBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteBillScenarioCommitmentModificationResponse> batchDeleteBillScenarioCommitmentModification(
            BatchDeleteBillScenarioCommitmentModificationRequest batchDeleteBillScenarioCommitmentModificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete commitment that you have created in a Bill Scenario. You can only delete a commitment that you had added
     * and cannot model deletion (or removal) of a existing commitment. If you want model deletion of an existing
     * commitment, see the negate <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html"
     * > BillScenarioCommitmentModificationAction</a> of <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html"
     * > BatchCreateBillScenarioCommitmentModification</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDeleteBillScenarioCommitmentModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDeleteBillScenarioCommitmentModificationRequest#builder()}
     * </p>
     *
     * @param batchDeleteBillScenarioCommitmentModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDeleteBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteBillScenarioCommitmentModificationResponse> batchDeleteBillScenarioCommitmentModification(
            Consumer<BatchDeleteBillScenarioCommitmentModificationRequest.Builder> batchDeleteBillScenarioCommitmentModificationRequest) {
        return batchDeleteBillScenarioCommitmentModification(BatchDeleteBillScenarioCommitmentModificationRequest.builder()
                .applyMutation(batchDeleteBillScenarioCommitmentModificationRequest).build());
    }

    /**
     * <p>
     * Delete usage that you have created in a Bill Scenario. You can only delete usage that you had added and cannot
     * model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html"
     * > BatchUpdateBillScenarioUsageModification</a>.
     * </p>
     *
     * @param batchDeleteBillScenarioUsageModificationRequest
     * @return A Java Future containing the result of the BatchDeleteBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteBillScenarioUsageModificationResponse> batchDeleteBillScenarioUsageModification(
            BatchDeleteBillScenarioUsageModificationRequest batchDeleteBillScenarioUsageModificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete usage that you have created in a Bill Scenario. You can only delete usage that you had added and cannot
     * model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html"
     * > BatchUpdateBillScenarioUsageModification</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDeleteBillScenarioUsageModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDeleteBillScenarioUsageModificationRequest#builder()}
     * </p>
     *
     * @param batchDeleteBillScenarioUsageModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDeleteBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteBillScenarioUsageModificationResponse> batchDeleteBillScenarioUsageModification(
            Consumer<BatchDeleteBillScenarioUsageModificationRequest.Builder> batchDeleteBillScenarioUsageModificationRequest) {
        return batchDeleteBillScenarioUsageModification(BatchDeleteBillScenarioUsageModificationRequest.builder()
                .applyMutation(batchDeleteBillScenarioUsageModificationRequest).build());
    }

    /**
     * <p>
     * Delete usage that you have created in a Workload estimate. You can only delete usage that you had added and
     * cannot model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a
     * href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html"
     * > BatchUpdateWorkloadEstimateUsage</a>.
     * </p>
     *
     * @param batchDeleteWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the BatchDeleteWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteWorkloadEstimateUsageResponse> batchDeleteWorkloadEstimateUsage(
            BatchDeleteWorkloadEstimateUsageRequest batchDeleteWorkloadEstimateUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete usage that you have created in a Workload estimate. You can only delete usage that you had added and
     * cannot model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a
     * href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html"
     * > BatchUpdateWorkloadEstimateUsage</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteWorkloadEstimateUsageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param batchDeleteWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDeleteWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchDeleteWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteWorkloadEstimateUsageResponse> batchDeleteWorkloadEstimateUsage(
            Consumer<BatchDeleteWorkloadEstimateUsageRequest.Builder> batchDeleteWorkloadEstimateUsageRequest) {
        return batchDeleteWorkloadEstimateUsage(BatchDeleteWorkloadEstimateUsageRequest.builder()
                .applyMutation(batchDeleteWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Update a newly added or existing commitment. You can update the commitment group based on a commitment ID and a
     * Bill scenario ID.
     * </p>
     *
     * @param batchUpdateBillScenarioCommitmentModificationRequest
     * @return A Java Future containing the result of the BatchUpdateBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateBillScenarioCommitmentModificationResponse> batchUpdateBillScenarioCommitmentModification(
            BatchUpdateBillScenarioCommitmentModificationRequest batchUpdateBillScenarioCommitmentModificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a newly added or existing commitment. You can update the commitment group based on a commitment ID and a
     * Bill scenario ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateBillScenarioCommitmentModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateBillScenarioCommitmentModificationRequest#builder()}
     * </p>
     *
     * @param batchUpdateBillScenarioCommitmentModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateBillScenarioCommitmentModification operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateBillScenarioCommitmentModificationResponse> batchUpdateBillScenarioCommitmentModification(
            Consumer<BatchUpdateBillScenarioCommitmentModificationRequest.Builder> batchUpdateBillScenarioCommitmentModificationRequest) {
        return batchUpdateBillScenarioCommitmentModification(BatchUpdateBillScenarioCommitmentModificationRequest.builder()
                .applyMutation(batchUpdateBillScenarioCommitmentModificationRequest).build());
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts, usage hour, and usage group based
     * on a usage ID and a Bill scenario ID.
     * </p>
     *
     * @param batchUpdateBillScenarioUsageModificationRequest
     * @return A Java Future containing the result of the BatchUpdateBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateBillScenarioUsageModificationResponse> batchUpdateBillScenarioUsageModification(
            BatchUpdateBillScenarioUsageModificationRequest batchUpdateBillScenarioUsageModificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts, usage hour, and usage group based
     * on a usage ID and a Bill scenario ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateBillScenarioUsageModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateBillScenarioUsageModificationRequest#builder()}
     * </p>
     *
     * @param batchUpdateBillScenarioUsageModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateBillScenarioUsageModification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateBillScenarioUsageModificationResponse> batchUpdateBillScenarioUsageModification(
            Consumer<BatchUpdateBillScenarioUsageModificationRequest.Builder> batchUpdateBillScenarioUsageModificationRequest) {
        return batchUpdateBillScenarioUsageModification(BatchUpdateBillScenarioUsageModificationRequest.builder()
                .applyMutation(batchUpdateBillScenarioUsageModificationRequest).build());
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts and usage group based on a usage
     * ID and a Workload estimate ID.
     * </p>
     *
     * @param batchUpdateWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the BatchUpdateWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateWorkloadEstimateUsageResponse> batchUpdateWorkloadEstimateUsage(
            BatchUpdateWorkloadEstimateUsageRequest batchUpdateWorkloadEstimateUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts and usage group based on a usage
     * ID and a Workload estimate ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateWorkloadEstimateUsageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchUpdateWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param batchUpdateWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateWorkloadEstimateUsage operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.BatchUpdateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateWorkloadEstimateUsageResponse> batchUpdateWorkloadEstimateUsage(
            Consumer<BatchUpdateWorkloadEstimateUsageRequest.Builder> batchUpdateWorkloadEstimateUsageRequest) {
        return batchUpdateWorkloadEstimateUsage(BatchUpdateWorkloadEstimateUsageRequest.builder()
                .applyMutation(batchUpdateWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Create a Bill estimate from a Bill scenario. In the Bill scenario you can model usage addition, usage changes,
     * and usage removal. You can also model commitment addition and commitment removal. After all changes in a Bill
     * scenario is made satisfactorily, you can call this API with a Bill scenario ID to generate the Bill estimate.
     * Bill estimate calculates the pre-tax cost for your consolidated billing family, incorporating all modeled usage
     * and commitments alongside existing usage and commitments from your most recent completed anniversary bill, with
     * any applicable discounts applied.
     * </p>
     *
     * @param createBillEstimateRequest
     * @return A Java Future containing the result of the CreateBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillEstimateResponse> createBillEstimate(CreateBillEstimateRequest createBillEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a Bill estimate from a Bill scenario. In the Bill scenario you can model usage addition, usage changes,
     * and usage removal. You can also model commitment addition and commitment removal. After all changes in a Bill
     * scenario is made satisfactorily, you can call this API with a Bill scenario ID to generate the Bill estimate.
     * Bill estimate calculates the pre-tax cost for your consolidated billing family, incorporating all modeled usage
     * and commitments alongside existing usage and commitments from your most recent completed anniversary bill, with
     * any applicable discounts applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillEstimateRequest#builder()}
     * </p>
     *
     * @param createBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillEstimateResponse> createBillEstimate(
            Consumer<CreateBillEstimateRequest.Builder> createBillEstimateRequest) {
        return createBillEstimate(CreateBillEstimateRequest.builder().applyMutation(createBillEstimateRequest).build());
    }

    /**
     * <p>
     * Creates a new bill scenario to model potential changes to Amazon Web Services usage and costs.
     * </p>
     *
     * @param createBillScenarioRequest
     * @return A Java Future containing the result of the CreateBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillScenarioResponse> createBillScenario(CreateBillScenarioRequest createBillScenarioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new bill scenario to model potential changes to Amazon Web Services usage and costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillScenarioRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillScenarioRequest#builder()}
     * </p>
     *
     * @param createBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillScenarioResponse> createBillScenario(
            Consumer<CreateBillScenarioRequest.Builder> createBillScenarioRequest) {
        return createBillScenario(CreateBillScenarioRequest.builder().applyMutation(createBillScenarioRequest).build());
    }

    /**
     * <p>
     * Creates a new workload estimate to model costs for a specific workload.
     * </p>
     *
     * @param createWorkloadEstimateRequest
     * @return A Java Future containing the result of the CreateWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadEstimateResponse> createWorkloadEstimate(
            CreateWorkloadEstimateRequest createWorkloadEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workload estimate to model costs for a specific workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param createWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.CreateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadEstimateResponse> createWorkloadEstimate(
            Consumer<CreateWorkloadEstimateRequest.Builder> createWorkloadEstimateRequest) {
        return createWorkloadEstimate(CreateWorkloadEstimateRequest.builder().applyMutation(createWorkloadEstimateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing bill estimate.
     * </p>
     *
     * @param deleteBillEstimateRequest
     * @return A Java Future containing the result of the DeleteBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBillEstimateResponse> deleteBillEstimate(DeleteBillEstimateRequest deleteBillEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillEstimateRequest#builder()}
     * </p>
     *
     * @param deleteBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBillEstimateResponse> deleteBillEstimate(
            Consumer<DeleteBillEstimateRequest.Builder> deleteBillEstimateRequest) {
        return deleteBillEstimate(DeleteBillEstimateRequest.builder().applyMutation(deleteBillEstimateRequest).build());
    }

    /**
     * <p>
     * Deletes an existing bill scenario.
     * </p>
     *
     * @param deleteBillScenarioRequest
     * @return A Java Future containing the result of the DeleteBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBillScenarioResponse> deleteBillScenario(DeleteBillScenarioRequest deleteBillScenarioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillScenarioRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillScenarioRequest#builder()}
     * </p>
     *
     * @param deleteBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBillScenarioResponse> deleteBillScenario(
            Consumer<DeleteBillScenarioRequest.Builder> deleteBillScenarioRequest) {
        return deleteBillScenario(DeleteBillScenarioRequest.builder().applyMutation(deleteBillScenarioRequest).build());
    }

    /**
     * <p>
     * Deletes an existing workload estimate.
     * </p>
     *
     * @param deleteWorkloadEstimateRequest
     * @return A Java Future containing the result of the DeleteWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadEstimateResponse> deleteWorkloadEstimate(
            DeleteWorkloadEstimateRequest deleteWorkloadEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.DeleteWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadEstimateResponse> deleteWorkloadEstimate(
            Consumer<DeleteWorkloadEstimateRequest.Builder> deleteWorkloadEstimateRequest) {
        return deleteWorkloadEstimate(DeleteWorkloadEstimateRequest.builder().applyMutation(deleteWorkloadEstimateRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves details of a specific bill estimate.
     * </p>
     *
     * @param getBillEstimateRequest
     * @return A Java Future containing the result of the GetBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBillEstimateResponse> getBillEstimate(GetBillEstimateRequest getBillEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillEstimateRequest.Builder} avoiding the need
     * to create one manually via {@link GetBillEstimateRequest#builder()}
     * </p>
     *
     * @param getBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBillEstimateResponse> getBillEstimate(
            Consumer<GetBillEstimateRequest.Builder> getBillEstimateRequest) {
        return getBillEstimate(GetBillEstimateRequest.builder().applyMutation(getBillEstimateRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a specific bill scenario.
     * </p>
     *
     * @param getBillScenarioRequest
     * @return A Java Future containing the result of the GetBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBillScenarioResponse> getBillScenario(GetBillScenarioRequest getBillScenarioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillScenarioRequest.Builder} avoiding the need
     * to create one manually via {@link GetBillScenarioRequest#builder()}
     * </p>
     *
     * @param getBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBillScenarioResponse> getBillScenario(
            Consumer<GetBillScenarioRequest.Builder> getBillScenarioRequest) {
        return getBillScenario(GetBillScenarioRequest.builder().applyMutation(getBillScenarioRequest).build());
    }

    /**
     * <p>
     * Retrieves the current preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     *
     * @param getPreferencesRequest
     * @return A Java Future containing the result of the GetPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPreferencesResponse> getPreferences(GetPreferencesRequest getPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPreferencesRequest.Builder} avoiding the need to
     * create one manually via {@link GetPreferencesRequest#builder()}
     * </p>
     *
     * @param getPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPreferencesResponse> getPreferences(Consumer<GetPreferencesRequest.Builder> getPreferencesRequest) {
        return getPreferences(GetPreferencesRequest.builder().applyMutation(getPreferencesRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a specific workload estimate.
     * </p>
     *
     * @param getWorkloadEstimateRequest
     * @return A Java Future containing the result of the GetWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadEstimateResponse> getWorkloadEstimate(
            GetWorkloadEstimateRequest getWorkloadEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param getWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.GetWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadEstimateResponse> getWorkloadEstimate(
            Consumer<GetWorkloadEstimateRequest.Builder> getWorkloadEstimateRequest) {
        return getWorkloadEstimate(GetWorkloadEstimateRequest.builder().applyMutation(getWorkloadEstimateRequest).build());
    }

    /**
     * <p>
     * Lists the commitments associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     * @return A Java Future containing the result of the ListBillEstimateCommitments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateCommitmentsResponse> listBillEstimateCommitments(
            ListBillEstimateCommitmentsRequest listBillEstimateCommitmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commitments associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateCommitmentsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillEstimateCommitmentsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBillEstimateCommitments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateCommitmentsResponse> listBillEstimateCommitments(
            Consumer<ListBillEstimateCommitmentsRequest.Builder> listBillEstimateCommitmentsRequest) {
        return listBillEstimateCommitments(ListBillEstimateCommitmentsRequest.builder()
                .applyMutation(listBillEstimateCommitmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsPublisher publisher = client.listBillEstimateCommitmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsPublisher publisher = client.listBillEstimateCommitmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateCommitmentsPublisher listBillEstimateCommitmentsPaginator(
            ListBillEstimateCommitmentsRequest listBillEstimateCommitmentsRequest) {
        return new ListBillEstimateCommitmentsPublisher(this, listBillEstimateCommitmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsPublisher publisher = client.listBillEstimateCommitmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsPublisher publisher = client.listBillEstimateCommitmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateCommitmentsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillEstimateCommitmentsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateCommitmentsPublisher listBillEstimateCommitmentsPaginator(
            Consumer<ListBillEstimateCommitmentsRequest.Builder> listBillEstimateCommitmentsRequest) {
        return listBillEstimateCommitmentsPaginator(ListBillEstimateCommitmentsRequest.builder()
                .applyMutation(listBillEstimateCommitmentsRequest).build());
    }

    /**
     * <p>
     * Lists the input commitment modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     * @return A Java Future containing the result of the ListBillEstimateInputCommitmentModifications operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateInputCommitmentModificationsResponse> listBillEstimateInputCommitmentModifications(
            ListBillEstimateInputCommitmentModificationsRequest listBillEstimateInputCommitmentModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the input commitment modifications associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBillEstimateInputCommitmentModifications operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateInputCommitmentModificationsResponse> listBillEstimateInputCommitmentModifications(
            Consumer<ListBillEstimateInputCommitmentModificationsRequest.Builder> listBillEstimateInputCommitmentModificationsRequest) {
        return listBillEstimateInputCommitmentModifications(ListBillEstimateInputCommitmentModificationsRequest.builder()
                .applyMutation(listBillEstimateInputCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsPublisher publisher = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsPublisher publisher = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputCommitmentModificationsPublisher listBillEstimateInputCommitmentModificationsPaginator(
            ListBillEstimateInputCommitmentModificationsRequest listBillEstimateInputCommitmentModificationsRequest) {
        return new ListBillEstimateInputCommitmentModificationsPublisher(this,
                listBillEstimateInputCommitmentModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsPublisher publisher = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsPublisher publisher = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputCommitmentModificationsPublisher listBillEstimateInputCommitmentModificationsPaginator(
            Consumer<ListBillEstimateInputCommitmentModificationsRequest.Builder> listBillEstimateInputCommitmentModificationsRequest) {
        return listBillEstimateInputCommitmentModificationsPaginator(ListBillEstimateInputCommitmentModificationsRequest
                .builder().applyMutation(listBillEstimateInputCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * Lists the input usage modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     * @return A Java Future containing the result of the ListBillEstimateInputUsageModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateInputUsageModificationsResponse> listBillEstimateInputUsageModifications(
            ListBillEstimateInputUsageModificationsRequest listBillEstimateInputUsageModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the input usage modifications associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputUsageModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBillEstimateInputUsageModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateInputUsageModificationsResponse> listBillEstimateInputUsageModifications(
            Consumer<ListBillEstimateInputUsageModificationsRequest.Builder> listBillEstimateInputUsageModificationsRequest) {
        return listBillEstimateInputUsageModifications(ListBillEstimateInputUsageModificationsRequest.builder()
                .applyMutation(listBillEstimateInputUsageModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsPublisher publisher = client.listBillEstimateInputUsageModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsPublisher publisher = client.listBillEstimateInputUsageModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputUsageModificationsPublisher listBillEstimateInputUsageModificationsPaginator(
            ListBillEstimateInputUsageModificationsRequest listBillEstimateInputUsageModificationsRequest) {
        return new ListBillEstimateInputUsageModificationsPublisher(this, listBillEstimateInputUsageModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsPublisher publisher = client.listBillEstimateInputUsageModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsPublisher publisher = client.listBillEstimateInputUsageModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputUsageModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputUsageModificationsPublisher listBillEstimateInputUsageModificationsPaginator(
            Consumer<ListBillEstimateInputUsageModificationsRequest.Builder> listBillEstimateInputUsageModificationsRequest) {
        return listBillEstimateInputUsageModificationsPaginator(ListBillEstimateInputUsageModificationsRequest.builder()
                .applyMutation(listBillEstimateInputUsageModificationsRequest).build());
    }

    /**
     * <p>
     * Lists the line items associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     * @return A Java Future containing the result of the ListBillEstimateLineItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateLineItemsResponse> listBillEstimateLineItems(
            ListBillEstimateLineItemsRequest listBillEstimateLineItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the line items associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateLineItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBillEstimateLineItemsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBillEstimateLineItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimateLineItemsResponse> listBillEstimateLineItems(
            Consumer<ListBillEstimateLineItemsRequest.Builder> listBillEstimateLineItemsRequest) {
        return listBillEstimateLineItems(ListBillEstimateLineItemsRequest.builder()
                .applyMutation(listBillEstimateLineItemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsPublisher publisher = client.listBillEstimateLineItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsPublisher publisher = client.listBillEstimateLineItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateLineItemsPublisher listBillEstimateLineItemsPaginator(
            ListBillEstimateLineItemsRequest listBillEstimateLineItemsRequest) {
        return new ListBillEstimateLineItemsPublisher(this, listBillEstimateLineItemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsPublisher publisher = client.listBillEstimateLineItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsPublisher publisher = client.listBillEstimateLineItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateLineItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBillEstimateLineItemsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateLineItemsPublisher listBillEstimateLineItemsPaginator(
            Consumer<ListBillEstimateLineItemsRequest.Builder> listBillEstimateLineItemsRequest) {
        return listBillEstimateLineItemsPaginator(ListBillEstimateLineItemsRequest.builder()
                .applyMutation(listBillEstimateLineItemsRequest).build());
    }

    /**
     * <p>
     * Lists all bill estimates for the account.
     * </p>
     *
     * @param listBillEstimatesRequest
     * @return A Java Future containing the result of the ListBillEstimates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimatesResponse> listBillEstimates(ListBillEstimatesRequest listBillEstimatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all bill estimates for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillEstimatesRequest#builder()}
     * </p>
     *
     * @param listBillEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListBillEstimates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillEstimatesResponse> listBillEstimates(
            Consumer<ListBillEstimatesRequest.Builder> listBillEstimatesRequest) {
        return listBillEstimates(ListBillEstimatesRequest.builder().applyMutation(listBillEstimatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesPublisher publisher = client.listBillEstimatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesPublisher publisher = client.listBillEstimatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimatesPublisher listBillEstimatesPaginator(ListBillEstimatesRequest listBillEstimatesRequest) {
        return new ListBillEstimatesPublisher(this, listBillEstimatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesPublisher publisher = client.listBillEstimatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesPublisher publisher = client.listBillEstimatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillEstimatesRequest#builder()}
     * </p>
     *
     * @param listBillEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimatesPublisher listBillEstimatesPaginator(
            Consumer<ListBillEstimatesRequest.Builder> listBillEstimatesRequest) {
        return listBillEstimatesPaginator(ListBillEstimatesRequest.builder().applyMutation(listBillEstimatesRequest).build());
    }

    /**
     * <p>
     * Lists the commitment modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     * @return A Java Future containing the result of the ListBillScenarioCommitmentModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillScenarioCommitmentModificationsResponse> listBillScenarioCommitmentModifications(
            ListBillScenarioCommitmentModificationsRequest listBillScenarioCommitmentModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commitment modifications associated with a bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillScenarioCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillScenarioCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBillScenarioCommitmentModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillScenarioCommitmentModificationsResponse> listBillScenarioCommitmentModifications(
            Consumer<ListBillScenarioCommitmentModificationsRequest.Builder> listBillScenarioCommitmentModificationsRequest) {
        return listBillScenarioCommitmentModifications(ListBillScenarioCommitmentModificationsRequest.builder()
                .applyMutation(listBillScenarioCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsPublisher publisher = client.listBillScenarioCommitmentModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsPublisher publisher = client.listBillScenarioCommitmentModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioCommitmentModificationsPublisher listBillScenarioCommitmentModificationsPaginator(
            ListBillScenarioCommitmentModificationsRequest listBillScenarioCommitmentModificationsRequest) {
        return new ListBillScenarioCommitmentModificationsPublisher(this, listBillScenarioCommitmentModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsPublisher publisher = client.listBillScenarioCommitmentModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsPublisher publisher = client.listBillScenarioCommitmentModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillScenarioCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillScenarioCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioCommitmentModificationsPublisher listBillScenarioCommitmentModificationsPaginator(
            Consumer<ListBillScenarioCommitmentModificationsRequest.Builder> listBillScenarioCommitmentModificationsRequest) {
        return listBillScenarioCommitmentModificationsPaginator(ListBillScenarioCommitmentModificationsRequest.builder()
                .applyMutation(listBillScenarioCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * Lists the usage modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     * @return A Java Future containing the result of the ListBillScenarioUsageModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillScenarioUsageModificationsResponse> listBillScenarioUsageModifications(
            ListBillScenarioUsageModificationsRequest listBillScenarioUsageModificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the usage modifications associated with a bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenarioUsageModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillScenarioUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBillScenarioUsageModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillScenarioUsageModificationsResponse> listBillScenarioUsageModifications(
            Consumer<ListBillScenarioUsageModificationsRequest.Builder> listBillScenarioUsageModificationsRequest) {
        return listBillScenarioUsageModifications(ListBillScenarioUsageModificationsRequest.builder()
                .applyMutation(listBillScenarioUsageModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsPublisher publisher = client.listBillScenarioUsageModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsPublisher publisher = client.listBillScenarioUsageModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioUsageModificationsPublisher listBillScenarioUsageModificationsPaginator(
            ListBillScenarioUsageModificationsRequest listBillScenarioUsageModificationsRequest) {
        return new ListBillScenarioUsageModificationsPublisher(this, listBillScenarioUsageModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsPublisher publisher = client.listBillScenarioUsageModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsPublisher publisher = client.listBillScenarioUsageModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenarioUsageModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillScenarioUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioUsageModificationsPublisher listBillScenarioUsageModificationsPaginator(
            Consumer<ListBillScenarioUsageModificationsRequest.Builder> listBillScenarioUsageModificationsRequest) {
        return listBillScenarioUsageModificationsPaginator(ListBillScenarioUsageModificationsRequest.builder()
                .applyMutation(listBillScenarioUsageModificationsRequest).build());
    }

    /**
     * <p>
     * Lists all bill scenarios for the account.
     * </p>
     *
     * @param listBillScenariosRequest
     * @return A Java Future containing the result of the ListBillScenarios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillScenariosResponse> listBillScenarios(ListBillScenariosRequest listBillScenariosRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all bill scenarios for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenariosRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillScenariosRequest#builder()}
     * </p>
     *
     * @param listBillScenariosRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListBillScenarios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillScenariosResponse> listBillScenarios(
            Consumer<ListBillScenariosRequest.Builder> listBillScenariosRequest) {
        return listBillScenarios(ListBillScenariosRequest.builder().applyMutation(listBillScenariosRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosPublisher publisher = client.listBillScenariosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosPublisher publisher = client.listBillScenariosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillScenariosRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenariosPublisher listBillScenariosPaginator(ListBillScenariosRequest listBillScenariosRequest) {
        return new ListBillScenariosPublisher(this, listBillScenariosRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosPublisher publisher = client.listBillScenariosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosPublisher publisher = client.listBillScenariosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenariosRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillScenariosRequest#builder()}
     * </p>
     *
     * @param listBillScenariosRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenariosPublisher listBillScenariosPaginator(
            Consumer<ListBillScenariosRequest.Builder> listBillScenariosRequest) {
        return listBillScenariosPaginator(ListBillScenariosRequest.builder().applyMutation(listBillScenariosRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the usage associated with a workload estimate.
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     * @return A Java Future containing the result of the ListWorkloadEstimateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadEstimateUsageResponse> listWorkloadEstimateUsage(
            ListWorkloadEstimateUsageRequest listWorkloadEstimateUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the usage associated with a workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimateUsageRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListWorkloadEstimateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadEstimateUsageResponse> listWorkloadEstimateUsage(
            Consumer<ListWorkloadEstimateUsageRequest.Builder> listWorkloadEstimateUsageRequest) {
        return listWorkloadEstimateUsage(ListWorkloadEstimateUsageRequest.builder()
                .applyMutation(listWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsagePublisher publisher = client.listWorkloadEstimateUsagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsagePublisher publisher = client.listWorkloadEstimateUsagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimateUsagePublisher listWorkloadEstimateUsagePaginator(
            ListWorkloadEstimateUsageRequest listWorkloadEstimateUsageRequest) {
        return new ListWorkloadEstimateUsagePublisher(this, listWorkloadEstimateUsageRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsagePublisher publisher = client.listWorkloadEstimateUsagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsagePublisher publisher = client.listWorkloadEstimateUsagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimateUsageRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimateUsagePublisher listWorkloadEstimateUsagePaginator(
            Consumer<ListWorkloadEstimateUsageRequest.Builder> listWorkloadEstimateUsageRequest) {
        return listWorkloadEstimateUsagePaginator(ListWorkloadEstimateUsageRequest.builder()
                .applyMutation(listWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Lists all workload estimates for the account.
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     * @return A Java Future containing the result of the ListWorkloadEstimates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadEstimatesResponse> listWorkloadEstimates(
            ListWorkloadEstimatesRequest listWorkloadEstimatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all workload estimates for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadEstimatesRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWorkloadEstimates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadEstimatesResponse> listWorkloadEstimates(
            Consumer<ListWorkloadEstimatesRequest.Builder> listWorkloadEstimatesRequest) {
        return listWorkloadEstimates(ListWorkloadEstimatesRequest.builder().applyMutation(listWorkloadEstimatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesPublisher publisher = client.listWorkloadEstimatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesPublisher publisher = client.listWorkloadEstimatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimatesPublisher listWorkloadEstimatesPaginator(
            ListWorkloadEstimatesRequest listWorkloadEstimatesRequest) {
        return new ListWorkloadEstimatesPublisher(this, listWorkloadEstimatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesPublisher publisher = client.listWorkloadEstimatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesPublisher publisher = client.listWorkloadEstimatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadEstimatesRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimatesPublisher listWorkloadEstimatesPaginator(
            Consumer<ListWorkloadEstimatesRequest.Builder> listWorkloadEstimatesRequest) {
        return listWorkloadEstimatesPaginator(ListWorkloadEstimatesRequest.builder().applyMutation(listWorkloadEstimatesRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing bill estimate.
     * </p>
     *
     * @param updateBillEstimateRequest
     * @return A Java Future containing the result of the UpdateBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBillEstimateResponse> updateBillEstimate(UpdateBillEstimateRequest updateBillEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillEstimateRequest#builder()}
     * </p>
     *
     * @param updateBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateBillEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBillEstimateResponse> updateBillEstimate(
            Consumer<UpdateBillEstimateRequest.Builder> updateBillEstimateRequest) {
        return updateBillEstimate(UpdateBillEstimateRequest.builder().applyMutation(updateBillEstimateRequest).build());
    }

    /**
     * <p>
     * Updates an existing bill scenario.
     * </p>
     *
     * @param updateBillScenarioRequest
     * @return A Java Future containing the result of the UpdateBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBillScenarioResponse> updateBillScenario(UpdateBillScenarioRequest updateBillScenarioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillScenarioRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillScenarioRequest#builder()}
     * </p>
     *
     * @param updateBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateBillScenario operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBillScenarioResponse> updateBillScenario(
            Consumer<UpdateBillScenarioRequest.Builder> updateBillScenarioRequest) {
        return updateBillScenario(UpdateBillScenarioRequest.builder().applyMutation(updateBillScenarioRequest).build());
    }

    /**
     * <p>
     * Updates the preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     *
     * @param updatePreferencesRequest
     * @return A Java Future containing the result of the UpdatePreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePreferencesResponse> updatePreferences(UpdatePreferencesRequest updatePreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePreferencesRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePreferencesRequest#builder()}
     * </p>
     *
     * @param updatePreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdatePreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>ServiceQuotaExceededException The request would cause you to exceed your service quota.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePreferencesResponse> updatePreferences(
            Consumer<UpdatePreferencesRequest.Builder> updatePreferencesRequest) {
        return updatePreferences(UpdatePreferencesRequest.builder().applyMutation(updatePreferencesRequest).build());
    }

    /**
     * <p>
     * Updates an existing workload estimate.
     * </p>
     *
     * @param updateWorkloadEstimateRequest
     * @return A Java Future containing the result of the UpdateWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadEstimateResponse> updateWorkloadEstimate(
            UpdateWorkloadEstimateRequest updateWorkloadEstimateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param updateWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateWorkloadEstimate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ValidationException The input provided fails to satisfy the constraints specified by an Amazon Web
     *         Services service.</li>
     *         <li>DataUnavailableException The requested data is currently unavailable.</li>
     *         <li>InternalServerException An internal error has occurred. Retry your request, but if the problem
     *         persists, contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BcmPricingCalculatorException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BcmPricingCalculatorAsyncClient.UpdateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadEstimateResponse> updateWorkloadEstimate(
            Consumer<UpdateWorkloadEstimateRequest.Builder> updateWorkloadEstimateRequest) {
        return updateWorkloadEstimate(UpdateWorkloadEstimateRequest.builder().applyMutation(updateWorkloadEstimateRequest)
                .build());
    }

    @Override
    default BcmPricingCalculatorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BcmPricingCalculatorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BcmPricingCalculatorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BcmPricingCalculatorAsyncClient}.
     */
    static BcmPricingCalculatorAsyncClientBuilder builder() {
        return new DefaultBcmPricingCalculatorAsyncClientBuilder();
    }
}
