/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action to add a Savings Plan to a bill scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddSavingsPlanAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AddSavingsPlanAction.Builder, AddSavingsPlanAction> {
    private static final SdkField<String> SAVINGS_PLAN_OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanOfferingId").getter(getter(AddSavingsPlanAction::savingsPlanOfferingId))
            .setter(setter(Builder::savingsPlanOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanOfferingId").build())
            .build();

    private static final SdkField<Double> COMMITMENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("commitment").getter(getter(AddSavingsPlanAction::commitment)).setter(setter(Builder::commitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_PLAN_OFFERING_ID_FIELD, COMMITMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("savingsPlanOfferingId", SAVINGS_PLAN_OFFERING_ID_FIELD);
                    put("commitment", COMMITMENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String savingsPlanOfferingId;

    private final Double commitment;

    private AddSavingsPlanAction(BuilderImpl builder) {
        this.savingsPlanOfferingId = builder.savingsPlanOfferingId;
        this.commitment = builder.commitment;
    }

    /**
     * <p>
     * The ID of the Savings Plan offering to add. For more information, see <a
     * href="https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferings.html">
     * DescribeSavingsPlansOfferings</a>.
     * </p>
     * 
     * @return The ID of the Savings Plan offering to add. For more information, see <a
     *         href="https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferings.html"
     *         > DescribeSavingsPlansOfferings</a>.
     */
    public final String savingsPlanOfferingId() {
        return savingsPlanOfferingId;
    }

    /**
     * <p>
     * The hourly commitment, in the same currency of the <code>savingsPlanOfferingId</code>. This is a value between
     * 0.001 and 1 million. You cannot specify more than five digits after the decimal point.
     * </p>
     * 
     * @return The hourly commitment, in the same currency of the <code>savingsPlanOfferingId</code>. This is a value
     *         between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.
     */
    public final Double commitment() {
        return commitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(commitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddSavingsPlanAction)) {
            return false;
        }
        AddSavingsPlanAction other = (AddSavingsPlanAction) obj;
        return Objects.equals(savingsPlanOfferingId(), other.savingsPlanOfferingId())
                && Objects.equals(commitment(), other.commitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddSavingsPlanAction").add("SavingsPlanOfferingId", savingsPlanOfferingId())
                .add("Commitment", commitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanOfferingId":
            return Optional.ofNullable(clazz.cast(savingsPlanOfferingId()));
        case "commitment":
            return Optional.ofNullable(clazz.cast(commitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddSavingsPlanAction, T> g) {
        return obj -> g.apply((AddSavingsPlanAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddSavingsPlanAction> {
        /**
         * <p>
         * The ID of the Savings Plan offering to add. For more information, see <a
         * href="https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferings.html">
         * DescribeSavingsPlansOfferings</a>.
         * </p>
         * 
         * @param savingsPlanOfferingId
         *        The ID of the Savings Plan offering to add. For more information, see <a href=
         *        "https://docs.aws.amazon.com/savingsplans/latest/APIReference/API_DescribeSavingsPlansOfferings.html">
         *        DescribeSavingsPlansOfferings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanOfferingId(String savingsPlanOfferingId);

        /**
         * <p>
         * The hourly commitment, in the same currency of the <code>savingsPlanOfferingId</code>. This is a value
         * between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.
         * </p>
         * 
         * @param commitment
         *        The hourly commitment, in the same currency of the <code>savingsPlanOfferingId</code>. This is a value
         *        between 0.001 and 1 million. You cannot specify more than five digits after the decimal point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitment(Double commitment);
    }

    static final class BuilderImpl implements Builder {
        private String savingsPlanOfferingId;

        private Double commitment;

        private BuilderImpl() {
        }

        private BuilderImpl(AddSavingsPlanAction model) {
            savingsPlanOfferingId(model.savingsPlanOfferingId);
            commitment(model.commitment);
        }

        public final String getSavingsPlanOfferingId() {
            return savingsPlanOfferingId;
        }

        public final void setSavingsPlanOfferingId(String savingsPlanOfferingId) {
            this.savingsPlanOfferingId = savingsPlanOfferingId;
        }

        @Override
        public final Builder savingsPlanOfferingId(String savingsPlanOfferingId) {
            this.savingsPlanOfferingId = savingsPlanOfferingId;
            return this;
        }

        public final Double getCommitment() {
            return commitment;
        }

        public final void setCommitment(Double commitment) {
            this.commitment = commitment;
        }

        @Override
        public final Builder commitment(Double commitment) {
            this.commitment = commitment;
            return this;
        }

        @Override
        public AddSavingsPlanAction build() {
            return new AddSavingsPlanAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
