/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateBillScenarioCommitmentModificationRequest extends BcmPricingCalculatorRequest
        implements
        ToCopyableBuilder<BatchCreateBillScenarioCommitmentModificationRequest.Builder, BatchCreateBillScenarioCommitmentModificationRequest> {
    private static final SdkField<String> BILL_SCENARIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billScenarioId").getter(getter(BatchCreateBillScenarioCommitmentModificationRequest::billScenarioId))
            .setter(setter(Builder::billScenarioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billScenarioId").build()).build();

    private static final SdkField<List<BatchCreateBillScenarioCommitmentModificationEntry>> COMMITMENT_MODIFICATIONS_FIELD = SdkField
            .<List<BatchCreateBillScenarioCommitmentModificationEntry>> builder(MarshallingType.LIST)
            .memberName("commitmentModifications")
            .getter(getter(BatchCreateBillScenarioCommitmentModificationRequest::commitmentModifications))
            .setter(setter(Builder::commitmentModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentModifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateBillScenarioCommitmentModificationEntry> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateBillScenarioCommitmentModificationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(BatchCreateBillScenarioCommitmentModificationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILL_SCENARIO_ID_FIELD,
            COMMITMENT_MODIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("billScenarioId", BILL_SCENARIO_ID_FIELD);
                    put("commitmentModifications", COMMITMENT_MODIFICATIONS_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                }
            });

    private final String billScenarioId;

    private final List<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications;

    private final String clientToken;

    private BatchCreateBillScenarioCommitmentModificationRequest(BuilderImpl builder) {
        super(builder);
        this.billScenarioId = builder.billScenarioId;
        this.commitmentModifications = builder.commitmentModifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Bill Scenario for which you want to create the modeled commitment.
     * </p>
     * 
     * @return The ID of the Bill Scenario for which you want to create the modeled commitment.
     */
    public final String billScenarioId() {
        return billScenarioId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommitmentModifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCommitmentModifications() {
        return commitmentModifications != null && !(commitmentModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of commitments that you want to model in the Bill Scenario.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommitmentModifications} method.
     * </p>
     * 
     * @return List of commitments that you want to model in the Bill Scenario.
     */
    public final List<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications() {
        return commitmentModifications;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommitmentModifications() ? commitmentModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateBillScenarioCommitmentModificationRequest)) {
            return false;
        }
        BatchCreateBillScenarioCommitmentModificationRequest other = (BatchCreateBillScenarioCommitmentModificationRequest) obj;
        return Objects.equals(billScenarioId(), other.billScenarioId())
                && hasCommitmentModifications() == other.hasCommitmentModifications()
                && Objects.equals(commitmentModifications(), other.commitmentModifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateBillScenarioCommitmentModificationRequest").add("BillScenarioId", billScenarioId())
                .add("CommitmentModifications", hasCommitmentModifications() ? commitmentModifications() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billScenarioId":
            return Optional.ofNullable(clazz.cast(billScenarioId()));
        case "commitmentModifications":
            return Optional.ofNullable(clazz.cast(commitmentModifications()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateBillScenarioCommitmentModificationRequest, T> g) {
        return obj -> g.apply((BatchCreateBillScenarioCommitmentModificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateBillScenarioCommitmentModificationRequest> {
        /**
         * <p>
         * The ID of the Bill Scenario for which you want to create the modeled commitment.
         * </p>
         * 
         * @param billScenarioId
         *        The ID of the Bill Scenario for which you want to create the modeled commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billScenarioId(String billScenarioId);

        /**
         * <p>
         * List of commitments that you want to model in the Bill Scenario.
         * </p>
         * 
         * @param commitmentModifications
         *        List of commitments that you want to model in the Bill Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentModifications(Collection<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications);

        /**
         * <p>
         * List of commitments that you want to model in the Bill Scenario.
         * </p>
         * 
         * @param commitmentModifications
         *        List of commitments that you want to model in the Bill Scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentModifications(BatchCreateBillScenarioCommitmentModificationEntry... commitmentModifications);

        /**
         * <p>
         * List of commitments that you want to model in the Bill Scenario.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #commitmentModifications(List<BatchCreateBillScenarioCommitmentModificationEntry>)}.
         * 
         * @param commitmentModifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentModifications(java.util.Collection<BatchCreateBillScenarioCommitmentModificationEntry>)
         */
        Builder commitmentModifications(
                Consumer<BatchCreateBillScenarioCommitmentModificationEntry.Builder>... commitmentModifications);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String billScenarioId;

        private List<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications = DefaultSdkAutoConstructList
                .getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateBillScenarioCommitmentModificationRequest model) {
            super(model);
            billScenarioId(model.billScenarioId);
            commitmentModifications(model.commitmentModifications);
            clientToken(model.clientToken);
        }

        public final String getBillScenarioId() {
            return billScenarioId;
        }

        public final void setBillScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
        }

        @Override
        public final Builder billScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
            return this;
        }

        public final List<BatchCreateBillScenarioCommitmentModificationEntry.Builder> getCommitmentModifications() {
            List<BatchCreateBillScenarioCommitmentModificationEntry.Builder> result = BatchCreateBillScenarioCommitmentModificationEntriesCopier
                    .copyToBuilder(this.commitmentModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommitmentModifications(
                Collection<BatchCreateBillScenarioCommitmentModificationEntry.BuilderImpl> commitmentModifications) {
            this.commitmentModifications = BatchCreateBillScenarioCommitmentModificationEntriesCopier
                    .copyFromBuilder(commitmentModifications);
        }

        @Override
        public final Builder commitmentModifications(
                Collection<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications) {
            this.commitmentModifications = BatchCreateBillScenarioCommitmentModificationEntriesCopier
                    .copy(commitmentModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(
                BatchCreateBillScenarioCommitmentModificationEntry... commitmentModifications) {
            commitmentModifications(Arrays.asList(commitmentModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(
                Consumer<BatchCreateBillScenarioCommitmentModificationEntry.Builder>... commitmentModifications) {
            commitmentModifications(Stream.of(commitmentModifications)
                    .map(c -> BatchCreateBillScenarioCommitmentModificationEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateBillScenarioCommitmentModificationRequest build() {
            return new BatchCreateBillScenarioCommitmentModificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
