/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateWorkloadEstimateUsageRequest extends BcmPricingCalculatorRequest implements
        ToCopyableBuilder<BatchCreateWorkloadEstimateUsageRequest.Builder, BatchCreateWorkloadEstimateUsageRequest> {
    private static final SdkField<String> WORKLOAD_ESTIMATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadEstimateId").getter(getter(BatchCreateWorkloadEstimateUsageRequest::workloadEstimateId))
            .setter(setter(Builder::workloadEstimateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadEstimateId").build())
            .build();

    private static final SdkField<List<BatchCreateWorkloadEstimateUsageEntry>> USAGE_FIELD = SdkField
            .<List<BatchCreateWorkloadEstimateUsageEntry>> builder(MarshallingType.LIST)
            .memberName("usage")
            .getter(getter(BatchCreateWorkloadEstimateUsageRequest::usage))
            .setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateWorkloadEstimateUsageEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateWorkloadEstimateUsageEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(BatchCreateWorkloadEstimateUsageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ESTIMATE_ID_FIELD,
            USAGE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("workloadEstimateId", WORKLOAD_ESTIMATE_ID_FIELD);
                    put("usage", USAGE_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                }
            });

    private final String workloadEstimateId;

    private final List<BatchCreateWorkloadEstimateUsageEntry> usage;

    private final String clientToken;

    private BatchCreateWorkloadEstimateUsageRequest(BuilderImpl builder) {
        super(builder);
        this.workloadEstimateId = builder.workloadEstimateId;
        this.usage = builder.usage;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Workload estimate for which you want to create the modeled usage.
     * </p>
     * 
     * @return The ID of the Workload estimate for which you want to create the modeled usage.
     */
    public final String workloadEstimateId() {
        return workloadEstimateId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Usage property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsage() {
        return usage != null && !(usage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of usage that you want to model in the Workload estimate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsage} method.
     * </p>
     * 
     * @return List of usage that you want to model in the Workload estimate.
     */
    public final List<BatchCreateWorkloadEstimateUsageEntry> usage() {
        return usage;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadEstimateId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsage() ? usage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateWorkloadEstimateUsageRequest)) {
            return false;
        }
        BatchCreateWorkloadEstimateUsageRequest other = (BatchCreateWorkloadEstimateUsageRequest) obj;
        return Objects.equals(workloadEstimateId(), other.workloadEstimateId()) && hasUsage() == other.hasUsage()
                && Objects.equals(usage(), other.usage()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateWorkloadEstimateUsageRequest").add("WorkloadEstimateId", workloadEstimateId())
                .add("Usage", hasUsage() ? usage() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workloadEstimateId":
            return Optional.ofNullable(clazz.cast(workloadEstimateId()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateWorkloadEstimateUsageRequest, T> g) {
        return obj -> g.apply((BatchCreateWorkloadEstimateUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageRequest> {
        /**
         * <p>
         * The ID of the Workload estimate for which you want to create the modeled usage.
         * </p>
         * 
         * @param workloadEstimateId
         *        The ID of the Workload estimate for which you want to create the modeled usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadEstimateId(String workloadEstimateId);

        /**
         * <p>
         * List of usage that you want to model in the Workload estimate.
         * </p>
         * 
         * @param usage
         *        List of usage that you want to model in the Workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Collection<BatchCreateWorkloadEstimateUsageEntry> usage);

        /**
         * <p>
         * List of usage that you want to model in the Workload estimate.
         * </p>
         * 
         * @param usage
         *        List of usage that you want to model in the Workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(BatchCreateWorkloadEstimateUsageEntry... usage);

        /**
         * <p>
         * List of usage that you want to model in the Workload estimate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageEntry.Builder#build()}
         * is called immediately and its result is passed to {@link #usage(List<BatchCreateWorkloadEstimateUsageEntry>)}.
         * 
         * @param usage
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(java.util.Collection<BatchCreateWorkloadEstimateUsageEntry>)
         */
        Builder usage(Consumer<BatchCreateWorkloadEstimateUsageEntry.Builder>... usage);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String workloadEstimateId;

        private List<BatchCreateWorkloadEstimateUsageEntry> usage = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateWorkloadEstimateUsageRequest model) {
            super(model);
            workloadEstimateId(model.workloadEstimateId);
            usage(model.usage);
            clientToken(model.clientToken);
        }

        public final String getWorkloadEstimateId() {
            return workloadEstimateId;
        }

        public final void setWorkloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
        }

        @Override
        public final Builder workloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
            return this;
        }

        public final List<BatchCreateWorkloadEstimateUsageEntry.Builder> getUsage() {
            List<BatchCreateWorkloadEstimateUsageEntry.Builder> result = BatchCreateWorkloadEstimateUsageEntriesCopier
                    .copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<BatchCreateWorkloadEstimateUsageEntry.BuilderImpl> usage) {
            this.usage = BatchCreateWorkloadEstimateUsageEntriesCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<BatchCreateWorkloadEstimateUsageEntry> usage) {
            this.usage = BatchCreateWorkloadEstimateUsageEntriesCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(BatchCreateWorkloadEstimateUsageEntry... usage) {
            usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<BatchCreateWorkloadEstimateUsageEntry.Builder>... usage) {
            usage(Stream.of(usage).map(c -> BatchCreateWorkloadEstimateUsageEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateWorkloadEstimateUsageRequest build() {
            return new BatchCreateWorkloadEstimateUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
