/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateBillScenarioUsageModificationRequest extends BcmPricingCalculatorRequest
        implements
        ToCopyableBuilder<BatchUpdateBillScenarioUsageModificationRequest.Builder, BatchUpdateBillScenarioUsageModificationRequest> {
    private static final SdkField<String> BILL_SCENARIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billScenarioId").getter(getter(BatchUpdateBillScenarioUsageModificationRequest::billScenarioId))
            .setter(setter(Builder::billScenarioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billScenarioId").build()).build();

    private static final SdkField<List<BatchUpdateBillScenarioUsageModificationEntry>> USAGE_MODIFICATIONS_FIELD = SdkField
            .<List<BatchUpdateBillScenarioUsageModificationEntry>> builder(MarshallingType.LIST)
            .memberName("usageModifications")
            .getter(getter(BatchUpdateBillScenarioUsageModificationRequest::usageModifications))
            .setter(setter(Builder::usageModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageModifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateBillScenarioUsageModificationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateBillScenarioUsageModificationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILL_SCENARIO_ID_FIELD,
            USAGE_MODIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("billScenarioId", BILL_SCENARIO_ID_FIELD);
                    put("usageModifications", USAGE_MODIFICATIONS_FIELD);
                }
            });

    private final String billScenarioId;

    private final List<BatchUpdateBillScenarioUsageModificationEntry> usageModifications;

    private BatchUpdateBillScenarioUsageModificationRequest(BuilderImpl builder) {
        super(builder);
        this.billScenarioId = builder.billScenarioId;
        this.usageModifications = builder.usageModifications;
    }

    /**
     * <p>
     * The ID of the Bill Scenario for which you want to modify the usage lines.
     * </p>
     * 
     * @return The ID of the Bill Scenario for which you want to modify the usage lines.
     */
    public final String billScenarioId() {
        return billScenarioId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageModifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageModifications() {
        return usageModifications != null && !(usageModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageModifications} method.
     * </p>
     * 
     * @return List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
     */
    public final List<BatchUpdateBillScenarioUsageModificationEntry> usageModifications() {
        return usageModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageModifications() ? usageModifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioUsageModificationRequest)) {
            return false;
        }
        BatchUpdateBillScenarioUsageModificationRequest other = (BatchUpdateBillScenarioUsageModificationRequest) obj;
        return Objects.equals(billScenarioId(), other.billScenarioId())
                && hasUsageModifications() == other.hasUsageModifications()
                && Objects.equals(usageModifications(), other.usageModifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateBillScenarioUsageModificationRequest").add("BillScenarioId", billScenarioId())
                .add("UsageModifications", hasUsageModifications() ? usageModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billScenarioId":
            return Optional.ofNullable(clazz.cast(billScenarioId()));
        case "usageModifications":
            return Optional.ofNullable(clazz.cast(usageModifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioUsageModificationRequest, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioUsageModificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateBillScenarioUsageModificationRequest> {
        /**
         * <p>
         * The ID of the Bill Scenario for which you want to modify the usage lines.
         * </p>
         * 
         * @param billScenarioId
         *        The ID of the Bill Scenario for which you want to modify the usage lines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billScenarioId(String billScenarioId);

        /**
         * <p>
         * List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
         * </p>
         * 
         * @param usageModifications
         *        List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageModifications(Collection<BatchUpdateBillScenarioUsageModificationEntry> usageModifications);

        /**
         * <p>
         * List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
         * </p>
         * 
         * @param usageModifications
         *        List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageModifications(BatchUpdateBillScenarioUsageModificationEntry... usageModifications);

        /**
         * <p>
         * List of usage lines that you want to update in a Bill Scenario identified by the usage ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #usageModifications(List<BatchUpdateBillScenarioUsageModificationEntry>)}.
         * 
         * @param usageModifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageModifications(java.util.Collection<BatchUpdateBillScenarioUsageModificationEntry>)
         */
        Builder usageModifications(Consumer<BatchUpdateBillScenarioUsageModificationEntry.Builder>... usageModifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String billScenarioId;

        private List<BatchUpdateBillScenarioUsageModificationEntry> usageModifications = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioUsageModificationRequest model) {
            super(model);
            billScenarioId(model.billScenarioId);
            usageModifications(model.usageModifications);
        }

        public final String getBillScenarioId() {
            return billScenarioId;
        }

        public final void setBillScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
        }

        @Override
        public final Builder billScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
            return this;
        }

        public final List<BatchUpdateBillScenarioUsageModificationEntry.Builder> getUsageModifications() {
            List<BatchUpdateBillScenarioUsageModificationEntry.Builder> result = BatchUpdateBillScenarioUsageModificationEntriesCopier
                    .copyToBuilder(this.usageModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageModifications(
                Collection<BatchUpdateBillScenarioUsageModificationEntry.BuilderImpl> usageModifications) {
            this.usageModifications = BatchUpdateBillScenarioUsageModificationEntriesCopier.copyFromBuilder(usageModifications);
        }

        @Override
        public final Builder usageModifications(Collection<BatchUpdateBillScenarioUsageModificationEntry> usageModifications) {
            this.usageModifications = BatchUpdateBillScenarioUsageModificationEntriesCopier.copy(usageModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageModifications(BatchUpdateBillScenarioUsageModificationEntry... usageModifications) {
            usageModifications(Arrays.asList(usageModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageModifications(
                Consumer<BatchUpdateBillScenarioUsageModificationEntry.Builder>... usageModifications) {
            usageModifications(Stream.of(usageModifications)
                    .map(c -> BatchUpdateBillScenarioUsageModificationEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateBillScenarioUsageModificationRequest build() {
            return new BatchUpdateBillScenarioUsageModificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
