/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes an input usage modification for a bill estimate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillEstimateInputUsageModificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillEstimateInputUsageModificationSummary.Builder, BillEstimateInputUsageModificationSummary> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(BillEstimateInputUsageModificationSummary::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(BillEstimateInputUsageModificationSummary::usageType))
            .setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(BillEstimateInputUsageModificationSummary::operation))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(BillEstimateInputUsageModificationSummary::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(BillEstimateInputUsageModificationSummary::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BillEstimateInputUsageModificationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BillEstimateInputUsageModificationSummary::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BillEstimateInputUsageModificationSummary::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<List<UsageQuantity>> QUANTITIES_FIELD = SdkField
            .<List<UsageQuantity>> builder(MarshallingType.LIST)
            .memberName("quantities")
            .getter(getter(BillEstimateInputUsageModificationSummary::quantities))
            .setter(setter(Builder::quantities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageQuantity> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageQuantity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField
            .<HistoricalUsageEntity> builder(MarshallingType.SDK_POJO).memberName("historicalUsage")
            .getter(getter(BillEstimateInputUsageModificationSummary::historicalUsage)).setter(setter(Builder::historicalUsage))
            .constructor(HistoricalUsageEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, AVAILABILITY_ZONE_FIELD, ID_FIELD, GROUP_FIELD,
            USAGE_ACCOUNT_ID_FIELD, QUANTITIES_FIELD, HISTORICAL_USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("serviceCode", SERVICE_CODE_FIELD);
                    put("usageType", USAGE_TYPE_FIELD);
                    put("operation", OPERATION_FIELD);
                    put("location", LOCATION_FIELD);
                    put("availabilityZone", AVAILABILITY_ZONE_FIELD);
                    put("id", ID_FIELD);
                    put("group", GROUP_FIELD);
                    put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
                    put("quantities", QUANTITIES_FIELD);
                    put("historicalUsage", HISTORICAL_USAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final String location;

    private final String availabilityZone;

    private final String id;

    private final String group;

    private final String usageAccountId;

    private final List<UsageQuantity> quantities;

    private final HistoricalUsageEntity historicalUsage;

    private BillEstimateInputUsageModificationSummary(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.availabilityZone = builder.availabilityZone;
        this.id = builder.id;
        this.group = builder.group;
        this.usageAccountId = builder.usageAccountId;
        this.quantities = builder.quantities;
        this.historicalUsage = builder.historicalUsage;
    }

    /**
     * <p>
     * The Amazon Web Services service code for this usage modification.
     * </p>
     * 
     * @return The Amazon Web Services service code for this usage modification.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The type of usage being modified.
     * </p>
     * 
     * @return The type of usage being modified.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific operation associated with this usage modification.
     * </p>
     * 
     * @return The specific operation associated with this usage modification.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The location associated with this usage modification.
     * </p>
     * 
     * @return The location associated with this usage modification.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The availability zone associated with this usage modification, if applicable.
     * </p>
     * 
     * @return The availability zone associated with this usage modification, if applicable.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The unique identifier of the usage modification.
     * </p>
     * 
     * @return The unique identifier of the usage modification.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The group identifier for the usage modification.
     * </p>
     * 
     * @return The group identifier for the usage modification.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with this usage modification.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with this usage modification.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Quantities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQuantities() {
        return quantities != null && !(quantities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The modified usage quantities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuantities} method.
     * </p>
     * 
     * @return The modified usage quantities.
     */
    public final List<UsageQuantity> quantities() {
        return quantities;
    }

    /**
     * <p>
     * Historical usage data associated with this modification, if available.
     * </p>
     * 
     * @return Historical usage data associated with this modification, if available.
     */
    public final HistoricalUsageEntity historicalUsage() {
        return historicalUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuantities() ? quantities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(historicalUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateInputUsageModificationSummary)) {
            return false;
        }
        BillEstimateInputUsageModificationSummary other = (BillEstimateInputUsageModificationSummary) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(usageType(), other.usageType())
                && Objects.equals(operation(), other.operation()) && Objects.equals(location(), other.location())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(id(), other.id())
                && Objects.equals(group(), other.group()) && Objects.equals(usageAccountId(), other.usageAccountId())
                && hasQuantities() == other.hasQuantities() && Objects.equals(quantities(), other.quantities())
                && Objects.equals(historicalUsage(), other.historicalUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillEstimateInputUsageModificationSummary").add("ServiceCode", serviceCode())
                .add("UsageType", usageType()).add("Operation", operation()).add("Location", location())
                .add("AvailabilityZone", availabilityZone()).add("Id", id()).add("Group", group())
                .add("UsageAccountId", usageAccountId()).add("Quantities", hasQuantities() ? quantities() : null)
                .add("HistoricalUsage", historicalUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "quantities":
            return Optional.ofNullable(clazz.cast(quantities()));
        case "historicalUsage":
            return Optional.ofNullable(clazz.cast(historicalUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateInputUsageModificationSummary, T> g) {
        return obj -> g.apply((BillEstimateInputUsageModificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillEstimateInputUsageModificationSummary> {
        /**
         * <p>
         * The Amazon Web Services service code for this usage modification.
         * </p>
         * 
         * @param serviceCode
         *        The Amazon Web Services service code for this usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The type of usage being modified.
         * </p>
         * 
         * @param usageType
         *        The type of usage being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific operation associated with this usage modification.
         * </p>
         * 
         * @param operation
         *        The specific operation associated with this usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The location associated with this usage modification.
         * </p>
         * 
         * @param location
         *        The location associated with this usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The availability zone associated with this usage modification, if applicable.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone associated with this usage modification, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The unique identifier of the usage modification.
         * </p>
         * 
         * @param id
         *        The unique identifier of the usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The group identifier for the usage modification.
         * </p>
         * 
         * @param group
         *        The group identifier for the usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The Amazon Web Services account ID associated with this usage modification.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID associated with this usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The modified usage quantities.
         * </p>
         * 
         * @param quantities
         *        The modified usage quantities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantities(Collection<UsageQuantity> quantities);

        /**
         * <p>
         * The modified usage quantities.
         * </p>
         * 
         * @param quantities
         *        The modified usage quantities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantities(UsageQuantity... quantities);

        /**
         * <p>
         * The modified usage quantities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantity.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantity.Builder#build()} is called
         * immediately and its result is passed to {@link #quantities(List<UsageQuantity>)}.
         * 
         * @param quantities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quantities(java.util.Collection<UsageQuantity>)
         */
        Builder quantities(Consumer<UsageQuantity.Builder>... quantities);

        /**
         * <p>
         * Historical usage data associated with this modification, if available.
         * </p>
         * 
         * @param historicalUsage
         *        Historical usage data associated with this modification, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalUsage(HistoricalUsageEntity historicalUsage);

        /**
         * <p>
         * Historical usage data associated with this modification, if available.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoricalUsageEntity.Builder} avoiding
         * the need to create one manually via {@link HistoricalUsageEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoricalUsageEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #historicalUsage(HistoricalUsageEntity)}.
         * 
         * @param historicalUsage
         *        a consumer that will call methods on {@link HistoricalUsageEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalUsage(HistoricalUsageEntity)
         */
        default Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return historicalUsage(HistoricalUsageEntity.builder().applyMutation(historicalUsage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String usageType;

        private String operation;

        private String location;

        private String availabilityZone;

        private String id;

        private String group;

        private String usageAccountId;

        private List<UsageQuantity> quantities = DefaultSdkAutoConstructList.getInstance();

        private HistoricalUsageEntity historicalUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateInputUsageModificationSummary model) {
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            location(model.location);
            availabilityZone(model.availabilityZone);
            id(model.id);
            group(model.group);
            usageAccountId(model.usageAccountId);
            quantities(model.quantities);
            historicalUsage(model.historicalUsage);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final List<UsageQuantity.Builder> getQuantities() {
            List<UsageQuantity.Builder> result = UsageQuantitiesCopier.copyToBuilder(this.quantities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuantities(Collection<UsageQuantity.BuilderImpl> quantities) {
            this.quantities = UsageQuantitiesCopier.copyFromBuilder(quantities);
        }

        @Override
        public final Builder quantities(Collection<UsageQuantity> quantities) {
            this.quantities = UsageQuantitiesCopier.copy(quantities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quantities(UsageQuantity... quantities) {
            quantities(Arrays.asList(quantities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quantities(Consumer<UsageQuantity.Builder>... quantities) {
            quantities(Stream.of(quantities).map(c -> UsageQuantity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return historicalUsage != null ? historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        @Override
        public BillEstimateInputUsageModificationSummary build() {
            return new BillEstimateInputUsageModificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
