/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action to modify commitments in a bill scenario.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillScenarioCommitmentModificationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<BillScenarioCommitmentModificationAction.Builder, BillScenarioCommitmentModificationAction> {
    private static final SdkField<AddReservedInstanceAction> ADD_RESERVED_INSTANCE_ACTION_FIELD = SdkField
            .<AddReservedInstanceAction> builder(MarshallingType.SDK_POJO).memberName("addReservedInstanceAction")
            .getter(getter(BillScenarioCommitmentModificationAction::addReservedInstanceAction))
            .setter(setter(Builder::addReservedInstanceAction)).constructor(AddReservedInstanceAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addReservedInstanceAction").build())
            .build();

    private static final SdkField<AddSavingsPlanAction> ADD_SAVINGS_PLAN_ACTION_FIELD = SdkField
            .<AddSavingsPlanAction> builder(MarshallingType.SDK_POJO).memberName("addSavingsPlanAction")
            .getter(getter(BillScenarioCommitmentModificationAction::addSavingsPlanAction))
            .setter(setter(Builder::addSavingsPlanAction)).constructor(AddSavingsPlanAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addSavingsPlanAction").build())
            .build();

    private static final SdkField<NegateReservedInstanceAction> NEGATE_RESERVED_INSTANCE_ACTION_FIELD = SdkField
            .<NegateReservedInstanceAction> builder(MarshallingType.SDK_POJO)
            .memberName("negateReservedInstanceAction")
            .getter(getter(BillScenarioCommitmentModificationAction::negateReservedInstanceAction))
            .setter(setter(Builder::negateReservedInstanceAction))
            .constructor(NegateReservedInstanceAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("negateReservedInstanceAction")
                    .build()).build();

    private static final SdkField<NegateSavingsPlanAction> NEGATE_SAVINGS_PLAN_ACTION_FIELD = SdkField
            .<NegateSavingsPlanAction> builder(MarshallingType.SDK_POJO).memberName("negateSavingsPlanAction")
            .getter(getter(BillScenarioCommitmentModificationAction::negateSavingsPlanAction))
            .setter(setter(Builder::negateSavingsPlanAction)).constructor(NegateSavingsPlanAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("negateSavingsPlanAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADD_RESERVED_INSTANCE_ACTION_FIELD, ADD_SAVINGS_PLAN_ACTION_FIELD, NEGATE_RESERVED_INSTANCE_ACTION_FIELD,
            NEGATE_SAVINGS_PLAN_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("addReservedInstanceAction", ADD_RESERVED_INSTANCE_ACTION_FIELD);
                    put("addSavingsPlanAction", ADD_SAVINGS_PLAN_ACTION_FIELD);
                    put("negateReservedInstanceAction", NEGATE_RESERVED_INSTANCE_ACTION_FIELD);
                    put("negateSavingsPlanAction", NEGATE_SAVINGS_PLAN_ACTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AddReservedInstanceAction addReservedInstanceAction;

    private final AddSavingsPlanAction addSavingsPlanAction;

    private final NegateReservedInstanceAction negateReservedInstanceAction;

    private final NegateSavingsPlanAction negateSavingsPlanAction;

    private final Type type;

    private BillScenarioCommitmentModificationAction(BuilderImpl builder) {
        this.addReservedInstanceAction = builder.addReservedInstanceAction;
        this.addSavingsPlanAction = builder.addSavingsPlanAction;
        this.negateReservedInstanceAction = builder.negateReservedInstanceAction;
        this.negateSavingsPlanAction = builder.negateSavingsPlanAction;
        this.type = builder.type;
    }

    /**
     * <p>
     * Action to add a Reserved Instance to the scenario.
     * </p>
     * 
     * @return Action to add a Reserved Instance to the scenario.
     */
    public final AddReservedInstanceAction addReservedInstanceAction() {
        return addReservedInstanceAction;
    }

    /**
     * <p>
     * Action to add a Savings Plan to the scenario.
     * </p>
     * 
     * @return Action to add a Savings Plan to the scenario.
     */
    public final AddSavingsPlanAction addSavingsPlanAction() {
        return addSavingsPlanAction;
    }

    /**
     * <p>
     * Action to remove a Reserved Instance from the scenario.
     * </p>
     * 
     * @return Action to remove a Reserved Instance from the scenario.
     */
    public final NegateReservedInstanceAction negateReservedInstanceAction() {
        return negateReservedInstanceAction;
    }

    /**
     * <p>
     * Action to remove a Savings Plan from the scenario.
     * </p>
     * 
     * @return Action to remove a Savings Plan from the scenario.
     */
    public final NegateSavingsPlanAction negateSavingsPlanAction() {
        return negateSavingsPlanAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addReservedInstanceAction());
        hashCode = 31 * hashCode + Objects.hashCode(addSavingsPlanAction());
        hashCode = 31 * hashCode + Objects.hashCode(negateReservedInstanceAction());
        hashCode = 31 * hashCode + Objects.hashCode(negateSavingsPlanAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillScenarioCommitmentModificationAction)) {
            return false;
        }
        BillScenarioCommitmentModificationAction other = (BillScenarioCommitmentModificationAction) obj;
        return Objects.equals(addReservedInstanceAction(), other.addReservedInstanceAction())
                && Objects.equals(addSavingsPlanAction(), other.addSavingsPlanAction())
                && Objects.equals(negateReservedInstanceAction(), other.negateReservedInstanceAction())
                && Objects.equals(negateSavingsPlanAction(), other.negateSavingsPlanAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillScenarioCommitmentModificationAction")
                .add("AddReservedInstanceAction", addReservedInstanceAction())
                .add("AddSavingsPlanAction", addSavingsPlanAction())
                .add("NegateReservedInstanceAction", negateReservedInstanceAction())
                .add("NegateSavingsPlanAction", negateSavingsPlanAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addReservedInstanceAction":
            return Optional.ofNullable(clazz.cast(addReservedInstanceAction()));
        case "addSavingsPlanAction":
            return Optional.ofNullable(clazz.cast(addSavingsPlanAction()));
        case "negateReservedInstanceAction":
            return Optional.ofNullable(clazz.cast(negateReservedInstanceAction()));
        case "negateSavingsPlanAction":
            return Optional.ofNullable(clazz.cast(negateSavingsPlanAction()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addReservedInstanceAction()} initialized to the given value.
     *
     * <p>
     * Action to add a Reserved Instance to the scenario.
     * </p>
     * 
     * @param addReservedInstanceAction
     *        Action to add a Reserved Instance to the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromAddReservedInstanceAction(
            AddReservedInstanceAction addReservedInstanceAction) {
        return builder().addReservedInstanceAction(addReservedInstanceAction).build();
    }

    /**
     * Create an instance of this class with {@link #addReservedInstanceAction()} initialized to the given value.
     *
     * <p>
     * Action to add a Reserved Instance to the scenario.
     * </p>
     * 
     * @param addReservedInstanceAction
     *        Action to add a Reserved Instance to the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromAddReservedInstanceAction(
            Consumer<AddReservedInstanceAction.Builder> addReservedInstanceAction) {
        AddReservedInstanceAction.Builder builder = AddReservedInstanceAction.builder();
        addReservedInstanceAction.accept(builder);
        return fromAddReservedInstanceAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #addSavingsPlanAction()} initialized to the given value.
     *
     * <p>
     * Action to add a Savings Plan to the scenario.
     * </p>
     * 
     * @param addSavingsPlanAction
     *        Action to add a Savings Plan to the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromAddSavingsPlanAction(AddSavingsPlanAction addSavingsPlanAction) {
        return builder().addSavingsPlanAction(addSavingsPlanAction).build();
    }

    /**
     * Create an instance of this class with {@link #addSavingsPlanAction()} initialized to the given value.
     *
     * <p>
     * Action to add a Savings Plan to the scenario.
     * </p>
     * 
     * @param addSavingsPlanAction
     *        Action to add a Savings Plan to the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromAddSavingsPlanAction(
            Consumer<AddSavingsPlanAction.Builder> addSavingsPlanAction) {
        AddSavingsPlanAction.Builder builder = AddSavingsPlanAction.builder();
        addSavingsPlanAction.accept(builder);
        return fromAddSavingsPlanAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #negateReservedInstanceAction()} initialized to the given value.
     *
     * <p>
     * Action to remove a Reserved Instance from the scenario.
     * </p>
     * 
     * @param negateReservedInstanceAction
     *        Action to remove a Reserved Instance from the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromNegateReservedInstanceAction(
            NegateReservedInstanceAction negateReservedInstanceAction) {
        return builder().negateReservedInstanceAction(negateReservedInstanceAction).build();
    }

    /**
     * Create an instance of this class with {@link #negateReservedInstanceAction()} initialized to the given value.
     *
     * <p>
     * Action to remove a Reserved Instance from the scenario.
     * </p>
     * 
     * @param negateReservedInstanceAction
     *        Action to remove a Reserved Instance from the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromNegateReservedInstanceAction(
            Consumer<NegateReservedInstanceAction.Builder> negateReservedInstanceAction) {
        NegateReservedInstanceAction.Builder builder = NegateReservedInstanceAction.builder();
        negateReservedInstanceAction.accept(builder);
        return fromNegateReservedInstanceAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #negateSavingsPlanAction()} initialized to the given value.
     *
     * <p>
     * Action to remove a Savings Plan from the scenario.
     * </p>
     * 
     * @param negateSavingsPlanAction
     *        Action to remove a Savings Plan from the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromNegateSavingsPlanAction(
            NegateSavingsPlanAction negateSavingsPlanAction) {
        return builder().negateSavingsPlanAction(negateSavingsPlanAction).build();
    }

    /**
     * Create an instance of this class with {@link #negateSavingsPlanAction()} initialized to the given value.
     *
     * <p>
     * Action to remove a Savings Plan from the scenario.
     * </p>
     * 
     * @param negateSavingsPlanAction
     *        Action to remove a Savings Plan from the scenario.
     */
    public static BillScenarioCommitmentModificationAction fromNegateSavingsPlanAction(
            Consumer<NegateSavingsPlanAction.Builder> negateSavingsPlanAction) {
        NegateSavingsPlanAction.Builder builder = NegateSavingsPlanAction.builder();
        negateSavingsPlanAction.accept(builder);
        return fromNegateSavingsPlanAction(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BillScenarioCommitmentModificationAction, T> g) {
        return obj -> g.apply((BillScenarioCommitmentModificationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillScenarioCommitmentModificationAction> {
        /**
         * <p>
         * Action to add a Reserved Instance to the scenario.
         * </p>
         * 
         * @param addReservedInstanceAction
         *        Action to add a Reserved Instance to the scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addReservedInstanceAction(AddReservedInstanceAction addReservedInstanceAction);

        /**
         * <p>
         * Action to add a Reserved Instance to the scenario.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddReservedInstanceAction.Builder}
         * avoiding the need to create one manually via {@link AddReservedInstanceAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddReservedInstanceAction.Builder#build()} is called immediately
         * and its result is passed to {@link #addReservedInstanceAction(AddReservedInstanceAction)}.
         * 
         * @param addReservedInstanceAction
         *        a consumer that will call methods on {@link AddReservedInstanceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addReservedInstanceAction(AddReservedInstanceAction)
         */
        default Builder addReservedInstanceAction(Consumer<AddReservedInstanceAction.Builder> addReservedInstanceAction) {
            return addReservedInstanceAction(AddReservedInstanceAction.builder().applyMutation(addReservedInstanceAction).build());
        }

        /**
         * <p>
         * Action to add a Savings Plan to the scenario.
         * </p>
         * 
         * @param addSavingsPlanAction
         *        Action to add a Savings Plan to the scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSavingsPlanAction(AddSavingsPlanAction addSavingsPlanAction);

        /**
         * <p>
         * Action to add a Savings Plan to the scenario.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddSavingsPlanAction.Builder} avoiding
         * the need to create one manually via {@link AddSavingsPlanAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddSavingsPlanAction.Builder#build()} is called immediately and
         * its result is passed to {@link #addSavingsPlanAction(AddSavingsPlanAction)}.
         * 
         * @param addSavingsPlanAction
         *        a consumer that will call methods on {@link AddSavingsPlanAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addSavingsPlanAction(AddSavingsPlanAction)
         */
        default Builder addSavingsPlanAction(Consumer<AddSavingsPlanAction.Builder> addSavingsPlanAction) {
            return addSavingsPlanAction(AddSavingsPlanAction.builder().applyMutation(addSavingsPlanAction).build());
        }

        /**
         * <p>
         * Action to remove a Reserved Instance from the scenario.
         * </p>
         * 
         * @param negateReservedInstanceAction
         *        Action to remove a Reserved Instance from the scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negateReservedInstanceAction(NegateReservedInstanceAction negateReservedInstanceAction);

        /**
         * <p>
         * Action to remove a Reserved Instance from the scenario.
         * </p>
         * This is a convenience method that creates an instance of the {@link NegateReservedInstanceAction.Builder}
         * avoiding the need to create one manually via {@link NegateReservedInstanceAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NegateReservedInstanceAction.Builder#build()} is called
         * immediately and its result is passed to {@link #negateReservedInstanceAction(NegateReservedInstanceAction)}.
         * 
         * @param negateReservedInstanceAction
         *        a consumer that will call methods on {@link NegateReservedInstanceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #negateReservedInstanceAction(NegateReservedInstanceAction)
         */
        default Builder negateReservedInstanceAction(Consumer<NegateReservedInstanceAction.Builder> negateReservedInstanceAction) {
            return negateReservedInstanceAction(NegateReservedInstanceAction.builder()
                    .applyMutation(negateReservedInstanceAction).build());
        }

        /**
         * <p>
         * Action to remove a Savings Plan from the scenario.
         * </p>
         * 
         * @param negateSavingsPlanAction
         *        Action to remove a Savings Plan from the scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negateSavingsPlanAction(NegateSavingsPlanAction negateSavingsPlanAction);

        /**
         * <p>
         * Action to remove a Savings Plan from the scenario.
         * </p>
         * This is a convenience method that creates an instance of the {@link NegateSavingsPlanAction.Builder} avoiding
         * the need to create one manually via {@link NegateSavingsPlanAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NegateSavingsPlanAction.Builder#build()} is called immediately
         * and its result is passed to {@link #negateSavingsPlanAction(NegateSavingsPlanAction)}.
         * 
         * @param negateSavingsPlanAction
         *        a consumer that will call methods on {@link NegateSavingsPlanAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #negateSavingsPlanAction(NegateSavingsPlanAction)
         */
        default Builder negateSavingsPlanAction(Consumer<NegateSavingsPlanAction.Builder> negateSavingsPlanAction) {
            return negateSavingsPlanAction(NegateSavingsPlanAction.builder().applyMutation(negateSavingsPlanAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddReservedInstanceAction addReservedInstanceAction;

        private AddSavingsPlanAction addSavingsPlanAction;

        private NegateReservedInstanceAction negateReservedInstanceAction;

        private NegateSavingsPlanAction negateSavingsPlanAction;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BillScenarioCommitmentModificationAction model) {
            addReservedInstanceAction(model.addReservedInstanceAction);
            addSavingsPlanAction(model.addSavingsPlanAction);
            negateReservedInstanceAction(model.negateReservedInstanceAction);
            negateSavingsPlanAction(model.negateSavingsPlanAction);
        }

        public final AddReservedInstanceAction.Builder getAddReservedInstanceAction() {
            return addReservedInstanceAction != null ? addReservedInstanceAction.toBuilder() : null;
        }

        public final void setAddReservedInstanceAction(AddReservedInstanceAction.BuilderImpl addReservedInstanceAction) {
            Object oldValue = this.addReservedInstanceAction;
            this.addReservedInstanceAction = addReservedInstanceAction != null ? addReservedInstanceAction.build() : null;
            handleUnionValueChange(Type.ADD_RESERVED_INSTANCE_ACTION, oldValue, this.addReservedInstanceAction);
        }

        @Override
        public final Builder addReservedInstanceAction(AddReservedInstanceAction addReservedInstanceAction) {
            Object oldValue = this.addReservedInstanceAction;
            this.addReservedInstanceAction = addReservedInstanceAction;
            handleUnionValueChange(Type.ADD_RESERVED_INSTANCE_ACTION, oldValue, this.addReservedInstanceAction);
            return this;
        }

        public final AddSavingsPlanAction.Builder getAddSavingsPlanAction() {
            return addSavingsPlanAction != null ? addSavingsPlanAction.toBuilder() : null;
        }

        public final void setAddSavingsPlanAction(AddSavingsPlanAction.BuilderImpl addSavingsPlanAction) {
            Object oldValue = this.addSavingsPlanAction;
            this.addSavingsPlanAction = addSavingsPlanAction != null ? addSavingsPlanAction.build() : null;
            handleUnionValueChange(Type.ADD_SAVINGS_PLAN_ACTION, oldValue, this.addSavingsPlanAction);
        }

        @Override
        public final Builder addSavingsPlanAction(AddSavingsPlanAction addSavingsPlanAction) {
            Object oldValue = this.addSavingsPlanAction;
            this.addSavingsPlanAction = addSavingsPlanAction;
            handleUnionValueChange(Type.ADD_SAVINGS_PLAN_ACTION, oldValue, this.addSavingsPlanAction);
            return this;
        }

        public final NegateReservedInstanceAction.Builder getNegateReservedInstanceAction() {
            return negateReservedInstanceAction != null ? negateReservedInstanceAction.toBuilder() : null;
        }

        public final void setNegateReservedInstanceAction(NegateReservedInstanceAction.BuilderImpl negateReservedInstanceAction) {
            Object oldValue = this.negateReservedInstanceAction;
            this.negateReservedInstanceAction = negateReservedInstanceAction != null ? negateReservedInstanceAction.build()
                    : null;
            handleUnionValueChange(Type.NEGATE_RESERVED_INSTANCE_ACTION, oldValue, this.negateReservedInstanceAction);
        }

        @Override
        public final Builder negateReservedInstanceAction(NegateReservedInstanceAction negateReservedInstanceAction) {
            Object oldValue = this.negateReservedInstanceAction;
            this.negateReservedInstanceAction = negateReservedInstanceAction;
            handleUnionValueChange(Type.NEGATE_RESERVED_INSTANCE_ACTION, oldValue, this.negateReservedInstanceAction);
            return this;
        }

        public final NegateSavingsPlanAction.Builder getNegateSavingsPlanAction() {
            return negateSavingsPlanAction != null ? negateSavingsPlanAction.toBuilder() : null;
        }

        public final void setNegateSavingsPlanAction(NegateSavingsPlanAction.BuilderImpl negateSavingsPlanAction) {
            Object oldValue = this.negateSavingsPlanAction;
            this.negateSavingsPlanAction = negateSavingsPlanAction != null ? negateSavingsPlanAction.build() : null;
            handleUnionValueChange(Type.NEGATE_SAVINGS_PLAN_ACTION, oldValue, this.negateSavingsPlanAction);
        }

        @Override
        public final Builder negateSavingsPlanAction(NegateSavingsPlanAction negateSavingsPlanAction) {
            Object oldValue = this.negateSavingsPlanAction;
            this.negateSavingsPlanAction = negateSavingsPlanAction;
            handleUnionValueChange(Type.NEGATE_SAVINGS_PLAN_ACTION, oldValue, this.negateSavingsPlanAction);
            return this;
        }

        @Override
        public BillScenarioCommitmentModificationAction build() {
            return new BillScenarioCommitmentModificationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see BillScenarioCommitmentModificationAction#type()
     */
    public enum Type {
        ADD_RESERVED_INSTANCE_ACTION,

        ADD_SAVINGS_PLAN_ACTION,

        NEGATE_RESERVED_INSTANCE_ACTION,

        NEGATE_SAVINGS_PLAN_ACTION,

        UNKNOWN_TO_SDK_VERSION
    }
}
