/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkloadEstimateRequest extends BcmPricingCalculatorRequest implements
        ToCopyableBuilder<CreateWorkloadEstimateRequest.Builder, CreateWorkloadEstimateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkloadEstimateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateWorkloadEstimateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rateType").getter(getter(CreateWorkloadEstimateRequest::rateTypeAsString))
            .setter(setter(Builder::rateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateWorkloadEstimateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLIENT_TOKEN_FIELD, RATE_TYPE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("rateType", RATE_TYPE_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String name;

    private final String clientToken;

    private final String rateType;

    private final Map<String, String> tags;

    private CreateWorkloadEstimateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.rateType = builder.rateType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A descriptive name for the workload estimate.
     * </p>
     * 
     * @return A descriptive name for the workload estimate.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The type of pricing rates to use for the estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateType} will
     * return {@link WorkloadEstimateRateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateTypeAsString}.
     * </p>
     * 
     * @return The type of pricing rates to use for the estimate.
     * @see WorkloadEstimateRateType
     */
    public final WorkloadEstimateRateType rateType() {
        return WorkloadEstimateRateType.fromValue(rateType);
    }

    /**
     * <p>
     * The type of pricing rates to use for the estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateType} will
     * return {@link WorkloadEstimateRateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateTypeAsString}.
     * </p>
     * 
     * @return The type of pricing rates to use for the estimate.
     * @see WorkloadEstimateRateType
     */
    public final String rateTypeAsString() {
        return rateType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the workload estimate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the workload estimate.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(rateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadEstimateRequest)) {
            return false;
        }
        CreateWorkloadEstimateRequest other = (CreateWorkloadEstimateRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(rateTypeAsString(), other.rateTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkloadEstimateRequest").add("Name", name()).add("ClientToken", clientToken())
                .add("RateType", rateTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "rateType":
            return Optional.ofNullable(clazz.cast(rateTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadEstimateRequest, T> g) {
        return obj -> g.apply((CreateWorkloadEstimateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkloadEstimateRequest> {
        /**
         * <p>
         * A descriptive name for the workload estimate.
         * </p>
         * 
         * @param name
         *        A descriptive name for the workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The type of pricing rates to use for the estimate.
         * </p>
         * 
         * @param rateType
         *        The type of pricing rates to use for the estimate.
         * @see WorkloadEstimateRateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateRateType
         */
        Builder rateType(String rateType);

        /**
         * <p>
         * The type of pricing rates to use for the estimate.
         * </p>
         * 
         * @param rateType
         *        The type of pricing rates to use for the estimate.
         * @see WorkloadEstimateRateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateRateType
         */
        Builder rateType(WorkloadEstimateRateType rateType);

        /**
         * <p>
         * The tags to apply to the workload estimate.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String name;

        private String clientToken;

        private String rateType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadEstimateRequest model) {
            super(model);
            name(model.name);
            clientToken(model.clientToken);
            rateType(model.rateType);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRateType() {
            return rateType;
        }

        public final void setRateType(String rateType) {
            this.rateType = rateType;
        }

        @Override
        public final Builder rateType(String rateType) {
            this.rateType = rateType;
            return this;
        }

        @Override
        public final Builder rateType(WorkloadEstimateRateType rateType) {
            this.rateType(rateType == null ? null : rateType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkloadEstimateRequest build() {
            return new CreateWorkloadEstimateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
