/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a complex filtering expression for cost and usage data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expression implements SdkPojo, Serializable, ToCopyableBuilder<Expression.Builder, Expression> {
    private static final SdkField<List<Expression>> AND_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("and")
            .getter(getter(Expression::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Expression>> OR_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("or")
            .getter(getter(Expression::or))
            .setter(setter(Builder::or))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Expression> NOT_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("not").getter(getter(Expression::not)).setter(setter(Builder::not)).constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("not").build()).build();

    private static final SdkField<ExpressionFilter> COST_CATEGORIES_FIELD = SdkField
            .<ExpressionFilter> builder(MarshallingType.SDK_POJO).memberName("costCategories")
            .getter(getter(Expression::costCategories)).setter(setter(Builder::costCategories))
            .constructor(ExpressionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCategories").build()).build();

    private static final SdkField<ExpressionFilter> DIMENSIONS_FIELD = SdkField
            .<ExpressionFilter> builder(MarshallingType.SDK_POJO).memberName("dimensions").getter(getter(Expression::dimensions))
            .setter(setter(Builder::dimensions)).constructor(ExpressionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()).build();

    private static final SdkField<ExpressionFilter> TAGS_FIELD = SdkField.<ExpressionFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tags").getter(getter(Expression::tags)).setter(setter(Builder::tags))
            .constructor(ExpressionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, OR_FIELD,
            NOT_FIELD, COST_CATEGORIES_FIELD, DIMENSIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("and", AND_FIELD);
                    put("or", OR_FIELD);
                    put("not", NOT_FIELD);
                    put("costCategories", COST_CATEGORIES_FIELD);
                    put("dimensions", DIMENSIONS_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<Expression> and;

    private final List<Expression> or;

    private final Expression not;

    private final ExpressionFilter costCategories;

    private final ExpressionFilter dimensions;

    private final ExpressionFilter tags;

    private Expression(BuilderImpl builder) {
        this.and = builder.and;
        this.or = builder.or;
        this.not = builder.not;
        this.costCategories = builder.costCategories;
        this.dimensions = builder.dimensions;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of expressions to be combined with AND logic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return A list of expressions to be combined with AND logic.
     */
    public final List<Expression> and() {
        return and;
    }

    /**
     * For responses, this returns true if the service returned a value for the Or property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOr() {
        return or != null && !(or instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of expressions to be combined with OR logic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOr} method.
     * </p>
     * 
     * @return A list of expressions to be combined with OR logic.
     */
    public final List<Expression> or() {
        return or;
    }

    /**
     * <p>
     * An expression to be negated.
     * </p>
     * 
     * @return An expression to be negated.
     */
    public final Expression not() {
        return not;
    }

    /**
     * <p>
     * Filters based on cost categories.
     * </p>
     * 
     * @return Filters based on cost categories.
     */
    public final ExpressionFilter costCategories() {
        return costCategories;
    }

    /**
     * <p>
     * Filters based on dimensions (e.g., service, operation).
     * </p>
     * 
     * @return Filters based on dimensions (e.g., service, operation).
     */
    public final ExpressionFilter dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * Filters based on resource tags.
     * </p>
     * 
     * @return Filters based on resource tags.
     */
    public final ExpressionFilter tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOr() ? or() : null);
        hashCode = 31 * hashCode + Objects.hashCode(not());
        hashCode = 31 * hashCode + Objects.hashCode(costCategories());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression) obj;
        return hasAnd() == other.hasAnd() && Objects.equals(and(), other.and()) && hasOr() == other.hasOr()
                && Objects.equals(or(), other.or()) && Objects.equals(not(), other.not())
                && Objects.equals(costCategories(), other.costCategories()) && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expression").add("And", hasAnd() ? and() : null).add("Or", hasOr() ? or() : null)
                .add("Not", not()).add("CostCategories", costCategories()).add("Dimensions", dimensions()).add("Tags", tags())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "and":
            return Optional.ofNullable(clazz.cast(and()));
        case "or":
            return Optional.ofNullable(clazz.cast(or()));
        case "not":
            return Optional.ofNullable(clazz.cast(not()));
        case "costCategories":
            return Optional.ofNullable(clazz.cast(costCategories()));
        case "dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expression> {
        /**
         * <p>
         * A list of expressions to be combined with AND logic.
         * </p>
         * 
         * @param and
         *        A list of expressions to be combined with AND logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<Expression> and);

        /**
         * <p>
         * A list of expressions to be combined with AND logic.
         * </p>
         * 
         * @param and
         *        A list of expressions to be combined with AND logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Expression... and);

        /**
         * <p>
         * A list of expressions to be combined with AND logic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression.Builder#build()} is called
         * immediately and its result is passed to {@link #and(List<Expression>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<Expression>)
         */
        Builder and(Consumer<Builder>... and);

        /**
         * <p>
         * A list of expressions to be combined with OR logic.
         * </p>
         * 
         * @param or
         *        A list of expressions to be combined with OR logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Collection<Expression> or);

        /**
         * <p>
         * A list of expressions to be combined with OR logic.
         * </p>
         * 
         * @param or
         *        A list of expressions to be combined with OR logic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Expression... or);

        /**
         * <p>
         * A list of expressions to be combined with OR logic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression.Builder#build()} is called
         * immediately and its result is passed to {@link #or(List<Expression>)}.
         * 
         * @param or
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(java.util.Collection<Expression>)
         */
        Builder or(Consumer<Builder>... or);

        /**
         * <p>
         * An expression to be negated.
         * </p>
         * 
         * @param not
         *        An expression to be negated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder not(Expression not);

        /**
         * <p>
         * An expression to be negated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #not(Expression)}.
         * 
         * @param not
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #not(Expression)
         */
        default Builder not(Consumer<Builder> not) {
            return not(Expression.builder().applyMutation(not).build());
        }

        /**
         * <p>
         * Filters based on cost categories.
         * </p>
         * 
         * @param costCategories
         *        Filters based on cost categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategories(ExpressionFilter costCategories);

        /**
         * <p>
         * Filters based on cost categories.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressionFilter.Builder} avoiding the
         * need to create one manually via {@link ExpressionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #costCategories(ExpressionFilter)}.
         * 
         * @param costCategories
         *        a consumer that will call methods on {@link ExpressionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCategories(ExpressionFilter)
         */
        default Builder costCategories(Consumer<ExpressionFilter.Builder> costCategories) {
            return costCategories(ExpressionFilter.builder().applyMutation(costCategories).build());
        }

        /**
         * <p>
         * Filters based on dimensions (e.g., service, operation).
         * </p>
         * 
         * @param dimensions
         *        Filters based on dimensions (e.g., service, operation).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(ExpressionFilter dimensions);

        /**
         * <p>
         * Filters based on dimensions (e.g., service, operation).
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressionFilter.Builder} avoiding the
         * need to create one manually via {@link ExpressionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(ExpressionFilter)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link ExpressionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(ExpressionFilter)
         */
        default Builder dimensions(Consumer<ExpressionFilter.Builder> dimensions) {
            return dimensions(ExpressionFilter.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * Filters based on resource tags.
         * </p>
         * 
         * @param tags
         *        Filters based on resource tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(ExpressionFilter tags);

        /**
         * <p>
         * Filters based on resource tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressionFilter.Builder} avoiding the
         * need to create one manually via {@link ExpressionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(ExpressionFilter)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link ExpressionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(ExpressionFilter)
         */
        default Builder tags(Consumer<ExpressionFilter.Builder> tags) {
            return tags(ExpressionFilter.builder().applyMutation(tags).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Expression> and = DefaultSdkAutoConstructList.getInstance();

        private List<Expression> or = DefaultSdkAutoConstructList.getInstance();

        private Expression not;

        private ExpressionFilter costCategories;

        private ExpressionFilter dimensions;

        private ExpressionFilter tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            and(model.and);
            or(model.or);
            not(model.not);
            costCategories(model.costCategories);
            dimensions(model.dimensions);
            tags(model.tags);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = ExpressionListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = ExpressionListCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Expression> and) {
            this.and = ExpressionListCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Expression... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder>... and) {
            and(Stream.of(and).map(c -> Expression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = ExpressionListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = ExpressionListCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Expression> or) {
            this.or = ExpressionListCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Expression... or) {
            or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder>... or) {
            or(Stream.of(or).map(c -> Expression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Builder getNot() {
            return not != null ? not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            this.not = not != null ? not.build() : null;
        }

        @Override
        public final Builder not(Expression not) {
            this.not = not;
            return this;
        }

        public final ExpressionFilter.Builder getCostCategories() {
            return costCategories != null ? costCategories.toBuilder() : null;
        }

        public final void setCostCategories(ExpressionFilter.BuilderImpl costCategories) {
            this.costCategories = costCategories != null ? costCategories.build() : null;
        }

        @Override
        public final Builder costCategories(ExpressionFilter costCategories) {
            this.costCategories = costCategories;
            return this;
        }

        public final ExpressionFilter.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        public final void setDimensions(ExpressionFilter.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(ExpressionFilter dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final ExpressionFilter.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(ExpressionFilter.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(ExpressionFilter tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
