/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBillEstimatesRequest extends BcmPricingCalculatorRequest implements
        ToCopyableBuilder<ListBillEstimatesRequest.Builder, ListBillEstimatesRequest> {
    private static final SdkField<List<ListBillEstimatesFilter>> FILTERS_FIELD = SdkField
            .<List<ListBillEstimatesFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListBillEstimatesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListBillEstimatesFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListBillEstimatesFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterTimestamp> CREATED_AT_FILTER_FIELD = SdkField
            .<FilterTimestamp> builder(MarshallingType.SDK_POJO).memberName("createdAtFilter")
            .getter(getter(ListBillEstimatesRequest::createdAtFilter)).setter(setter(Builder::createdAtFilter))
            .constructor(FilterTimestamp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAtFilter").build()).build();

    private static final SdkField<FilterTimestamp> EXPIRES_AT_FILTER_FIELD = SdkField
            .<FilterTimestamp> builder(MarshallingType.SDK_POJO).memberName("expiresAtFilter")
            .getter(getter(ListBillEstimatesRequest::expiresAtFilter)).setter(setter(Builder::expiresAtFilter))
            .constructor(FilterTimestamp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAtFilter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBillEstimatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBillEstimatesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            CREATED_AT_FILTER_FIELD, EXPIRES_AT_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("filters", FILTERS_FIELD);
                    put("createdAtFilter", CREATED_AT_FILTER_FIELD);
                    put("expiresAtFilter", EXPIRES_AT_FILTER_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                }
            });

    private final List<ListBillEstimatesFilter> filters;

    private final FilterTimestamp createdAtFilter;

    private final FilterTimestamp expiresAtFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListBillEstimatesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.createdAtFilter = builder.createdAtFilter;
        this.expiresAtFilter = builder.expiresAtFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters to apply to the list of bill estimates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters to apply to the list of bill estimates.
     */
    public final List<ListBillEstimatesFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Filter bill estimates based on their creation date.
     * </p>
     * 
     * @return Filter bill estimates based on their creation date.
     */
    public final FilterTimestamp createdAtFilter() {
        return createdAtFilter;
    }

    /**
     * <p>
     * Filter bill estimates based on their expiration date.
     * </p>
     * 
     * @return Filter bill estimates based on their expiration date.
     */
    public final FilterTimestamp expiresAtFilter() {
        return expiresAtFilter;
    }

    /**
     * <p>
     * A token to retrieve the next page of results.
     * </p>
     * 
     * @return A token to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAtFilter());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAtFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillEstimatesRequest)) {
            return false;
        }
        ListBillEstimatesRequest other = (ListBillEstimatesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(createdAtFilter(), other.createdAtFilter())
                && Objects.equals(expiresAtFilter(), other.expiresAtFilter()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBillEstimatesRequest").add("Filters", hasFilters() ? filters() : null)
                .add("CreatedAtFilter", createdAtFilter()).add("ExpiresAtFilter", expiresAtFilter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "createdAtFilter":
            return Optional.ofNullable(clazz.cast(createdAtFilter()));
        case "expiresAtFilter":
            return Optional.ofNullable(clazz.cast(expiresAtFilter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBillEstimatesRequest, T> g) {
        return obj -> g.apply((ListBillEstimatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBillEstimatesRequest> {
        /**
         * <p>
         * Filters to apply to the list of bill estimates.
         * </p>
         * 
         * @param filters
         *        Filters to apply to the list of bill estimates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ListBillEstimatesFilter> filters);

        /**
         * <p>
         * Filters to apply to the list of bill estimates.
         * </p>
         * 
         * @param filters
         *        Filters to apply to the list of bill estimates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListBillEstimatesFilter... filters);

        /**
         * <p>
         * Filters to apply to the list of bill estimates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesFilter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<ListBillEstimatesFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<ListBillEstimatesFilter>)
         */
        Builder filters(Consumer<ListBillEstimatesFilter.Builder>... filters);

        /**
         * <p>
         * Filter bill estimates based on their creation date.
         * </p>
         * 
         * @param createdAtFilter
         *        Filter bill estimates based on their creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAtFilter(FilterTimestamp createdAtFilter);

        /**
         * <p>
         * Filter bill estimates based on their creation date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterTimestamp.Builder} avoiding the
         * need to create one manually via {@link FilterTimestamp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterTimestamp.Builder#build()} is called immediately and its
         * result is passed to {@link #createdAtFilter(FilterTimestamp)}.
         * 
         * @param createdAtFilter
         *        a consumer that will call methods on {@link FilterTimestamp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdAtFilter(FilterTimestamp)
         */
        default Builder createdAtFilter(Consumer<FilterTimestamp.Builder> createdAtFilter) {
            return createdAtFilter(FilterTimestamp.builder().applyMutation(createdAtFilter).build());
        }

        /**
         * <p>
         * Filter bill estimates based on their expiration date.
         * </p>
         * 
         * @param expiresAtFilter
         *        Filter bill estimates based on their expiration date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAtFilter(FilterTimestamp expiresAtFilter);

        /**
         * <p>
         * Filter bill estimates based on their expiration date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterTimestamp.Builder} avoiding the
         * need to create one manually via {@link FilterTimestamp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterTimestamp.Builder#build()} is called immediately and its
         * result is passed to {@link #expiresAtFilter(FilterTimestamp)}.
         * 
         * @param expiresAtFilter
         *        a consumer that will call methods on {@link FilterTimestamp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expiresAtFilter(FilterTimestamp)
         */
        default Builder expiresAtFilter(Consumer<FilterTimestamp.Builder> expiresAtFilter) {
            return expiresAtFilter(FilterTimestamp.builder().applyMutation(expiresAtFilter).build());
        }

        /**
         * <p>
         * A token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private List<ListBillEstimatesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private FilterTimestamp createdAtFilter;

        private FilterTimestamp expiresAtFilter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillEstimatesRequest model) {
            super(model);
            filters(model.filters);
            createdAtFilter(model.createdAtFilter);
            expiresAtFilter(model.expiresAtFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final List<ListBillEstimatesFilter.Builder> getFilters() {
            List<ListBillEstimatesFilter.Builder> result = ListBillEstimatesFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ListBillEstimatesFilter.BuilderImpl> filters) {
            this.filters = ListBillEstimatesFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ListBillEstimatesFilter> filters) {
            this.filters = ListBillEstimatesFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListBillEstimatesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListBillEstimatesFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ListBillEstimatesFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FilterTimestamp.Builder getCreatedAtFilter() {
            return createdAtFilter != null ? createdAtFilter.toBuilder() : null;
        }

        public final void setCreatedAtFilter(FilterTimestamp.BuilderImpl createdAtFilter) {
            this.createdAtFilter = createdAtFilter != null ? createdAtFilter.build() : null;
        }

        @Override
        public final Builder createdAtFilter(FilterTimestamp createdAtFilter) {
            this.createdAtFilter = createdAtFilter;
            return this;
        }

        public final FilterTimestamp.Builder getExpiresAtFilter() {
            return expiresAtFilter != null ? expiresAtFilter.toBuilder() : null;
        }

        public final void setExpiresAtFilter(FilterTimestamp.BuilderImpl expiresAtFilter) {
            this.expiresAtFilter = expiresAtFilter != null ? expiresAtFilter.build() : null;
        }

        @Override
        public final Builder expiresAtFilter(FilterTimestamp expiresAtFilter) {
            this.expiresAtFilter = expiresAtFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBillEstimatesRequest build() {
            return new ListBillEstimatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
