/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePreferencesResponse extends BcmPricingCalculatorResponse implements
        ToCopyableBuilder<UpdatePreferencesResponse.Builder, UpdatePreferencesResponse> {
    private static final SdkField<List<String>> MANAGEMENT_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managementAccountRateTypeSelections")
            .getter(getter(UpdatePreferencesResponse::managementAccountRateTypeSelectionsAsStrings))
            .setter(setter(Builder::managementAccountRateTypeSelectionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("managementAccountRateTypeSelections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MEMBER_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("memberAccountRateTypeSelections")
            .getter(getter(UpdatePreferencesResponse::memberAccountRateTypeSelectionsAsStrings))
            .setter(setter(Builder::memberAccountRateTypeSelectionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountRateTypeSelections")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MANAGEMENT_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD, MEMBER_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("managementAccountRateTypeSelections", MANAGEMENT_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD);
                    put("memberAccountRateTypeSelections", MEMBER_ACCOUNT_RATE_TYPE_SELECTIONS_FIELD);
                }
            });

    private final List<String> managementAccountRateTypeSelections;

    private final List<String> memberAccountRateTypeSelections;

    private UpdatePreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.managementAccountRateTypeSelections = builder.managementAccountRateTypeSelections;
        this.memberAccountRateTypeSelections = builder.memberAccountRateTypeSelections;
    }

    /**
     * <p>
     * The updated preferred rate types for the management account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagementAccountRateTypeSelections}
     * method.
     * </p>
     * 
     * @return The updated preferred rate types for the management account.
     */
    public final List<RateType> managementAccountRateTypeSelections() {
        return RateTypesCopier.copyStringToEnum(managementAccountRateTypeSelections);
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagementAccountRateTypeSelections
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasManagementAccountRateTypeSelections() {
        return managementAccountRateTypeSelections != null
                && !(managementAccountRateTypeSelections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated preferred rate types for the management account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagementAccountRateTypeSelections}
     * method.
     * </p>
     * 
     * @return The updated preferred rate types for the management account.
     */
    public final List<String> managementAccountRateTypeSelectionsAsStrings() {
        return managementAccountRateTypeSelections;
    }

    /**
     * <p>
     * The updated preferred rate types for member accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAccountRateTypeSelections}
     * method.
     * </p>
     * 
     * @return The updated preferred rate types for member accounts.
     */
    public final List<RateType> memberAccountRateTypeSelections() {
        return RateTypesCopier.copyStringToEnum(memberAccountRateTypeSelections);
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberAccountRateTypeSelections
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMemberAccountRateTypeSelections() {
        return memberAccountRateTypeSelections != null && !(memberAccountRateTypeSelections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated preferred rate types for member accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAccountRateTypeSelections}
     * method.
     * </p>
     * 
     * @return The updated preferred rate types for member accounts.
     */
    public final List<String> memberAccountRateTypeSelectionsAsStrings() {
        return memberAccountRateTypeSelections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasManagementAccountRateTypeSelections() ? managementAccountRateTypeSelectionsAsStrings()
                        : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMemberAccountRateTypeSelections() ? memberAccountRateTypeSelectionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePreferencesResponse)) {
            return false;
        }
        UpdatePreferencesResponse other = (UpdatePreferencesResponse) obj;
        return hasManagementAccountRateTypeSelections() == other.hasManagementAccountRateTypeSelections()
                && Objects.equals(managementAccountRateTypeSelectionsAsStrings(),
                        other.managementAccountRateTypeSelectionsAsStrings())
                && hasMemberAccountRateTypeSelections() == other.hasMemberAccountRateTypeSelections()
                && Objects.equals(memberAccountRateTypeSelectionsAsStrings(), other.memberAccountRateTypeSelectionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdatePreferencesResponse")
                .add("ManagementAccountRateTypeSelections",
                        hasManagementAccountRateTypeSelections() ? managementAccountRateTypeSelectionsAsStrings() : null)
                .add("MemberAccountRateTypeSelections",
                        hasMemberAccountRateTypeSelections() ? memberAccountRateTypeSelectionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "managementAccountRateTypeSelections":
            return Optional.ofNullable(clazz.cast(managementAccountRateTypeSelectionsAsStrings()));
        case "memberAccountRateTypeSelections":
            return Optional.ofNullable(clazz.cast(memberAccountRateTypeSelectionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePreferencesResponse, T> g) {
        return obj -> g.apply((UpdatePreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePreferencesResponse> {
        /**
         * <p>
         * The updated preferred rate types for the management account.
         * </p>
         * 
         * @param managementAccountRateTypeSelections
         *        The updated preferred rate types for the management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementAccountRateTypeSelectionsWithStrings(Collection<String> managementAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for the management account.
         * </p>
         * 
         * @param managementAccountRateTypeSelections
         *        The updated preferred rate types for the management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementAccountRateTypeSelectionsWithStrings(String... managementAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for the management account.
         * </p>
         * 
         * @param managementAccountRateTypeSelections
         *        The updated preferred rate types for the management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementAccountRateTypeSelections(Collection<RateType> managementAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for the management account.
         * </p>
         * 
         * @param managementAccountRateTypeSelections
         *        The updated preferred rate types for the management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementAccountRateTypeSelections(RateType... managementAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for member accounts.
         * </p>
         * 
         * @param memberAccountRateTypeSelections
         *        The updated preferred rate types for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountRateTypeSelectionsWithStrings(Collection<String> memberAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for member accounts.
         * </p>
         * 
         * @param memberAccountRateTypeSelections
         *        The updated preferred rate types for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountRateTypeSelectionsWithStrings(String... memberAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for member accounts.
         * </p>
         * 
         * @param memberAccountRateTypeSelections
         *        The updated preferred rate types for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountRateTypeSelections(Collection<RateType> memberAccountRateTypeSelections);

        /**
         * <p>
         * The updated preferred rate types for member accounts.
         * </p>
         * 
         * @param memberAccountRateTypeSelections
         *        The updated preferred rate types for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountRateTypeSelections(RateType... memberAccountRateTypeSelections);
    }

    static final class BuilderImpl extends BcmPricingCalculatorResponse.BuilderImpl implements Builder {
        private List<String> managementAccountRateTypeSelections = DefaultSdkAutoConstructList.getInstance();

        private List<String> memberAccountRateTypeSelections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePreferencesResponse model) {
            super(model);
            managementAccountRateTypeSelectionsWithStrings(model.managementAccountRateTypeSelections);
            memberAccountRateTypeSelectionsWithStrings(model.memberAccountRateTypeSelections);
        }

        public final Collection<String> getManagementAccountRateTypeSelections() {
            if (managementAccountRateTypeSelections instanceof SdkAutoConstructList) {
                return null;
            }
            return managementAccountRateTypeSelections;
        }

        public final void setManagementAccountRateTypeSelections(Collection<String> managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections = RateTypesCopier.copy(managementAccountRateTypeSelections);
        }

        @Override
        public final Builder managementAccountRateTypeSelectionsWithStrings(Collection<String> managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections = RateTypesCopier.copy(managementAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managementAccountRateTypeSelectionsWithStrings(String... managementAccountRateTypeSelections) {
            managementAccountRateTypeSelectionsWithStrings(Arrays.asList(managementAccountRateTypeSelections));
            return this;
        }

        @Override
        public final Builder managementAccountRateTypeSelections(Collection<RateType> managementAccountRateTypeSelections) {
            this.managementAccountRateTypeSelections = RateTypesCopier.copyEnumToString(managementAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managementAccountRateTypeSelections(RateType... managementAccountRateTypeSelections) {
            managementAccountRateTypeSelections(Arrays.asList(managementAccountRateTypeSelections));
            return this;
        }

        public final Collection<String> getMemberAccountRateTypeSelections() {
            if (memberAccountRateTypeSelections instanceof SdkAutoConstructList) {
                return null;
            }
            return memberAccountRateTypeSelections;
        }

        public final void setMemberAccountRateTypeSelections(Collection<String> memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections = RateTypesCopier.copy(memberAccountRateTypeSelections);
        }

        @Override
        public final Builder memberAccountRateTypeSelectionsWithStrings(Collection<String> memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections = RateTypesCopier.copy(memberAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAccountRateTypeSelectionsWithStrings(String... memberAccountRateTypeSelections) {
            memberAccountRateTypeSelectionsWithStrings(Arrays.asList(memberAccountRateTypeSelections));
            return this;
        }

        @Override
        public final Builder memberAccountRateTypeSelections(Collection<RateType> memberAccountRateTypeSelections) {
            this.memberAccountRateTypeSelections = RateTypesCopier.copyEnumToString(memberAccountRateTypeSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAccountRateTypeSelections(RateType... memberAccountRateTypeSelections) {
            memberAccountRateTypeSelections(Arrays.asList(memberAccountRateTypeSelections));
            return this;
        }

        @Override
        public UpdatePreferencesResponse build() {
            return new UpdatePreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
