/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a usage quantity with associated unit and time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageQuantity implements SdkPojo, Serializable, ToCopyableBuilder<UsageQuantity.Builder, UsageQuantity> {
    private static final SdkField<Instant> START_HOUR_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startHour").getter(getter(UsageQuantity::startHour)).setter(setter(Builder::startHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startHour").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(UsageQuantity::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Double> AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("amount")
            .getter(getter(UsageQuantity::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_HOUR_FIELD, UNIT_FIELD,
            AMOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("startHour", START_HOUR_FIELD);
                    put("unit", UNIT_FIELD);
                    put("amount", AMOUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant startHour;

    private final String unit;

    private final Double amount;

    private UsageQuantity(BuilderImpl builder) {
        this.startHour = builder.startHour;
        this.unit = builder.unit;
        this.amount = builder.amount;
    }

    /**
     * <p>
     * The start hour of the usage period.
     * </p>
     * 
     * @return The start hour of the usage period.
     */
    public final Instant startHour() {
        return startHour;
    }

    /**
     * <p>
     * The unit of measurement for the usage quantity.
     * </p>
     * 
     * @return The unit of measurement for the usage quantity.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The numeric value of the usage quantity.
     * </p>
     * 
     * @return The numeric value of the usage quantity.
     */
    public final Double amount() {
        return amount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startHour());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageQuantity)) {
            return false;
        }
        UsageQuantity other = (UsageQuantity) obj;
        return Objects.equals(startHour(), other.startHour()) && Objects.equals(unit(), other.unit())
                && Objects.equals(amount(), other.amount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageQuantity").add("StartHour", startHour()).add("Unit", unit()).add("Amount", amount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startHour":
            return Optional.ofNullable(clazz.cast(startHour()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UsageQuantity, T> g) {
        return obj -> g.apply((UsageQuantity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageQuantity> {
        /**
         * <p>
         * The start hour of the usage period.
         * </p>
         * 
         * @param startHour
         *        The start hour of the usage period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startHour(Instant startHour);

        /**
         * <p>
         * The unit of measurement for the usage quantity.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the usage quantity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The numeric value of the usage quantity.
         * </p>
         * 
         * @param amount
         *        The numeric value of the usage quantity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);
    }

    static final class BuilderImpl implements Builder {
        private Instant startHour;

        private String unit;

        private Double amount;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageQuantity model) {
            startHour(model.startHour);
            unit(model.unit);
            amount(model.amount);
        }

        public final Instant getStartHour() {
            return startHour;
        }

        public final void setStartHour(Instant startHour) {
            this.startHour = startHour;
        }

        @Override
        public final Builder startHour(Instant startHour) {
            this.startHour = startHour;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Double getAmount() {
            return amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public UsageQuantity build() {
            return new UsageQuantity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
