/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioUsageModificationItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioUsageModificationItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillScenarioUsageModificationsResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, ListBillScenarioUsageModificationsResponse> {
    private static final SdkField<List<BillScenarioUsageModificationItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(ListBillScenarioUsageModificationsResponse.getter(ListBillScenarioUsageModificationsResponse::items)).setter(ListBillScenarioUsageModificationsResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BillScenarioUsageModificationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBillScenarioUsageModificationsResponse.getter(ListBillScenarioUsageModificationsResponse::nextToken)).setter(ListBillScenarioUsageModificationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("items", ITEMS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BillScenarioUsageModificationItem> items;
    private final String nextToken;

    private ListBillScenarioUsageModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<BillScenarioUsageModificationItem> items() {
        return this.items;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillScenarioUsageModificationsResponse)) {
            return false;
        }
        ListBillScenarioUsageModificationsResponse other = (ListBillScenarioUsageModificationsResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillScenarioUsageModificationsResponse").add("Items", this.hasItems() ? this.items() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBillScenarioUsageModificationsResponse, T> g) {
        return obj -> g.apply((ListBillScenarioUsageModificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private List<BillScenarioUsageModificationItem> items = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillScenarioUsageModificationsResponse model) {
            super(model);
            this.items(model.items);
            this.nextToken(model.nextToken);
        }

        public final List<BillScenarioUsageModificationItem.Builder> getItems() {
            List<BillScenarioUsageModificationItem.Builder> result = BillScenarioUsageModificationItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<BillScenarioUsageModificationItem.BuilderImpl> items) {
            this.items = BillScenarioUsageModificationItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<BillScenarioUsageModificationItem> items) {
            this.items = BillScenarioUsageModificationItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(BillScenarioUsageModificationItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<BillScenarioUsageModificationItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (BillScenarioUsageModificationItem)((BillScenarioUsageModificationItem.Builder)BillScenarioUsageModificationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBillScenarioUsageModificationsResponse build() {
            return new ListBillScenarioUsageModificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBillScenarioUsageModificationsResponse> {
        public Builder items(Collection<BillScenarioUsageModificationItem> var1);

        public Builder items(BillScenarioUsageModificationItem ... var1);

        public Builder items(Consumer<BillScenarioUsageModificationItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

