/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagsCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateRateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkloadEstimateRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, CreateWorkloadEstimateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorkloadEstimateRequest.getter(CreateWorkloadEstimateRequest::name)).setter(CreateWorkloadEstimateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWorkloadEstimateRequest.getter(CreateWorkloadEstimateRequest::clientToken)).setter(CreateWorkloadEstimateRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rateType").getter(CreateWorkloadEstimateRequest.getter(CreateWorkloadEstimateRequest::rateTypeAsString)).setter(CreateWorkloadEstimateRequest.setter(Builder::rateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkloadEstimateRequest.getter(CreateWorkloadEstimateRequest::tags)).setter(CreateWorkloadEstimateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLIENT_TOKEN_FIELD, RATE_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("rateType", RATE_TYPE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String clientToken;
    private final String rateType;
    private final Map<String, String> tags;

    private CreateWorkloadEstimateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.rateType = builder.rateType;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final WorkloadEstimateRateType rateType() {
        return WorkloadEstimateRateType.fromValue(this.rateType);
    }

    public final String rateTypeAsString() {
        return this.rateType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadEstimateRequest)) {
            return false;
        }
        CreateWorkloadEstimateRequest other = (CreateWorkloadEstimateRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.rateTypeAsString(), other.rateTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkloadEstimateRequest").add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).add("RateType", (Object)this.rateTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "rateType": {
                return Optional.ofNullable(clazz.cast(this.rateTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadEstimateRequest, T> g) {
        return obj -> g.apply((CreateWorkloadEstimateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private String name;
        private String clientToken;
        private String rateType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadEstimateRequest model) {
            super(model);
            this.name(model.name);
            this.clientToken(model.clientToken);
            this.rateType(model.rateType);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRateType() {
            return this.rateType;
        }

        public final void setRateType(String rateType) {
            this.rateType = rateType;
        }

        @Override
        public final Builder rateType(String rateType) {
            this.rateType = rateType;
            return this;
        }

        @Override
        public final Builder rateType(WorkloadEstimateRateType rateType) {
            this.rateType(rateType == null ? null : rateType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkloadEstimateRequest build() {
            return new CreateWorkloadEstimateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkloadEstimateRequest> {
        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder rateType(String var1);

        public Builder rateType(WorkloadEstimateRateType var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

