/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an entry in a batch operation to update bill scenario usage modifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateBillScenarioUsageModificationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateBillScenarioUsageModificationEntry.Builder, BatchUpdateBillScenarioUsageModificationEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BatchUpdateBillScenarioUsageModificationEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BatchUpdateBillScenarioUsageModificationEntry::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<List<UsageAmount>> AMOUNTS_FIELD = SdkField
            .<List<UsageAmount>> builder(MarshallingType.LIST)
            .memberName("amounts")
            .getter(getter(BatchUpdateBillScenarioUsageModificationEntry::amounts))
            .setter(setter(Builder::amounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageAmount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageAmount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, GROUP_FIELD,
            AMOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String group;

    private final List<UsageAmount> amounts;

    private BatchUpdateBillScenarioUsageModificationEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.group = builder.group;
        this.amounts = builder.amounts;
    }

    /**
     * <p>
     * The unique identifier of the usage modification to update.
     * </p>
     * 
     * @return The unique identifier of the usage modification to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The updated group identifier for the usage modification.
     * </p>
     * 
     * @return The updated group identifier for the usage modification.
     */
    public final String group() {
        return group;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmounts() {
        return amounts != null && !(amounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated usage amounts for the modification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmounts} method.
     * </p>
     * 
     * @return The updated usage amounts for the modification.
     */
    public final List<UsageAmount> amounts() {
        return amounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasAmounts() ? amounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioUsageModificationEntry)) {
            return false;
        }
        BatchUpdateBillScenarioUsageModificationEntry other = (BatchUpdateBillScenarioUsageModificationEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(group(), other.group()) && hasAmounts() == other.hasAmounts()
                && Objects.equals(amounts(), other.amounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateBillScenarioUsageModificationEntry").add("Id", id()).add("Group", group())
                .add("Amounts", hasAmounts() ? amounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "amounts":
            return Optional.ofNullable(clazz.cast(amounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("amounts", AMOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioUsageModificationEntry, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioUsageModificationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateBillScenarioUsageModificationEntry> {
        /**
         * <p>
         * The unique identifier of the usage modification to update.
         * </p>
         * 
         * @param id
         *        The unique identifier of the usage modification to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The updated group identifier for the usage modification.
         * </p>
         * 
         * @param group
         *        The updated group identifier for the usage modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The updated usage amounts for the modification.
         * </p>
         * 
         * @param amounts
         *        The updated usage amounts for the modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(Collection<UsageAmount> amounts);

        /**
         * <p>
         * The updated usage amounts for the modification.
         * </p>
         * 
         * @param amounts
         *        The updated usage amounts for the modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(UsageAmount... amounts);

        /**
         * <p>
         * The updated usage amounts for the modification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount.Builder#build()} is called
         * immediately and its result is passed to {@link #amounts(List<UsageAmount>)}.
         * 
         * @param amounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amounts(java.util.Collection<UsageAmount>)
         */
        Builder amounts(Consumer<UsageAmount.Builder>... amounts);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String group;

        private List<UsageAmount> amounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioUsageModificationEntry model) {
            id(model.id);
            group(model.group);
            amounts(model.amounts);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<UsageAmount.Builder> getAmounts() {
            List<UsageAmount.Builder> result = UsageAmountsCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<UsageAmount.BuilderImpl> amounts) {
            this.amounts = UsageAmountsCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<UsageAmount> amounts) {
            this.amounts = UsageAmountsCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(UsageAmount... amounts) {
            amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<UsageAmount.Builder>... amounts) {
            amounts(Stream.of(amounts).map(c -> UsageAmount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateBillScenarioUsageModificationEntry build() {
            return new BatchUpdateBillScenarioUsageModificationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
