/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Mixin for common fields returned by CRUD APIs
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkloadEstimateResponse extends BcmPricingCalculatorResponse implements
        ToCopyableBuilder<CreateWorkloadEstimateResponse.Builder, CreateWorkloadEstimateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateWorkloadEstimateResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkloadEstimateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateWorkloadEstimateResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(CreateWorkloadEstimateResponse::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final SdkField<String> RATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rateType").getter(getter(CreateWorkloadEstimateResponse::rateTypeAsString))
            .setter(setter(Builder::rateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateType").build()).build();

    private static final SdkField<Instant> RATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("rateTimestamp").getter(getter(CreateWorkloadEstimateResponse::rateTimestamp))
            .setter(setter(Builder::rateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateWorkloadEstimateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Double> TOTAL_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("totalCost").getter(getter(CreateWorkloadEstimateResponse::totalCost)).setter(setter(Builder::totalCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCost").build()).build();

    private static final SdkField<String> COST_CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("costCurrency").getter(getter(CreateWorkloadEstimateResponse::costCurrencyAsString))
            .setter(setter(Builder::costCurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCurrency").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(CreateWorkloadEstimateResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CREATED_AT_FIELD, EXPIRES_AT_FIELD, RATE_TYPE_FIELD, RATE_TIMESTAMP_FIELD, STATUS_FIELD, TOTAL_COST_FIELD,
            COST_CURRENCY_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final Instant createdAt;

    private final Instant expiresAt;

    private final String rateType;

    private final Instant rateTimestamp;

    private final String status;

    private final Double totalCost;

    private final String costCurrency;

    private final String failureMessage;

    private CreateWorkloadEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.rateType = builder.rateType;
        this.rateTimestamp = builder.rateTimestamp;
        this.status = builder.status;
        this.totalCost = builder.totalCost;
        this.costCurrency = builder.costCurrency;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The unique identifier for the created workload estimate.
     * </p>
     * 
     * @return The unique identifier for the created workload estimate.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the created workload estimate.
     * </p>
     * 
     * @return The name of the created workload estimate.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The timestamp when the workload estimate was created.
     * </p>
     * 
     * @return The timestamp when the workload estimate was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the workload estimate will expire.
     * </p>
     * 
     * @return The timestamp when the workload estimate will expire.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The type of pricing rates used for the estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateType} will
     * return {@link WorkloadEstimateRateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateTypeAsString}.
     * </p>
     * 
     * @return The type of pricing rates used for the estimate.
     * @see WorkloadEstimateRateType
     */
    public final WorkloadEstimateRateType rateType() {
        return WorkloadEstimateRateType.fromValue(rateType);
    }

    /**
     * <p>
     * The type of pricing rates used for the estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateType} will
     * return {@link WorkloadEstimateRateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateTypeAsString}.
     * </p>
     * 
     * @return The type of pricing rates used for the estimate.
     * @see WorkloadEstimateRateType
     */
    public final String rateTypeAsString() {
        return rateType;
    }

    /**
     * <p>
     * The timestamp of the pricing rates used for the estimate.
     * </p>
     * 
     * @return The timestamp of the pricing rates used for the estimate.
     */
    public final Instant rateTimestamp() {
        return rateTimestamp;
    }

    /**
     * <p>
     * The current status of the workload estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadEstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the workload estimate.
     * @see WorkloadEstimateStatus
     */
    public final WorkloadEstimateStatus status() {
        return WorkloadEstimateStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the workload estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadEstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the workload estimate.
     * @see WorkloadEstimateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The total estimated cost for the workload.
     * </p>
     * 
     * @return The total estimated cost for the workload.
     */
    public final Double totalCost() {
        return totalCost;
    }

    /**
     * <p>
     * The currency of the estimated cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #costCurrency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #costCurrencyAsString}.
     * </p>
     * 
     * @return The currency of the estimated cost.
     * @see CurrencyCode
     */
    public final CurrencyCode costCurrency() {
        return CurrencyCode.fromValue(costCurrency);
    }

    /**
     * <p>
     * The currency of the estimated cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #costCurrency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #costCurrencyAsString}.
     * </p>
     * 
     * @return The currency of the estimated cost.
     * @see CurrencyCode
     */
    public final String costCurrencyAsString() {
        return costCurrency;
    }

    /**
     * <p>
     * An error message if the workload estimate creation failed.
     * </p>
     * 
     * @return An error message if the workload estimate creation failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(rateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalCost());
        hashCode = 31 * hashCode + Objects.hashCode(costCurrencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadEstimateResponse)) {
            return false;
        }
        CreateWorkloadEstimateResponse other = (CreateWorkloadEstimateResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(expiresAt(), other.expiresAt())
                && Objects.equals(rateTypeAsString(), other.rateTypeAsString())
                && Objects.equals(rateTimestamp(), other.rateTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(totalCost(), other.totalCost())
                && Objects.equals(costCurrencyAsString(), other.costCurrencyAsString())
                && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkloadEstimateResponse").add("Id", id()).add("Name", name())
                .add("CreatedAt", createdAt()).add("ExpiresAt", expiresAt()).add("RateType", rateTypeAsString())
                .add("RateTimestamp", rateTimestamp()).add("Status", statusAsString()).add("TotalCost", totalCost())
                .add("CostCurrency", costCurrencyAsString()).add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "rateType":
            return Optional.ofNullable(clazz.cast(rateTypeAsString()));
        case "rateTimestamp":
            return Optional.ofNullable(clazz.cast(rateTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "totalCost":
            return Optional.ofNullable(clazz.cast(totalCost()));
        case "costCurrency":
            return Optional.ofNullable(clazz.cast(costCurrencyAsString()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("rateType", RATE_TYPE_FIELD);
        map.put("rateTimestamp", RATE_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("totalCost", TOTAL_COST_FIELD);
        map.put("costCurrency", COST_CURRENCY_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadEstimateResponse, T> g) {
        return obj -> g.apply((CreateWorkloadEstimateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BcmPricingCalculatorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkloadEstimateResponse> {
        /**
         * <p>
         * The unique identifier for the created workload estimate.
         * </p>
         * 
         * @param id
         *        The unique identifier for the created workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the created workload estimate.
         * </p>
         * 
         * @param name
         *        The name of the created workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The timestamp when the workload estimate was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the workload estimate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the workload estimate will expire.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp when the workload estimate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The type of pricing rates used for the estimate.
         * </p>
         * 
         * @param rateType
         *        The type of pricing rates used for the estimate.
         * @see WorkloadEstimateRateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateRateType
         */
        Builder rateType(String rateType);

        /**
         * <p>
         * The type of pricing rates used for the estimate.
         * </p>
         * 
         * @param rateType
         *        The type of pricing rates used for the estimate.
         * @see WorkloadEstimateRateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateRateType
         */
        Builder rateType(WorkloadEstimateRateType rateType);

        /**
         * <p>
         * The timestamp of the pricing rates used for the estimate.
         * </p>
         * 
         * @param rateTimestamp
         *        The timestamp of the pricing rates used for the estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateTimestamp(Instant rateTimestamp);

        /**
         * <p>
         * The current status of the workload estimate.
         * </p>
         * 
         * @param status
         *        The current status of the workload estimate.
         * @see WorkloadEstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the workload estimate.
         * </p>
         * 
         * @param status
         *        The current status of the workload estimate.
         * @see WorkloadEstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEstimateStatus
         */
        Builder status(WorkloadEstimateStatus status);

        /**
         * <p>
         * The total estimated cost for the workload.
         * </p>
         * 
         * @param totalCost
         *        The total estimated cost for the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCost(Double totalCost);

        /**
         * <p>
         * The currency of the estimated cost.
         * </p>
         * 
         * @param costCurrency
         *        The currency of the estimated cost.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder costCurrency(String costCurrency);

        /**
         * <p>
         * The currency of the estimated cost.
         * </p>
         * 
         * @param costCurrency
         *        The currency of the estimated cost.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder costCurrency(CurrencyCode costCurrency);

        /**
         * <p>
         * An error message if the workload estimate creation failed.
         * </p>
         * 
         * @param failureMessage
         *        An error message if the workload estimate creation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl extends BcmPricingCalculatorResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private Instant createdAt;

        private Instant expiresAt;

        private String rateType;

        private Instant rateTimestamp;

        private String status;

        private Double totalCost;

        private String costCurrency;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadEstimateResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            createdAt(model.createdAt);
            expiresAt(model.expiresAt);
            rateType(model.rateType);
            rateTimestamp(model.rateTimestamp);
            status(model.status);
            totalCost(model.totalCost);
            costCurrency(model.costCurrency);
            failureMessage(model.failureMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getRateType() {
            return rateType;
        }

        public final void setRateType(String rateType) {
            this.rateType = rateType;
        }

        @Override
        public final Builder rateType(String rateType) {
            this.rateType = rateType;
            return this;
        }

        @Override
        public final Builder rateType(WorkloadEstimateRateType rateType) {
            this.rateType(rateType == null ? null : rateType.toString());
            return this;
        }

        public final Instant getRateTimestamp() {
            return rateTimestamp;
        }

        public final void setRateTimestamp(Instant rateTimestamp) {
            this.rateTimestamp = rateTimestamp;
        }

        @Override
        public final Builder rateTimestamp(Instant rateTimestamp) {
            this.rateTimestamp = rateTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadEstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getTotalCost() {
            return totalCost;
        }

        public final void setTotalCost(Double totalCost) {
            this.totalCost = totalCost;
        }

        @Override
        public final Builder totalCost(Double totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public final String getCostCurrency() {
            return costCurrency;
        }

        public final void setCostCurrency(String costCurrency) {
            this.costCurrency = costCurrency;
        }

        @Override
        public final Builder costCurrency(String costCurrency) {
            this.costCurrency = costCurrency;
            return this;
        }

        @Override
        public final Builder costCurrency(CurrencyCode costCurrency) {
            this.costCurrency(costCurrency == null ? null : costCurrency.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public CreateWorkloadEstimateResponse build() {
            return new CreateWorkloadEstimateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
