/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bcmpricingcalculator.model.AccessDeniedException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ConflictException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DataUnavailableException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.InternalServerException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ThrottlingException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ValidationException;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable;
import software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable;

/**
 * Service client for accessing AWS Billing and Cost Management Pricing Calculator. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * You can use the Pricing Calculator API to programmatically create estimates for your planned cloud use. You can model
 * usage and commitments such as Savings Plans and Reserved Instances, and generate estimated costs using your discounts
 * and benefit sharing preferences.
 * </p>
 * <p>
 * The Pricing Calculator API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://bcm-pricing-calculator.us-east-1.api.aws</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BcmPricingCalculatorClient extends AwsClient {
    String SERVICE_NAME = "bcm-pricing-calculator";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bcm-pricing-calculator";

    /**
     * <p>
     * Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved Instances commitments that you want to
     * model in a Bill Scenario.
     * </p>
     *
     * @param batchCreateBillScenarioCommitmentModificationRequest
     * @return Result of the BatchCreateBillScenarioCommitmentModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateBillScenarioCommitmentModificationResponse batchCreateBillScenarioCommitmentModification(
            BatchCreateBillScenarioCommitmentModificationRequest batchCreateBillScenarioCommitmentModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved Instances commitments that you want to
     * model in a Bill Scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchCreateBillScenarioCommitmentModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchCreateBillScenarioCommitmentModificationRequest#builder()}
     * </p>
     *
     * @param batchCreateBillScenarioCommitmentModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchCreateBillScenarioCommitmentModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateBillScenarioCommitmentModificationResponse batchCreateBillScenarioCommitmentModification(
            Consumer<BatchCreateBillScenarioCommitmentModificationRequest.Builder> batchCreateBillScenarioCommitmentModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return batchCreateBillScenarioCommitmentModification(BatchCreateBillScenarioCommitmentModificationRequest.builder()
                .applyMutation(batchCreateBillScenarioCommitmentModificationRequest).build());
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Bill Scenario.
     * </p>
     *
     * @param batchCreateBillScenarioUsageModificationRequest
     * @return Result of the BatchCreateBillScenarioUsageModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateBillScenarioUsageModificationResponse batchCreateBillScenarioUsageModification(
            BatchCreateBillScenarioUsageModificationRequest batchCreateBillScenarioUsageModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Bill Scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchCreateBillScenarioUsageModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchCreateBillScenarioUsageModificationRequest#builder()}
     * </p>
     *
     * @param batchCreateBillScenarioUsageModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchCreateBillScenarioUsageModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateBillScenarioUsageModificationResponse batchCreateBillScenarioUsageModification(
            Consumer<BatchCreateBillScenarioUsageModificationRequest.Builder> batchCreateBillScenarioUsageModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return batchCreateBillScenarioUsageModification(BatchCreateBillScenarioUsageModificationRequest.builder()
                .applyMutation(batchCreateBillScenarioUsageModificationRequest).build());
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Workload Estimate.
     * </p>
     *
     * @param batchCreateWorkloadEstimateUsageRequest
     * @return Result of the BatchCreateWorkloadEstimateUsage operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateWorkloadEstimateUsageResponse batchCreateWorkloadEstimateUsage(
            BatchCreateWorkloadEstimateUsageRequest batchCreateWorkloadEstimateUsageRequest) throws ConflictException,
            ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Workload Estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateWorkloadEstimateUsageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCreateWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param batchCreateWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return Result of the BatchCreateWorkloadEstimateUsage operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateWorkloadEstimateUsageResponse batchCreateWorkloadEstimateUsage(
            Consumer<BatchCreateWorkloadEstimateUsageRequest.Builder> batchCreateWorkloadEstimateUsageRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return batchCreateWorkloadEstimateUsage(BatchCreateWorkloadEstimateUsageRequest.builder()
                .applyMutation(batchCreateWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Delete commitment that you have created in a Bill Scenario. You can only delete a commitment that you had added
     * and cannot model deletion (or removal) of a existing commitment. If you want model deletion of an existing
     * commitment, see the negate <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html"
     * > BillScenarioCommitmentModificationAction</a> of <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html"
     * > BatchCreateBillScenarioCommitmentModification</a> operation.
     * </p>
     *
     * @param batchDeleteBillScenarioCommitmentModificationRequest
     * @return Result of the BatchDeleteBillScenarioCommitmentModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteBillScenarioCommitmentModificationResponse batchDeleteBillScenarioCommitmentModification(
            BatchDeleteBillScenarioCommitmentModificationRequest batchDeleteBillScenarioCommitmentModificationRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete commitment that you have created in a Bill Scenario. You can only delete a commitment that you had added
     * and cannot model deletion (or removal) of a existing commitment. If you want model deletion of an existing
     * commitment, see the negate <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html"
     * > BillScenarioCommitmentModificationAction</a> of <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html"
     * > BatchCreateBillScenarioCommitmentModification</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDeleteBillScenarioCommitmentModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDeleteBillScenarioCommitmentModificationRequest#builder()}
     * </p>
     *
     * @param batchDeleteBillScenarioCommitmentModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchDeleteBillScenarioCommitmentModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteBillScenarioCommitmentModificationResponse batchDeleteBillScenarioCommitmentModification(
            Consumer<BatchDeleteBillScenarioCommitmentModificationRequest.Builder> batchDeleteBillScenarioCommitmentModificationRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return batchDeleteBillScenarioCommitmentModification(BatchDeleteBillScenarioCommitmentModificationRequest.builder()
                .applyMutation(batchDeleteBillScenarioCommitmentModificationRequest).build());
    }

    /**
     * <p>
     * Delete usage that you have created in a Bill Scenario. You can only delete usage that you had added and cannot
     * model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html"
     * > BatchUpdateBillScenarioUsageModification</a>.
     * </p>
     *
     * @param batchDeleteBillScenarioUsageModificationRequest
     * @return Result of the BatchDeleteBillScenarioUsageModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteBillScenarioUsageModificationResponse batchDeleteBillScenarioUsageModification(
            BatchDeleteBillScenarioUsageModificationRequest batchDeleteBillScenarioUsageModificationRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete usage that you have created in a Bill Scenario. You can only delete usage that you had added and cannot
     * model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html"
     * > BatchUpdateBillScenarioUsageModification</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDeleteBillScenarioUsageModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDeleteBillScenarioUsageModificationRequest#builder()}
     * </p>
     *
     * @param batchDeleteBillScenarioUsageModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchDeleteBillScenarioUsageModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteBillScenarioUsageModificationResponse batchDeleteBillScenarioUsageModification(
            Consumer<BatchDeleteBillScenarioUsageModificationRequest.Builder> batchDeleteBillScenarioUsageModificationRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return batchDeleteBillScenarioUsageModification(BatchDeleteBillScenarioUsageModificationRequest.builder()
                .applyMutation(batchDeleteBillScenarioUsageModificationRequest).build());
    }

    /**
     * <p>
     * Delete usage that you have created in a Workload estimate. You can only delete usage that you had added and
     * cannot model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a
     * href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html"
     * > BatchUpdateWorkloadEstimateUsage</a>.
     * </p>
     *
     * @param batchDeleteWorkloadEstimateUsageRequest
     * @return Result of the BatchDeleteWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteWorkloadEstimateUsageResponse batchDeleteWorkloadEstimateUsage(
            BatchDeleteWorkloadEstimateUsageRequest batchDeleteWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete usage that you have created in a Workload estimate. You can only delete usage that you had added and
     * cannot model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a
     * href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html"
     * > BatchUpdateWorkloadEstimateUsage</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteWorkloadEstimateUsageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param batchDeleteWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return Result of the BatchDeleteWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteWorkloadEstimateUsageResponse batchDeleteWorkloadEstimateUsage(
            Consumer<BatchDeleteWorkloadEstimateUsageRequest.Builder> batchDeleteWorkloadEstimateUsageRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return batchDeleteWorkloadEstimateUsage(BatchDeleteWorkloadEstimateUsageRequest.builder()
                .applyMutation(batchDeleteWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Update a newly added or existing commitment. You can update the commitment group based on a commitment ID and a
     * Bill scenario ID.
     * </p>
     *
     * @param batchUpdateBillScenarioCommitmentModificationRequest
     * @return Result of the BatchUpdateBillScenarioCommitmentModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateBillScenarioCommitmentModificationResponse batchUpdateBillScenarioCommitmentModification(
            BatchUpdateBillScenarioCommitmentModificationRequest batchUpdateBillScenarioCommitmentModificationRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a newly added or existing commitment. You can update the commitment group based on a commitment ID and a
     * Bill scenario ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateBillScenarioCommitmentModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateBillScenarioCommitmentModificationRequest#builder()}
     * </p>
     *
     * @param batchUpdateBillScenarioCommitmentModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateBillScenarioCommitmentModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateBillScenarioCommitmentModificationResponse batchUpdateBillScenarioCommitmentModification(
            Consumer<BatchUpdateBillScenarioCommitmentModificationRequest.Builder> batchUpdateBillScenarioCommitmentModificationRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return batchUpdateBillScenarioCommitmentModification(BatchUpdateBillScenarioCommitmentModificationRequest.builder()
                .applyMutation(batchUpdateBillScenarioCommitmentModificationRequest).build());
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts, usage hour, and usage group based
     * on a usage ID and a Bill scenario ID.
     * </p>
     *
     * @param batchUpdateBillScenarioUsageModificationRequest
     * @return Result of the BatchUpdateBillScenarioUsageModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateBillScenarioUsageModificationResponse batchUpdateBillScenarioUsageModification(
            BatchUpdateBillScenarioUsageModificationRequest batchUpdateBillScenarioUsageModificationRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts, usage hour, and usage group based
     * on a usage ID and a Bill scenario ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateBillScenarioUsageModificationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateBillScenarioUsageModificationRequest#builder()}
     * </p>
     *
     * @param batchUpdateBillScenarioUsageModificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateBillScenarioUsageModification operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateBillScenarioUsageModificationResponse batchUpdateBillScenarioUsageModification(
            Consumer<BatchUpdateBillScenarioUsageModificationRequest.Builder> batchUpdateBillScenarioUsageModificationRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return batchUpdateBillScenarioUsageModification(BatchUpdateBillScenarioUsageModificationRequest.builder()
                .applyMutation(batchUpdateBillScenarioUsageModificationRequest).build());
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts and usage group based on a usage
     * ID and a Workload estimate ID.
     * </p>
     *
     * @param batchUpdateWorkloadEstimateUsageRequest
     * @return Result of the BatchUpdateWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateWorkloadEstimateUsageResponse batchUpdateWorkloadEstimateUsage(
            BatchUpdateWorkloadEstimateUsageRequest batchUpdateWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts and usage group based on a usage
     * ID and a Workload estimate ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateWorkloadEstimateUsageRequest.Builder}
     * avoiding the need to create one manually via {@link BatchUpdateWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param batchUpdateWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateWorkloadEstimateUsageResponse batchUpdateWorkloadEstimateUsage(
            Consumer<BatchUpdateWorkloadEstimateUsageRequest.Builder> batchUpdateWorkloadEstimateUsageRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return batchUpdateWorkloadEstimateUsage(BatchUpdateWorkloadEstimateUsageRequest.builder()
                .applyMutation(batchUpdateWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Create a Bill estimate from a Bill scenario. In the Bill scenario you can model usage addition, usage changes,
     * and usage removal. You can also model commitment addition and commitment removal. After all changes in a Bill
     * scenario is made satisfactorily, you can call this API with a Bill scenario ID to generate the Bill estimate.
     * Bill estimate calculates the pre-tax cost for your consolidated billing family, incorporating all modeled usage
     * and commitments alongside existing usage and commitments from your most recent completed anniversary bill, with
     * any applicable discounts applied.
     * </p>
     *
     * @param createBillEstimateRequest
     * @return Result of the CreateBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillEstimateResponse createBillEstimate(CreateBillEstimateRequest createBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a Bill estimate from a Bill scenario. In the Bill scenario you can model usage addition, usage changes,
     * and usage removal. You can also model commitment addition and commitment removal. After all changes in a Bill
     * scenario is made satisfactorily, you can call this API with a Bill scenario ID to generate the Bill estimate.
     * Bill estimate calculates the pre-tax cost for your consolidated billing family, incorporating all modeled usage
     * and commitments alongside existing usage and commitments from your most recent completed anniversary bill, with
     * any applicable discounts applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillEstimateRequest#builder()}
     * </p>
     *
     * @param createBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateRequest.Builder} to
     *        create a request.
     * @return Result of the CreateBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillEstimateResponse createBillEstimate(Consumer<CreateBillEstimateRequest.Builder> createBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return createBillEstimate(CreateBillEstimateRequest.builder().applyMutation(createBillEstimateRequest).build());
    }

    /**
     * <p>
     * Creates a new bill scenario to model potential changes to Amazon Web Services usage and costs.
     * </p>
     *
     * @param createBillScenarioRequest
     * @return Result of the CreateBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillScenarioResponse createBillScenario(CreateBillScenarioRequest createBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new bill scenario to model potential changes to Amazon Web Services usage and costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillScenarioRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillScenarioRequest#builder()}
     * </p>
     *
     * @param createBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioRequest.Builder} to
     *        create a request.
     * @return Result of the CreateBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillScenarioResponse createBillScenario(Consumer<CreateBillScenarioRequest.Builder> createBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return createBillScenario(CreateBillScenarioRequest.builder().applyMutation(createBillScenarioRequest).build());
    }

    /**
     * <p>
     * Creates a new workload estimate to model costs for a specific workload.
     * </p>
     *
     * @param createWorkloadEstimateRequest
     * @return Result of the CreateWorkloadEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadEstimateResponse createWorkloadEstimate(CreateWorkloadEstimateRequest createWorkloadEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workload estimate to model costs for a specific workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param createWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateRequest.Builder}
     *        to create a request.
     * @return Result of the CreateWorkloadEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadEstimateResponse createWorkloadEstimate(
            Consumer<CreateWorkloadEstimateRequest.Builder> createWorkloadEstimateRequest) throws ConflictException,
            ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return createWorkloadEstimate(CreateWorkloadEstimateRequest.builder().applyMutation(createWorkloadEstimateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing bill estimate.
     * </p>
     *
     * @param deleteBillEstimateRequest
     * @return Result of the DeleteBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBillEstimateResponse deleteBillEstimate(DeleteBillEstimateRequest deleteBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillEstimateRequest#builder()}
     * </p>
     *
     * @param deleteBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBillEstimateResponse deleteBillEstimate(Consumer<DeleteBillEstimateRequest.Builder> deleteBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return deleteBillEstimate(DeleteBillEstimateRequest.builder().applyMutation(deleteBillEstimateRequest).build());
    }

    /**
     * <p>
     * Deletes an existing bill scenario.
     * </p>
     *
     * @param deleteBillScenarioRequest
     * @return Result of the DeleteBillScenario operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBillScenarioResponse deleteBillScenario(DeleteBillScenarioRequest deleteBillScenarioRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillScenarioRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillScenarioRequest#builder()}
     * </p>
     *
     * @param deleteBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBillScenario operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBillScenarioResponse deleteBillScenario(Consumer<DeleteBillScenarioRequest.Builder> deleteBillScenarioRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return deleteBillScenario(DeleteBillScenarioRequest.builder().applyMutation(deleteBillScenarioRequest).build());
    }

    /**
     * <p>
     * Deletes an existing workload estimate.
     * </p>
     *
     * @param deleteWorkloadEstimateRequest
     * @return Result of the DeleteWorkloadEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadEstimateResponse deleteWorkloadEstimate(DeleteWorkloadEstimateRequest deleteWorkloadEstimateRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteWorkloadEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadEstimateResponse deleteWorkloadEstimate(
            Consumer<DeleteWorkloadEstimateRequest.Builder> deleteWorkloadEstimateRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return deleteWorkloadEstimate(DeleteWorkloadEstimateRequest.builder().applyMutation(deleteWorkloadEstimateRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves details of a specific bill estimate.
     * </p>
     *
     * @param getBillEstimateRequest
     * @return Result of the GetBillEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillEstimateResponse getBillEstimate(GetBillEstimateRequest getBillEstimateRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillEstimateRequest.Builder} avoiding the need
     * to create one manually via {@link GetBillEstimateRequest#builder()}
     * </p>
     *
     * @param getBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateRequest.Builder} to
     *        create a request.
     * @return Result of the GetBillEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillEstimateResponse getBillEstimate(Consumer<GetBillEstimateRequest.Builder> getBillEstimateRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return getBillEstimate(GetBillEstimateRequest.builder().applyMutation(getBillEstimateRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a specific bill scenario.
     * </p>
     *
     * @param getBillScenarioRequest
     * @return Result of the GetBillScenario operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillScenarioResponse getBillScenario(GetBillScenarioRequest getBillScenarioRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillScenarioRequest.Builder} avoiding the need
     * to create one manually via {@link GetBillScenarioRequest#builder()}
     * </p>
     *
     * @param getBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioRequest.Builder} to
     *        create a request.
     * @return Result of the GetBillScenario operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBillScenarioResponse getBillScenario(Consumer<GetBillScenarioRequest.Builder> getBillScenarioRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return getBillScenario(GetBillScenarioRequest.builder().applyMutation(getBillScenarioRequest).build());
    }

    /**
     * <p>
     * Retrieves the current preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     *
     * @param getPreferencesRequest
     * @return Result of the GetPreferences operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPreferencesResponse getPreferences(GetPreferencesRequest getPreferencesRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPreferencesRequest.Builder} avoiding the need to
     * create one manually via {@link GetPreferencesRequest#builder()}
     * </p>
     *
     * @param getPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesRequest.Builder} to create
     *        a request.
     * @return Result of the GetPreferences operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPreferencesResponse getPreferences(Consumer<GetPreferencesRequest.Builder> getPreferencesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return getPreferences(GetPreferencesRequest.builder().applyMutation(getPreferencesRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a specific workload estimate.
     * </p>
     *
     * @param getWorkloadEstimateRequest
     * @return Result of the GetWorkloadEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadEstimateResponse getWorkloadEstimate(GetWorkloadEstimateRequest getWorkloadEstimateRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param getWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateRequest.Builder} to
     *        create a request.
     * @return Result of the GetWorkloadEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadEstimateResponse getWorkloadEstimate(
            Consumer<GetWorkloadEstimateRequest.Builder> getWorkloadEstimateRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return getWorkloadEstimate(GetWorkloadEstimateRequest.builder().applyMutation(getWorkloadEstimateRequest).build());
    }

    /**
     * <p>
     * Lists the commitments associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     * @return Result of the ListBillEstimateCommitments operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateCommitmentsResponse listBillEstimateCommitments(
            ListBillEstimateCommitmentsRequest listBillEstimateCommitmentsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commitments associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateCommitmentsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillEstimateCommitmentsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillEstimateCommitments operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateCommitmentsResponse listBillEstimateCommitments(
            Consumer<ListBillEstimateCommitmentsRequest.Builder> listBillEstimateCommitmentsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateCommitments(ListBillEstimateCommitmentsRequest.builder()
                .applyMutation(listBillEstimateCommitmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable responses = client.listBillEstimateCommitmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable responses = client
     *             .listBillEstimateCommitmentsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable responses = client.listBillEstimateCommitmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateCommitmentsIterable listBillEstimateCommitmentsPaginator(
            ListBillEstimateCommitmentsRequest listBillEstimateCommitmentsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillEstimateCommitmentsIterable(this, listBillEstimateCommitmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable responses = client.listBillEstimateCommitmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable responses = client
     *             .listBillEstimateCommitmentsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateCommitmentsIterable responses = client.listBillEstimateCommitmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateCommitments(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateCommitmentsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillEstimateCommitmentsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateCommitmentsIterable listBillEstimateCommitmentsPaginator(
            Consumer<ListBillEstimateCommitmentsRequest.Builder> listBillEstimateCommitmentsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateCommitmentsPaginator(ListBillEstimateCommitmentsRequest.builder()
                .applyMutation(listBillEstimateCommitmentsRequest).build());
    }

    /**
     * <p>
     * Lists the input commitment modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     * @return Result of the ListBillEstimateInputCommitmentModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputCommitmentModificationsResponse listBillEstimateInputCommitmentModifications(
            ListBillEstimateInputCommitmentModificationsRequest listBillEstimateInputCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the input commitment modifications associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillEstimateInputCommitmentModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputCommitmentModificationsResponse listBillEstimateInputCommitmentModifications(
            Consumer<ListBillEstimateInputCommitmentModificationsRequest.Builder> listBillEstimateInputCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateInputCommitmentModifications(ListBillEstimateInputCommitmentModificationsRequest.builder()
                .applyMutation(listBillEstimateInputCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable responses = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable responses = client
     *             .listBillEstimateInputCommitmentModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable responses = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputCommitmentModificationsIterable listBillEstimateInputCommitmentModificationsPaginator(
            ListBillEstimateInputCommitmentModificationsRequest listBillEstimateInputCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillEstimateInputCommitmentModificationsIterable(this, listBillEstimateInputCommitmentModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable responses = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable responses = client
     *             .listBillEstimateInputCommitmentModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputCommitmentModificationsIterable responses = client.listBillEstimateInputCommitmentModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputCommitmentModificationsIterable listBillEstimateInputCommitmentModificationsPaginator(
            Consumer<ListBillEstimateInputCommitmentModificationsRequest.Builder> listBillEstimateInputCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateInputCommitmentModificationsPaginator(ListBillEstimateInputCommitmentModificationsRequest
                .builder().applyMutation(listBillEstimateInputCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * Lists the input usage modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     * @return Result of the ListBillEstimateInputUsageModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputUsageModificationsResponse listBillEstimateInputUsageModifications(
            ListBillEstimateInputUsageModificationsRequest listBillEstimateInputUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the input usage modifications associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputUsageModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillEstimateInputUsageModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputUsageModificationsResponse listBillEstimateInputUsageModifications(
            Consumer<ListBillEstimateInputUsageModificationsRequest.Builder> listBillEstimateInputUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateInputUsageModifications(ListBillEstimateInputUsageModificationsRequest.builder()
                .applyMutation(listBillEstimateInputUsageModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable responses = client.listBillEstimateInputUsageModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable responses = client
     *             .listBillEstimateInputUsageModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable responses = client.listBillEstimateInputUsageModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputUsageModificationsIterable listBillEstimateInputUsageModificationsPaginator(
            ListBillEstimateInputUsageModificationsRequest listBillEstimateInputUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillEstimateInputUsageModificationsIterable(this, listBillEstimateInputUsageModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable responses = client.listBillEstimateInputUsageModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable responses = client
     *             .listBillEstimateInputUsageModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateInputUsageModificationsIterable responses = client.listBillEstimateInputUsageModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateInputUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillEstimateInputUsageModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillEstimateInputUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateInputUsageModificationsIterable listBillEstimateInputUsageModificationsPaginator(
            Consumer<ListBillEstimateInputUsageModificationsRequest.Builder> listBillEstimateInputUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateInputUsageModificationsPaginator(ListBillEstimateInputUsageModificationsRequest.builder()
                .applyMutation(listBillEstimateInputUsageModificationsRequest).build());
    }

    /**
     * <p>
     * Lists the line items associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     * @return Result of the ListBillEstimateLineItems operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateLineItemsResponse listBillEstimateLineItems(
            ListBillEstimateLineItemsRequest listBillEstimateLineItemsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the line items associated with a bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateLineItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBillEstimateLineItemsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillEstimateLineItems operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateLineItemsResponse listBillEstimateLineItems(
            Consumer<ListBillEstimateLineItemsRequest.Builder> listBillEstimateLineItemsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateLineItems(ListBillEstimateLineItemsRequest.builder()
                .applyMutation(listBillEstimateLineItemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable responses = client.listBillEstimateLineItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable responses = client
     *             .listBillEstimateLineItemsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable responses = client.listBillEstimateLineItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateLineItemsIterable listBillEstimateLineItemsPaginator(
            ListBillEstimateLineItemsRequest listBillEstimateLineItemsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillEstimateLineItemsIterable(this, listBillEstimateLineItemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable responses = client.listBillEstimateLineItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable responses = client
     *             .listBillEstimateLineItemsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimateLineItemsIterable responses = client.listBillEstimateLineItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimateLineItems(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimateLineItemsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBillEstimateLineItemsRequest#builder()}
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimateLineItemsIterable listBillEstimateLineItemsPaginator(
            Consumer<ListBillEstimateLineItemsRequest.Builder> listBillEstimateLineItemsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimateLineItemsPaginator(ListBillEstimateLineItemsRequest.builder()
                .applyMutation(listBillEstimateLineItemsRequest).build());
    }

    /**
     * <p>
     * Lists all bill estimates for the account.
     * </p>
     *
     * @param listBillEstimatesRequest
     * @return Result of the ListBillEstimates operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimatesResponse listBillEstimates(ListBillEstimatesRequest listBillEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all bill estimates for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillEstimatesRequest#builder()}
     * </p>
     *
     * @param listBillEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest.Builder} to
     *        create a request.
     * @return Result of the ListBillEstimates operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimatesResponse listBillEstimates(Consumer<ListBillEstimatesRequest.Builder> listBillEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillEstimates(ListBillEstimatesRequest.builder().applyMutation(listBillEstimatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable responses = client.listBillEstimatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable responses = client
     *             .listBillEstimatesPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable responses = client.listBillEstimatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillEstimatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimatesIterable listBillEstimatesPaginator(ListBillEstimatesRequest listBillEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillEstimatesIterable(this, listBillEstimatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable responses = client.listBillEstimatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable responses = client
     *             .listBillEstimatesPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillEstimatesIterable responses = client.listBillEstimatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillEstimatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillEstimatesRequest#builder()}
     * </p>
     *
     * @param listBillEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillEstimatesIterable listBillEstimatesPaginator(
            Consumer<ListBillEstimatesRequest.Builder> listBillEstimatesRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return listBillEstimatesPaginator(ListBillEstimatesRequest.builder().applyMutation(listBillEstimatesRequest).build());
    }

    /**
     * <p>
     * Lists the commitment modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     * @return Result of the ListBillScenarioCommitmentModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioCommitmentModificationsResponse listBillScenarioCommitmentModifications(
            ListBillScenarioCommitmentModificationsRequest listBillScenarioCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commitment modifications associated with a bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillScenarioCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillScenarioCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillScenarioCommitmentModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioCommitmentModificationsResponse listBillScenarioCommitmentModifications(
            Consumer<ListBillScenarioCommitmentModificationsRequest.Builder> listBillScenarioCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillScenarioCommitmentModifications(ListBillScenarioCommitmentModificationsRequest.builder()
                .applyMutation(listBillScenarioCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable responses = client.listBillScenarioCommitmentModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable responses = client
     *             .listBillScenarioCommitmentModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable responses = client.listBillScenarioCommitmentModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioCommitmentModificationsIterable listBillScenarioCommitmentModificationsPaginator(
            ListBillScenarioCommitmentModificationsRequest listBillScenarioCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillScenarioCommitmentModificationsIterable(this, listBillScenarioCommitmentModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable responses = client.listBillScenarioCommitmentModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable responses = client
     *             .listBillScenarioCommitmentModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioCommitmentModificationsIterable responses = client.listBillScenarioCommitmentModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioCommitmentModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBillScenarioCommitmentModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListBillScenarioCommitmentModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioCommitmentModificationsIterable listBillScenarioCommitmentModificationsPaginator(
            Consumer<ListBillScenarioCommitmentModificationsRequest.Builder> listBillScenarioCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillScenarioCommitmentModificationsPaginator(ListBillScenarioCommitmentModificationsRequest.builder()
                .applyMutation(listBillScenarioCommitmentModificationsRequest).build());
    }

    /**
     * <p>
     * Lists the usage modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     * @return Result of the ListBillScenarioUsageModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioUsageModificationsResponse listBillScenarioUsageModifications(
            ListBillScenarioUsageModificationsRequest listBillScenarioUsageModificationsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the usage modifications associated with a bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenarioUsageModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillScenarioUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillScenarioUsageModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioUsageModificationsResponse listBillScenarioUsageModifications(
            Consumer<ListBillScenarioUsageModificationsRequest.Builder> listBillScenarioUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillScenarioUsageModifications(ListBillScenarioUsageModificationsRequest.builder()
                .applyMutation(listBillScenarioUsageModificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable responses = client.listBillScenarioUsageModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable responses = client
     *             .listBillScenarioUsageModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable responses = client.listBillScenarioUsageModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioUsageModificationsIterable listBillScenarioUsageModificationsPaginator(
            ListBillScenarioUsageModificationsRequest listBillScenarioUsageModificationsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillScenarioUsageModificationsIterable(this, listBillScenarioUsageModificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable responses = client.listBillScenarioUsageModificationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable responses = client
     *             .listBillScenarioUsageModificationsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenarioUsageModificationsIterable responses = client.listBillScenarioUsageModificationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarioUsageModifications(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenarioUsageModificationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillScenarioUsageModificationsRequest#builder()}
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenarioUsageModificationsIterable listBillScenarioUsageModificationsPaginator(
            Consumer<ListBillScenarioUsageModificationsRequest.Builder> listBillScenarioUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillScenarioUsageModificationsPaginator(ListBillScenarioUsageModificationsRequest.builder()
                .applyMutation(listBillScenarioUsageModificationsRequest).build());
    }

    /**
     * <p>
     * Lists all bill scenarios for the account.
     * </p>
     *
     * @param listBillScenariosRequest
     * @return Result of the ListBillScenarios operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenariosResponse listBillScenarios(ListBillScenariosRequest listBillScenariosRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all bill scenarios for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenariosRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillScenariosRequest#builder()}
     * </p>
     *
     * @param listBillScenariosRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest.Builder} to
     *        create a request.
     * @return Result of the ListBillScenarios operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenariosResponse listBillScenarios(Consumer<ListBillScenariosRequest.Builder> listBillScenariosRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listBillScenarios(ListBillScenariosRequest.builder().applyMutation(listBillScenariosRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable responses = client.listBillScenariosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable responses = client
     *             .listBillScenariosPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable responses = client.listBillScenariosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillScenariosRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenariosIterable listBillScenariosPaginator(ListBillScenariosRequest listBillScenariosRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListBillScenariosIterable(this, listBillScenariosRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable responses = client.listBillScenariosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable responses = client
     *             .listBillScenariosPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListBillScenariosIterable responses = client.listBillScenariosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillScenarios(software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillScenariosRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillScenariosRequest#builder()}
     * </p>
     *
     * @param listBillScenariosRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillScenariosIterable listBillScenariosPaginator(
            Consumer<ListBillScenariosRequest.Builder> listBillScenariosRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return listBillScenariosPaginator(ListBillScenariosRequest.builder().applyMutation(listBillScenariosRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the usage associated with a workload estimate.
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     * @return Result of the ListWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimateUsageResponse listWorkloadEstimateUsage(
            ListWorkloadEstimateUsageRequest listWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the usage associated with a workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimateUsageRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return Result of the ListWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimateUsageResponse listWorkloadEstimateUsage(
            Consumer<ListWorkloadEstimateUsageRequest.Builder> listWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listWorkloadEstimateUsage(ListWorkloadEstimateUsageRequest.builder()
                .applyMutation(listWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable responses = client.listWorkloadEstimateUsagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable responses = client
     *             .listWorkloadEstimateUsagePaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable responses = client.listWorkloadEstimateUsagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimateUsageIterable listWorkloadEstimateUsagePaginator(
            ListWorkloadEstimateUsageRequest listWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListWorkloadEstimateUsageIterable(this, listWorkloadEstimateUsageRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable responses = client.listWorkloadEstimateUsagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable responses = client
     *             .listWorkloadEstimateUsagePaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimateUsageIterable responses = client.listWorkloadEstimateUsagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimateUsage(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimateUsageRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkloadEstimateUsageRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimateUsageIterable listWorkloadEstimateUsagePaginator(
            Consumer<ListWorkloadEstimateUsageRequest.Builder> listWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return listWorkloadEstimateUsagePaginator(ListWorkloadEstimateUsageRequest.builder()
                .applyMutation(listWorkloadEstimateUsageRequest).build());
    }

    /**
     * <p>
     * Lists all workload estimates for the account.
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     * @return Result of the ListWorkloadEstimates operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimatesResponse listWorkloadEstimates(ListWorkloadEstimatesRequest listWorkloadEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all workload estimates for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadEstimatesRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest.Builder} to
     *        create a request.
     * @return Result of the ListWorkloadEstimates operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimatesResponse listWorkloadEstimates(
            Consumer<ListWorkloadEstimatesRequest.Builder> listWorkloadEstimatesRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return listWorkloadEstimates(ListWorkloadEstimatesRequest.builder().applyMutation(listWorkloadEstimatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable responses = client.listWorkloadEstimatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable responses = client
     *             .listWorkloadEstimatesPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable responses = client.listWorkloadEstimatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimatesIterable listWorkloadEstimatesPaginator(ListWorkloadEstimatesRequest listWorkloadEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return new ListWorkloadEstimatesIterable(this, listWorkloadEstimatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable responses = client.listWorkloadEstimatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable responses = client
     *             .listWorkloadEstimatesPaginator(request);
     *     for (software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmpricingcalculator.paginators.ListWorkloadEstimatesIterable responses = client.listWorkloadEstimatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadEstimates(software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadEstimatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadEstimatesRequest#builder()}
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadEstimatesIterable listWorkloadEstimatesPaginator(
            Consumer<ListWorkloadEstimatesRequest.Builder> listWorkloadEstimatesRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        return listWorkloadEstimatesPaginator(ListWorkloadEstimatesRequest.builder().applyMutation(listWorkloadEstimatesRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing bill estimate.
     * </p>
     *
     * @param updateBillEstimateRequest
     * @return Result of the UpdateBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBillEstimateResponse updateBillEstimate(UpdateBillEstimateRequest updateBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bill estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillEstimateRequest#builder()}
     * </p>
     *
     * @param updateBillEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBillEstimateResponse updateBillEstimate(Consumer<UpdateBillEstimateRequest.Builder> updateBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return updateBillEstimate(UpdateBillEstimateRequest.builder().applyMutation(updateBillEstimateRequest).build());
    }

    /**
     * <p>
     * Updates an existing bill scenario.
     * </p>
     *
     * @param updateBillScenarioRequest
     * @return Result of the UpdateBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBillScenarioResponse updateBillScenario(UpdateBillScenarioRequest updateBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bill scenario.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillScenarioRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillScenarioRequest#builder()}
     * </p>
     *
     * @param updateBillScenarioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBillScenarioResponse updateBillScenario(Consumer<UpdateBillScenarioRequest.Builder> updateBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        return updateBillScenario(UpdateBillScenarioRequest.builder().applyMutation(updateBillScenarioRequest).build());
    }

    /**
     * <p>
     * Updates the preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     *
     * @param updatePreferencesRequest
     * @return Result of the UpdatePreferences operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePreferencesResponse updatePreferences(UpdatePreferencesRequest updatePreferencesRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the preferences for the Amazon Web Services Cost Explorer service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePreferencesRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePreferencesRequest#builder()}
     * </p>
     *
     * @param updatePreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesRequest.Builder} to
     *        create a request.
     * @return Result of the UpdatePreferences operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePreferencesResponse updatePreferences(Consumer<UpdatePreferencesRequest.Builder> updatePreferencesRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return updatePreferences(UpdatePreferencesRequest.builder().applyMutation(updatePreferencesRequest).build());
    }

    /**
     * <p>
     * Updates an existing workload estimate.
     * </p>
     *
     * @param updateWorkloadEstimateRequest
     * @return Result of the UpdateWorkloadEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadEstimateResponse updateWorkloadEstimate(UpdateWorkloadEstimateRequest updateWorkloadEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing workload estimate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadEstimateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkloadEstimateRequest#builder()}
     * </p>
     *
     * @param updateWorkloadEstimateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateWorkloadEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadEstimateResponse updateWorkloadEstimate(
            Consumer<UpdateWorkloadEstimateRequest.Builder> updateWorkloadEstimateRequest) throws ConflictException,
            ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        return updateWorkloadEstimate(UpdateWorkloadEstimateRequest.builder().applyMutation(updateWorkloadEstimateRequest)
                .build());
    }

    /**
     * Create a {@link BcmPricingCalculatorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BcmPricingCalculatorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BcmPricingCalculatorClient}.
     */
    static BcmPricingCalculatorClientBuilder builder() {
        return new DefaultBcmPricingCalculatorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BcmPricingCalculatorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
